/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.cache.FederationCache;
import org.apache.hadoop.yarn.server.federation.cache.FederationJCache;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMDTSecretManagerState;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreTestUtil;
import org.ehcache.Cache;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestFederationStateStoreFacade {
    private final long clusterTs = System.currentTimeMillis();
    private final int numSubClusters = 3;
    private final int numApps = 5;
    private final int numQueues = 2;
    private Configuration conf;
    private FederationStateStore stateStore;
    private FederationStateStoreTestUtil stateStoreTestUtil;
    private FederationStateStoreFacade facade;
    private Boolean isCachingEnabled;

    public static Collection<Boolean[]> getParameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    private void initTestFederationStateStoreFacade(Boolean pIsCachingEnabled) throws IOException, YarnException {
        this.conf = new Configuration();
        if (!pIsCachingEnabled.booleanValue()) {
            this.conf.setInt("yarn.federation.cache-ttl.secs", 0);
        }
        this.isCachingEnabled = pIsCachingEnabled;
        this.facade = FederationStateStoreFacade.getInstance((Configuration)this.conf);
        this.setUp();
    }

    public void setUp() throws IOException, YarnException {
        this.stateStore = new MemoryFederationStateStore();
        this.stateStore.init(this.conf);
        this.facade.reinitialize(this.stateStore, this.conf);
        this.stateStoreTestUtil = new FederationStateStoreTestUtil(this.stateStore);
        this.stateStoreTestUtil.registerSubClusters(3);
        this.stateStoreTestUtil.addAppsHomeSC(this.clusterTs, 5);
        this.stateStoreTestUtil.addPolicyConfigs(2);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.stateStore.close();
        this.stateStore = null;
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetSubCluster(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        for (int i = 0; i < 3; ++i) {
            SubClusterId subClusterId = SubClusterId.newInstance((String)("SC-" + i));
            Assertions.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), (Object)this.facade.getSubCluster(subClusterId));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testInvalidGetSubCluster(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"dummy");
        Assertions.assertNull((Object)this.facade.getSubCluster(subClusterId));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetSubClusterFlushCache(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        for (int i = 0; i < 3; ++i) {
            SubClusterId subClusterId = SubClusterId.newInstance((String)("SC-" + i));
            Assertions.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), (Object)this.facade.getSubCluster(subClusterId, true));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetSubClusters(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        Map subClusters = this.facade.getSubClusters(false);
        for (SubClusterId subClusterId : subClusters.keySet()) {
            Assertions.assertEquals((Object)this.stateStoreTestUtil.querySubClusterInfo(subClusterId), subClusters.get(subClusterId));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetPolicyConfiguration(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        for (int i = 0; i < 2; ++i) {
            String queue = "queue-" + i;
            Assertions.assertEquals((Object)this.stateStoreTestUtil.queryPolicyConfiguration(queue), (Object)this.facade.getPolicyConfiguration(queue));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testSubClustersCache(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        Map allClusters = this.facade.getSubClusters(false);
        Assertions.assertEquals((int)3, (int)allClusters.size());
        SubClusterId clusterId = (SubClusterId)new ArrayList(allClusters.keySet()).get(0);
        this.stateStoreTestUtil.deRegisterSubCluster(clusterId);
        Map activeClusters = this.facade.getSubClusters(true);
        Assertions.assertEquals((int)2, (int)activeClusters.size());
        allClusters = this.facade.getSubClusters(false);
        Assertions.assertEquals((int)3, (int)allClusters.size());
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testInvalidGetPolicyConfiguration(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        Assertions.assertNull((Object)this.facade.getPolicyConfiguration("dummy"));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetPoliciesConfigurations(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        Map queuePolicies = this.facade.getPoliciesConfigurations();
        for (String queue : queuePolicies.keySet()) {
            Assertions.assertEquals((Object)this.stateStoreTestUtil.queryPolicyConfiguration(queue), queuePolicies.get(queue));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetHomeSubClusterForApp(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        for (int i = 0; i < 5; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)i);
            Assertions.assertEquals((Object)this.stateStoreTestUtil.queryApplicationHomeSC(appId), (Object)this.facade.getApplicationHomeSubCluster(appId));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testAddApplicationHomeSubCluster(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)6);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"Home1");
        ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        SubClusterId result = this.facade.addApplicationHomeSubCluster(appHomeSubCluster);
        Assertions.assertEquals((Object)this.facade.getApplicationHomeSubCluster(appId), (Object)result);
        Assertions.assertEquals((Object)subClusterId1, (Object)result);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"Home2");
        appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId2);
        result = this.facade.addApplicationHomeSubCluster(appHomeSubCluster);
        Assertions.assertEquals((Object)this.facade.getApplicationHomeSubCluster(appId), (Object)result);
        Assertions.assertEquals((Object)subClusterId1, (Object)result);
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetApplicationHomeSubClusterCache(Boolean pIsCachingEnabled) throws Exception {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)6);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"Home1");
        ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        SubClusterId subClusterIdAdd = this.facade.addApplicationHomeSubCluster(appHomeSubCluster);
        SubClusterId subClusterIdByFacade = this.facade.getApplicationHomeSubCluster(appId);
        Assertions.assertEquals((Object)subClusterIdByFacade, (Object)subClusterIdAdd);
        Assertions.assertEquals((Object)subClusterId1, (Object)subClusterIdAdd);
        if (this.isCachingEnabled.booleanValue()) {
            FederationCache fedCache = this.facade.getFederationCache();
            assert (fedCache instanceof FederationJCache);
            FederationJCache jCache = (FederationJCache)fedCache;
            String cacheKey = jCache.getAppHomeSubClusterCacheKey(appId);
            Cache cache = jCache.getCache();
            FederationCache.CacheRequest cacheRequest = (FederationCache.CacheRequest)cache.get((Object)cacheKey);
            FederationCache.ApplicationHomeSubClusterCacheResponse response = (FederationCache.ApplicationHomeSubClusterCacheResponse)FederationCache.ApplicationHomeSubClusterCacheResponse.class.cast(cacheRequest.getValue());
            SubClusterId subClusterIdByCache = response.getItem();
            Assertions.assertEquals((Object)subClusterIdByFacade, (Object)subClusterIdByCache);
            Assertions.assertEquals((Object)subClusterId1, (Object)subClusterIdByCache);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testStoreNewMasterKey(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        this.facade.storeNewMasterKey(key);
        MemoryFederationStateStore federationStateStore = (MemoryFederationStateStore)this.facade.getStateStore();
        RouterRMDTSecretManagerState secretManagerState = federationStateStore.getRouterRMSecretManagerState();
        Assertions.assertEquals(keySet, (Object)secretManagerState.getMasterKeyState());
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testRemoveStoredMasterKey(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        DelegationKey key = new DelegationKey(4567, 7654L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        this.facade.storeNewMasterKey(key);
        this.facade.removeStoredMasterKey(key);
        keySet.clear();
        MemoryFederationStateStore federationStateStore = (MemoryFederationStateStore)this.facade.getStateStore();
        RouterRMDTSecretManagerState secretManagerState = federationStateStore.getRouterRMSecretManagerState();
        Assertions.assertEquals(keySet, (Object)secretManagerState.getMasterKeyState());
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testStoreNewToken(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner1"), new Text("renewer1"), new Text("realuser1"));
        int sequenceNumber = 1;
        dtId1.setSequenceNumber(sequenceNumber);
        Long renewDate1 = Time.now();
        this.facade.storeNewToken(dtId1, renewDate1.longValue());
        RouterStoreToken routerStoreToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)dtId1, (Long)renewDate1);
        RouterRMTokenRequest rmTokenRequest = RouterRMTokenRequest.newInstance((RouterStoreToken)routerStoreToken);
        RouterRMTokenResponse rmTokenResponse = this.stateStore.getTokenByRouterStoreToken(rmTokenRequest);
        Assertions.assertNotNull((Object)rmTokenResponse);
        RouterStoreToken resultStoreToken = rmTokenResponse.getRouterStoreToken();
        YARNDelegationTokenIdentifier resultTokenIdentifier = resultStoreToken.getTokenIdentifier();
        Assertions.assertNotNull((Object)resultStoreToken);
        Assertions.assertNotNull((Object)resultTokenIdentifier);
        Assertions.assertNotNull((Object)resultStoreToken.getRenewDate());
        Assertions.assertEquals((Object)dtId1, (Object)resultTokenIdentifier);
        Assertions.assertEquals((Long)renewDate1, (Long)resultStoreToken.getRenewDate());
        Assertions.assertEquals((int)sequenceNumber, (int)resultTokenIdentifier.getSequenceNumber());
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testUpdateNewToken(Boolean pIsCachingEnabled) throws YarnException, IOException {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner2"), new Text("renewer2"), new Text("realuser2"));
        int sequenceNumber = 2;
        dtId1.setSequenceNumber(sequenceNumber);
        Long renewDate1 = Time.now();
        this.facade.storeNewToken(dtId1, renewDate1.longValue());
        Long renewDate2 = Time.now();
        int sequenceNumber2 = 3;
        dtId1.setSequenceNumber(sequenceNumber2);
        this.facade.updateStoredToken(dtId1, renewDate2.longValue());
        RouterStoreToken routerStoreToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)dtId1, (Long)renewDate1);
        RouterRMTokenRequest rmTokenRequest = RouterRMTokenRequest.newInstance((RouterStoreToken)routerStoreToken);
        RouterRMTokenResponse rmTokenResponse = this.stateStore.getTokenByRouterStoreToken(rmTokenRequest);
        Assertions.assertNotNull((Object)rmTokenResponse);
        RouterStoreToken resultStoreToken = rmTokenResponse.getRouterStoreToken();
        YARNDelegationTokenIdentifier resultTokenIdentifier = resultStoreToken.getTokenIdentifier();
        Assertions.assertNotNull((Object)resultStoreToken);
        Assertions.assertNotNull((Object)resultTokenIdentifier);
        Assertions.assertNotNull((Object)resultStoreToken.getRenewDate());
        Assertions.assertEquals((Object)dtId1, (Object)resultTokenIdentifier);
        Assertions.assertEquals((Long)renewDate2, (Long)resultStoreToken.getRenewDate());
        Assertions.assertEquals((int)sequenceNumber2, (int)resultTokenIdentifier.getSequenceNumber());
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testRemoveStoredToken(Boolean pIsCachingEnabled) throws Exception {
        this.initTestFederationStateStoreFacade(pIsCachingEnabled);
        RMDelegationTokenIdentifier dtId1 = new RMDelegationTokenIdentifier(new Text("owner3"), new Text("renewer3"), new Text("realuser3"));
        int sequenceNumber = 3;
        dtId1.setSequenceNumber(sequenceNumber);
        Long renewDate1 = Time.now();
        this.facade.storeNewToken(dtId1, renewDate1.longValue());
        RouterStoreToken routerStoreToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)dtId1, (Long)renewDate1);
        RouterRMTokenRequest rmTokenRequest = RouterRMTokenRequest.newInstance((RouterStoreToken)routerStoreToken);
        RouterRMTokenResponse rmTokenResponse = this.stateStore.getTokenByRouterStoreToken(rmTokenRequest);
        Assertions.assertNotNull((Object)rmTokenResponse);
        RouterStoreToken resultStoreToken = rmTokenResponse.getRouterStoreToken();
        YARNDelegationTokenIdentifier resultTokenIdentifier = resultStoreToken.getTokenIdentifier();
        Assertions.assertNotNull((Object)resultStoreToken);
        Assertions.assertNotNull((Object)resultTokenIdentifier);
        Assertions.assertNotNull((Object)resultStoreToken.getRenewDate());
        Assertions.assertEquals((Object)dtId1, (Object)resultTokenIdentifier);
        Assertions.assertEquals((Long)renewDate1, (Long)resultStoreToken.getRenewDate());
        Assertions.assertEquals((int)sequenceNumber, (int)resultTokenIdentifier.getSequenceNumber());
        this.facade.removeStoredToken(dtId1);
        LambdaTestUtils.intercept(IOException.class, (String)("RMDelegationToken: " + dtId1 + " does not exist."), () -> this.stateStore.getTokenByRouterStoreToken(rmTokenRequest));
    }
}

