/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.utils;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.impl.FSRegistryOperationsService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationRegistryClient;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFederationRegistryClient {
    private Configuration conf;
    private UserGroupInformation user;
    private RegistryOperations registry;
    private FederationRegistryClient registryClient;

    @BeforeEach
    public void setup() throws Exception {
        this.conf = new YarnConfiguration();
        this.registry = new FSRegistryOperationsService();
        this.registry.init(this.conf);
        this.registry.start();
        this.user = UserGroupInformation.getCurrentUser();
        this.registryClient = new FederationRegistryClient(this.conf, this.registry, this.user);
        this.registryClient.cleanAllApplications();
        Assertions.assertEquals((int)0, (int)this.registryClient.getAllApplications().size());
    }

    @AfterEach
    public void breakDown() {
        this.registryClient.cleanAllApplications();
        Assertions.assertEquals((int)0, (int)this.registryClient.getAllApplications().size());
        this.registry.stop();
    }

    @Test
    public void testBasicCase() {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)0);
        String scId1 = "subcluster1";
        String scId2 = "subcluster2";
        this.registryClient.writeAMRMTokenForUAM(appId, scId1, new Token());
        this.registryClient.writeAMRMTokenForUAM(appId, scId2, new Token());
        this.registryClient.writeAMRMTokenForUAM(appId, scId1, new Token());
        Assertions.assertEquals((int)1, (int)this.registryClient.getAllApplications().size());
        Assertions.assertEquals((int)2, (int)this.registryClient.loadStateFromRegistry(appId).size());
        this.registryClient.removeAppFromRegistry(appId);
        Assertions.assertEquals((int)0, (int)this.registryClient.getAllApplications().size());
        Assertions.assertEquals((int)0, (int)this.registryClient.loadStateFromRegistry(appId).size());
    }

    @Test
    public void testRemoveWithMemoryState() {
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)0);
        ApplicationId appId2 = ApplicationId.newInstance((long)0L, (int)1);
        String scId0 = "subcluster0";
        this.registryClient.writeAMRMTokenForUAM(appId1, scId0, new Token());
        this.registryClient.writeAMRMTokenForUAM(appId2, scId0, new Token());
        Assertions.assertEquals((int)2, (int)this.registryClient.getAllApplications().size());
        this.registryClient = new FederationRegistryClient(this.conf, this.registry, this.user);
        this.registryClient.loadStateFromRegistry(appId2);
        this.registryClient.removeAppFromRegistry(appId2, false);
        Assertions.assertEquals((int)1, (int)this.registryClient.getAllApplications().size());
        this.registryClient.removeAppFromRegistry(appId1, false);
        Assertions.assertEquals((int)1, (int)this.registryClient.getAllApplications().size());
        this.registryClient.removeAppFromRegistry(appId1, true);
        Assertions.assertEquals((int)0, (int)this.registryClient.getAllApplications().size());
    }
}

