/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.sql;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.yarn.server.federation.store.impl.SQLServerFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.sql.FederationSQLAccuracyTest;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFederationSQLServerScriptAccuracy
extends FederationSQLAccuracyTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestFederationSQLServerScriptAccuracy.class);
    private static final String SQLSERVER_COMPATIBILITY = ";sql.syntax_mss=true";

    protected SQLServerFederationStateStore createStateStore() {
        return new SQLServerFederationStateStore();
    }

    @Override
    protected String getSQLURL() {
        return "jdbc:hsqldb:mem:state" + System.currentTimeMillis() + SQLSERVER_COMPATIBILITY;
    }

    @Test
    public void checkSqlServerScriptAccuracy() throws SQLException {
        SQLServerFederationStateStore federationStateStore = this.createStateStore();
        federationStateStore.init(this.getConf());
        List<String> tables = federationStateStore.getTables();
        for (String table : tables) {
            federationStateStore.getConn().prepareStatement(table).execute();
        }
        LOG.info("FederationStateStore create {} tables.", (Object)tables.size());
    }
}

