/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.sql;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class FederationSQLAccuracyTest {
    protected static final String HSQLDB_DRIVER = "org.hsqldb.jdbc.JDBCDataSource";
    protected static final String DATABASE_URL = "jdbc:hsqldb:mem:state";
    protected static final String DATABASE_USERNAME = "SA";
    protected static final String DATABASE_PASSWORD = "";
    private FederationStateStore stateStore;
    private Configuration conf;

    protected abstract FederationStateStore createStateStore();

    @BeforeEach
    public void before() throws IOException, YarnException {
        this.stateStore = this.createStateStore();
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.federation.state-store.sql.jdbc-class", HSQLDB_DRIVER);
        this.conf.set("yarn.federation.state-store.sql.username", DATABASE_USERNAME);
        this.conf.set("yarn.federation.state-store.sql.password", DATABASE_PASSWORD);
        this.conf.set("yarn.federation.state-store.sql.url", this.getSQLURL());
        this.stateStore.init(this.conf);
    }

    @AfterEach
    public void after() throws Exception {
        this.stateStore.close();
    }

    protected abstract String getSQLURL();

    protected void setConf(Configuration conf) {
        this.conf = conf;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected FederationStateStore getStateStore() {
        return this.stateStore;
    }
}

