/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecords;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.FederationStateStoreBaseTest;
import org.apache.hadoop.yarn.server.federation.store.impl.ZKFederationStateStoreOpDurations;
import org.apache.hadoop.yarn.server.federation.store.impl.ZookeeperFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.util.Records;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZookeeperFederationStateStore
extends FederationStateStoreBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestZookeeperFederationStateStore.class);
    private static final String ZNODE_FEDERATIONSTORE = "/federationstore";
    private static final String ZNODE_ROUTER_RM_DT_SECRET_MANAGER_ROOT = "/router_rm_dt_secret_manager_root";
    private static final String ZNODE_ROUTER_RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME = "/router_rm_delegation_tokens_root";
    private static final String ZNODE_ROUTER_RM_DT_MASTER_KEYS_ROOT_ZNODE_NAME = "/router_rm_dt_master_keys_root/";
    private static final String ROUTER_RM_DELEGATION_TOKEN_PREFIX = "rm_delegation_token_";
    private static final String ROUTER_RM_DELEGATION_KEY_PREFIX = "delegation_key_";
    private static final String ZNODE_DT_PREFIX = "/federationstore/router_rm_dt_secret_manager_root/router_rm_delegation_tokens_root";
    private static final String ZNODE_MASTER_KEY_PREFIX = "/federationstore/router_rm_dt_secret_manager_root/router_rm_dt_master_keys_root/";
    private static TestingServer curatorTestingServer;
    private static CuratorFramework curatorFramework;

    @Override
    @BeforeEach
    public void before() throws IOException, YarnException {
        try {
            curatorTestingServer = new TestingServer();
            curatorTestingServer.start();
            String connectString = curatorTestingServer.getConnectString();
            curatorFramework = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
            curatorFramework.start();
            YarnConfiguration conf = new YarnConfiguration();
            conf.set("yarn.federation.state-store.zk.address", connectString);
            conf.setInt("yarn.federation.state-store.max-applications", 10);
            this.setConf((Configuration)conf);
        }
        catch (Exception e) {
            LOG.error("Cannot initialize ZooKeeper store", (Throwable)e);
            throw new IOException(e);
        }
        super.before();
    }

    @Override
    @AfterEach
    public void after() throws Exception {
        super.after();
        curatorFramework.close();
        try {
            curatorTestingServer.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected FederationStateStore createStateStore() {
        super.setConf(this.getConf());
        return new ZookeeperFederationStateStore();
    }

    @Test
    public void testMetricsInited() throws Exception {
        ZookeeperFederationStateStore zkStateStore = (ZookeeperFederationStateStore)this.createStateStore();
        zkStateStore.resetOpDurations();
        ZKFederationStateStoreOpDurations zkStateStoreOpDurations = zkStateStore.getOpDurations();
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        long anyDuration = 10L;
        long start = Time.now();
        long end = start + anyDuration;
        zkStateStoreOpDurations.addAppHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addUpdateAppHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addGetAppHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addGetAppsHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addDeleteAppHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addRegisterSubClusterDuration(start, end);
        zkStateStoreOpDurations.addDeregisterSubClusterDuration(start, end);
        zkStateStoreOpDurations.addSubClusterHeartbeatDuration(start, end);
        zkStateStoreOpDurations.addGetSubClusterDuration(start, end);
        zkStateStoreOpDurations.addGetSubClustersDuration(start, end);
        zkStateStoreOpDurations.addGetPolicyConfigurationDuration(start, end);
        zkStateStoreOpDurations.addSetPolicyConfigurationDuration(start, end);
        zkStateStoreOpDurations.addGetPoliciesConfigurationsDuration(start, end);
        zkStateStoreOpDurations.addReservationHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addGetReservationHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addGetReservationsHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addDeleteReservationHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.addUpdateReservationHomeSubClusterDuration(start, end);
        zkStateStoreOpDurations.getMetrics((MetricsCollector)collector, true);
        Assertions.assertEquals((int)1, (int)collector.getRecords().size(), (String)"Incorrect number of perf metrics");
        MetricsRecord record = (MetricsRecord)collector.getRecords().get(0);
        MetricsRecords.assertTag((MetricsRecord)record, (String)ZKFederationStateStoreOpDurations.RECORD_INFO.name(), (String)"ZKFederationStateStoreOpDurations");
        double expectAvgTime = anyDuration;
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"AddAppHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"UpdateAppHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetAppHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetAppsHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeleteAppHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"RegisterSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeregisterSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"SubClusterHeartbeatAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetSubClustersAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetPolicyConfigurationAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"SetPolicyConfigurationAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetPoliciesConfigurationsAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"AddReservationHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetReservationHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetReservationsHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeleteReservationHomeSubClusterAvgTime", (Number)expectAvgTime);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"UpdateReservationHomeSubClusterAvgTime", (Number)expectAvgTime);
        long expectOps = 1L;
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"AddAppHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"UpdateAppHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetAppHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetAppsHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeleteAppHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"RegisterSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeregisterSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"SubClusterHeartbeatNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetSubClustersNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetPolicyConfigurationNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"SetPolicyConfigurationNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetPoliciesConfigurationsNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"AddReservationHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetReservationHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"GetReservationsHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"DeleteReservationHomeSubClusterNumOps", (Number)expectOps);
        MetricsRecords.assertMetric((MetricsRecord)record, (String)"UpdateReservationHomeSubClusterNumOps", (Number)expectOps);
    }

    private RouterStoreToken getStoreTokenFromZK(String nodePath) throws YarnException {
        try {
            byte[] data = (byte[])curatorFramework.getData().forPath(nodePath);
            if (data == null || data.length == 0) {
                return null;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            RouterStoreToken storeToken = (RouterStoreToken)Records.newRecord(RouterStoreToken.class);
            storeToken.readFields((DataInput)din);
            return storeToken;
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    private RouterMasterKey getRouterMasterKeyFromZK(String nodePath) throws YarnException {
        try {
            byte[] data = (byte[])curatorFramework.getData().forPath(nodePath);
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            DataInputStream din = new DataInputStream(bin);
            DelegationKey zkDT = new DelegationKey();
            zkDT.readFields((DataInput)din);
            RouterMasterKey zkRouterMasterKey = RouterMasterKey.newInstance((Integer)zkDT.getKeyId(), (ByteBuffer)ByteBuffer.wrap(zkDT.getEncodedKey()), (Long)zkDT.getExpiryDate());
            return zkRouterMasterKey;
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    private boolean isExists(String path) throws YarnException {
        try {
            return curatorFramework.checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            throw new YarnException((Throwable)e);
        }
    }

    @Override
    protected void checkRouterMasterKey(DelegationKey delegationKey, RouterMasterKey routerMasterKey) throws YarnException, IOException {
        RouterMasterKeyRequest routerMasterKeyRequest = RouterMasterKeyRequest.newInstance((RouterMasterKey)routerMasterKey);
        String nodeName = ROUTER_RM_DELEGATION_KEY_PREFIX + delegationKey.getKeyId();
        String nodePath = ZNODE_MASTER_KEY_PREFIX + nodeName;
        RouterMasterKey zkRouterMasterKey = this.getRouterMasterKeyFromZK(nodePath);
        RouterMasterKeyResponse response = this.getStateStore().getMasterKeyByDelegationKey(routerMasterKeyRequest);
        Assertions.assertNotNull((Object)response);
        RouterMasterKey respRouterMasterKey = response.getRouterMasterKey();
        Assertions.assertEquals((Object)routerMasterKey, (Object)respRouterMasterKey);
        Assertions.assertEquals((Object)routerMasterKey, (Object)zkRouterMasterKey);
        Assertions.assertEquals((Object)zkRouterMasterKey, (Object)respRouterMasterKey);
    }

    @Override
    protected void checkRouterStoreToken(RMDelegationTokenIdentifier identifier, RouterStoreToken token) throws YarnException, IOException {
        String nodeName = ROUTER_RM_DELEGATION_TOKEN_PREFIX + identifier.getSequenceNumber();
        String nodePath = ZKCuratorManager.getNodePath((String)ZNODE_DT_PREFIX, (String)nodeName);
        Assertions.assertTrue((boolean)this.isExists(nodePath));
        RouterStoreToken zkRouterStoreToken = this.getStoreTokenFromZK(nodePath);
        Assertions.assertNotNull((Object)zkRouterStoreToken);
        Assertions.assertEquals((Object)token, (Object)zkRouterStoreToken);
    }
}

