/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.FederationStateStoreBaseTest;
import org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMDTSecretManagerState;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.junit.jupiter.api.Assertions;

public class TestMemoryFederationStateStore
extends FederationStateStoreBaseTest {
    @Override
    protected FederationStateStore createStateStore() {
        Configuration conf = new Configuration();
        conf.setInt("yarn.federation.state-store.max-applications", 10);
        super.setConf(conf);
        return new MemoryFederationStateStore();
    }

    @Override
    protected void checkRouterMasterKey(DelegationKey delegationKey, RouterMasterKey routerMasterKey) throws YarnException, IOException {
        MemoryFederationStateStore memoryStateStore = (MemoryFederationStateStore)MemoryFederationStateStore.class.cast(this.getStateStore());
        RouterRMDTSecretManagerState secretManagerState = memoryStateStore.getRouterRMSecretManagerState();
        Assertions.assertNotNull((Object)secretManagerState);
        Set delegationKeys = secretManagerState.getMasterKeyState();
        Assertions.assertNotNull((Object)delegationKeys);
        Assertions.assertTrue((boolean)delegationKeys.contains(delegationKey));
        RouterMasterKey resultRouterMasterKey = RouterMasterKey.newInstance((Integer)delegationKey.getKeyId(), (ByteBuffer)ByteBuffer.wrap(delegationKey.getEncodedKey()), (Long)delegationKey.getExpiryDate());
        Assertions.assertEquals((Object)resultRouterMasterKey, (Object)routerMasterKey);
    }

    @Override
    protected void checkRouterStoreToken(RMDelegationTokenIdentifier identifier, RouterStoreToken token) throws YarnException, IOException {
        MemoryFederationStateStore memoryStateStore = (MemoryFederationStateStore)MemoryFederationStateStore.class.cast(this.getStateStore());
        RouterRMDTSecretManagerState secretManagerState = memoryStateStore.getRouterRMSecretManagerState();
        Assertions.assertNotNull((Object)secretManagerState);
        Map tokenStateMap = secretManagerState.getTokenState();
        Assertions.assertNotNull((Object)tokenStateMap);
        Assertions.assertTrue((boolean)tokenStateMap.containsKey(identifier));
        YARNDelegationTokenIdentifier tokenIdentifier = token.getTokenIdentifier();
        Assertions.assertTrue((boolean)(tokenIdentifier instanceof RMDelegationTokenIdentifier));
        Assertions.assertEquals((Object)identifier, (Object)tokenIdentifier);
    }
}

