/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreException;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.DeletePoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeletePoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class FederationStateStoreBaseTest {
    private static final MonotonicClock CLOCK = new MonotonicClock();
    private FederationStateStore stateStore;
    private static final int NUM_APPS_10 = 10;
    private static final int NUM_APPS_20 = 20;
    private Configuration conf;

    protected abstract FederationStateStore createStateStore();

    protected abstract void checkRouterMasterKey(DelegationKey var1, RouterMasterKey var2) throws YarnException, IOException, SQLException;

    protected abstract void checkRouterStoreToken(RMDelegationTokenIdentifier var1, RouterStoreToken var2) throws YarnException, IOException, SQLException;

    @BeforeEach
    public void before() throws IOException, YarnException {
        this.stateStore = this.createStateStore();
        this.stateStore.init(this.conf);
    }

    @AfterEach
    public void after() throws Exception {
        this.testDeleteStateStore();
        this.testDeletePolicyStore();
        this.stateStore.close();
    }

    @Test
    public void testRegisterSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        SubClusterInfo subClusterInfo = this.createSubClusterInfo(subClusterId);
        long previousTimeStamp = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        SubClusterRegisterResponse result = this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo));
        long currentTimeStamp = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)subClusterInfo, (Object)this.querySubClusterInfo(subClusterId));
        Assertions.assertTrue((this.querySubClusterInfo(subClusterId).getLastHeartBeat() <= currentTimeStamp ? 1 : 0) != 0);
        Assertions.assertTrue((this.querySubClusterInfo(subClusterId).getLastHeartBeat() >= previousTimeStamp ? 1 : 0) != 0);
    }

    @Test
    public void testDeregisterSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        this.registerSubCluster(this.createSubClusterInfo(subClusterId));
        SubClusterDeregisterRequest deregisterRequest = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_UNREGISTERED);
        this.stateStore.deregisterSubCluster(deregisterRequest);
        Assertions.assertEquals((Object)SubClusterState.SC_UNREGISTERED, (Object)this.querySubClusterInfo(subClusterId).getState());
    }

    @Test
    public void testDeregisterSubClusterUnknownSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        SubClusterDeregisterRequest deregisterRequest = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_UNREGISTERED);
        LambdaTestUtils.intercept(YarnException.class, (String)"SubCluster SC not found", () -> this.stateStore.deregisterSubCluster(deregisterRequest));
    }

    @Test
    public void testGetSubClusterInfo() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        SubClusterInfo subClusterInfo = this.createSubClusterInfo(subClusterId);
        this.registerSubCluster(subClusterInfo);
        GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId);
        Assertions.assertEquals((Object)subClusterInfo, (Object)this.stateStore.getSubCluster(request).getSubClusterInfo());
    }

    @Test
    public void testGetSubClusterInfoUnknownSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId);
        GetSubClusterInfoResponse response = this.stateStore.getSubCluster(request);
        Assertions.assertNull((Object)response);
    }

    @Test
    public void testGetAllSubClustersInfo() throws Exception {
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        SubClusterInfo subClusterInfo1 = this.createSubClusterInfo(subClusterId1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        SubClusterInfo subClusterInfo2 = this.createSubClusterInfo(subClusterId2);
        this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo1));
        this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo2));
        this.stateStore.subClusterHeartbeat(SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId1, (SubClusterState)SubClusterState.SC_RUNNING, (String)"capability"));
        this.stateStore.subClusterHeartbeat(SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId2, (SubClusterState)SubClusterState.SC_UNHEALTHY, (String)"capability"));
        List subClustersActive = this.stateStore.getSubClusters(GetSubClustersInfoRequest.newInstance((boolean)true)).getSubClusters();
        List subClustersAll = this.stateStore.getSubClusters(GetSubClustersInfoRequest.newInstance((boolean)false)).getSubClusters();
        Assertions.assertEquals((int)1, (int)subClustersActive.size());
        SubClusterInfo sc1 = (SubClusterInfo)subClustersActive.get(0);
        Assertions.assertEquals((Object)subClusterId1, (Object)sc1.getSubClusterId());
        Assertions.assertEquals((int)2, (int)subClustersAll.size());
        Assertions.assertTrue((boolean)subClustersAll.contains(sc1));
        subClustersAll.remove(sc1);
        SubClusterInfo sc2 = (SubClusterInfo)subClustersAll.get(0);
        Assertions.assertEquals((Object)subClusterId2, (Object)sc2.getSubClusterId());
    }

    @Test
    public void testSubClusterHeartbeat() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        this.registerSubCluster(this.createSubClusterInfo(subClusterId));
        long previousHeartBeat = this.querySubClusterInfo(subClusterId).getLastHeartBeat();
        SubClusterHeartbeatRequest heartbeatRequest = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_RUNNING, (String)"capability");
        this.stateStore.subClusterHeartbeat(heartbeatRequest);
        long currentTimeStamp = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        Assertions.assertEquals((Object)SubClusterState.SC_RUNNING, (Object)this.querySubClusterInfo(subClusterId).getState());
        Assertions.assertTrue((this.querySubClusterInfo(subClusterId).getLastHeartBeat() <= currentTimeStamp ? 1 : 0) != 0);
        Assertions.assertTrue((this.querySubClusterInfo(subClusterId).getLastHeartBeat() >= previousHeartBeat ? 1 : 0) != 0);
    }

    @Test
    public void testSubClusterHeartbeatUnknownSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        SubClusterHeartbeatRequest heartbeatRequest = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_RUNNING, (String)"capability");
        LambdaTestUtils.intercept(YarnException.class, (String)"SubCluster SC does not exist; cannot heartbeat", () -> this.stateStore.subClusterHeartbeat(heartbeatRequest));
    }

    @Test
    public void testAddApplicationHomeSubCluster() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId);
        AddApplicationHomeSubClusterRequest request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc);
        AddApplicationHomeSubClusterResponse response = this.stateStore.addApplicationHomeSubCluster(request);
        Assertions.assertEquals((Object)subClusterId, (Object)response.getHomeSubCluster());
        Assertions.assertEquals((Object)subClusterId, (Object)this.queryApplicationHomeSC(appId));
    }

    @Test
    public void testAddApplicationHomeSubClusterAppAlreadyExists() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        this.addApplicationHomeSC(appId, subClusterId1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ApplicationHomeSubCluster ahsc2 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId2);
        AddApplicationHomeSubClusterResponse response = this.stateStore.addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc2));
        Assertions.assertEquals((Object)subClusterId1, (Object)response.getHomeSubCluster());
        Assertions.assertEquals((Object)subClusterId1, (Object)this.queryApplicationHomeSC(appId));
    }

    @Test
    public void testAddApplicationHomeSubClusterAppAlreadyExistsInTheSameSC() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        this.addApplicationHomeSC(appId, subClusterId1);
        ApplicationHomeSubCluster ahsc2 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        AddApplicationHomeSubClusterResponse response = this.stateStore.addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc2));
        Assertions.assertEquals((Object)subClusterId1, (Object)response.getHomeSubCluster());
        Assertions.assertEquals((Object)subClusterId1, (Object)this.queryApplicationHomeSC(appId));
    }

    @Test
    public void testDeleteApplicationHomeSubCluster() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        this.addApplicationHomeSC(appId, subClusterId);
        DeleteApplicationHomeSubClusterRequest delRequest = DeleteApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        DeleteApplicationHomeSubClusterResponse response = this.stateStore.deleteApplicationHomeSubCluster(delRequest);
        Assertions.assertNotNull((Object)response);
        try {
            this.queryApplicationHomeSC(appId);
            Assertions.fail();
        }
        catch (FederationStateStoreException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Application " + appId + " does not exist"));
        }
    }

    @Test
    public void testDeleteApplicationHomeSubClusterUnknownApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        DeleteApplicationHomeSubClusterRequest delRequest = DeleteApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        try {
            this.stateStore.deleteApplicationHomeSubCluster(delRequest);
            Assertions.fail();
        }
        catch (FederationStateStoreException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Application " + appId.toString() + " does not exist"));
        }
    }

    @Test
    public void testGetApplicationHomeSubCluster() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        this.addApplicationHomeSC(appId, subClusterId);
        GetApplicationHomeSubClusterRequest getRequest = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        GetApplicationHomeSubClusterResponse result = this.stateStore.getApplicationHomeSubCluster(getRequest);
        Assertions.assertEquals((Object)appId, (Object)result.getApplicationHomeSubCluster().getApplicationId());
        Assertions.assertEquals((Object)subClusterId, (Object)result.getApplicationHomeSubCluster().getHomeSubCluster());
    }

    @Test
    public void testGetApplicationHomeSubClusterUnknownApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        GetApplicationHomeSubClusterRequest request = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        try {
            this.stateStore.getApplicationHomeSubCluster(request);
            Assertions.fail();
        }
        catch (FederationStateStoreException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Application " + appId.toString() + " does not exist"));
        }
    }

    @Test
    public void testGetApplicationsHomeSubCluster() throws Exception {
        ApplicationId appId1 = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        ApplicationHomeSubCluster ahsc1 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId1, (SubClusterId)subClusterId1);
        ApplicationId appId2 = ApplicationId.newInstance((long)1L, (int)2);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ApplicationHomeSubCluster ahsc2 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId2, (SubClusterId)subClusterId2);
        this.addApplicationHomeSC(appId1, subClusterId1);
        this.addApplicationHomeSC(appId2, subClusterId2);
        GetApplicationsHomeSubClusterRequest getRequest = GetApplicationsHomeSubClusterRequest.newInstance();
        GetApplicationsHomeSubClusterResponse result = this.stateStore.getApplicationsHomeSubCluster(getRequest);
        Assertions.assertEquals((int)2, (int)result.getAppsHomeSubClusters().size());
        Assertions.assertTrue((boolean)result.getAppsHomeSubClusters().contains(ahsc1));
        Assertions.assertTrue((boolean)result.getAppsHomeSubClusters().contains(ahsc2));
    }

    @Test
    public void testGetApplicationsHomeSubClusterEmpty() throws Exception {
        LambdaTestUtils.intercept(YarnException.class, (String)"Missing getApplicationsHomeSubCluster request", () -> this.stateStore.getApplicationsHomeSubCluster(null));
    }

    @Test
    public void testGetApplicationsHomeSubClusterFilter() throws Exception {
        SubClusterId subClusterId;
        ApplicationId appId;
        int i;
        long now = Time.now();
        HashSet<ApplicationHomeSubCluster> appHomeSubClusters = new HashSet<ApplicationHomeSubCluster>();
        for (i = 0; i < 10; ++i) {
            appId = ApplicationId.newInstance((long)now, (int)i);
            subClusterId = SubClusterId.newInstance((String)"SC1");
            this.addApplicationHomeSC(appId, subClusterId);
            ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId);
            appHomeSubClusters.add(ahsc);
        }
        for (i = 10; i < 20; ++i) {
            appId = ApplicationId.newInstance((long)now, (int)i);
            subClusterId = SubClusterId.newInstance((String)"SC2");
            this.addApplicationHomeSC(appId, subClusterId);
        }
        GetApplicationsHomeSubClusterRequest getRequest = GetApplicationsHomeSubClusterRequest.newInstance();
        getRequest.setSubClusterId(SubClusterId.newInstance((String)"SC1"));
        GetApplicationsHomeSubClusterResponse result = this.stateStore.getApplicationsHomeSubCluster(getRequest);
        Assertions.assertNotNull((Object)result);
        List items = result.getAppsHomeSubClusters();
        Assertions.assertNotNull((Object)items);
        Assertions.assertEquals((int)10, (int)items.size());
        for (ApplicationHomeSubCluster item : items) {
            appHomeSubClusters.contains(item);
            Assertions.assertTrue((boolean)appHomeSubClusters.contains(item));
        }
    }

    @Test
    public void testGetApplicationsHomeSubClusterLimit() throws Exception {
        long now = Time.now();
        for (int i = 0; i < 50; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)now, (int)i);
            SubClusterId subClusterId = SubClusterId.newInstance((String)"SC1");
            this.addApplicationHomeSC(appId, subClusterId);
        }
        GetApplicationsHomeSubClusterRequest getRequest = GetApplicationsHomeSubClusterRequest.newInstance();
        getRequest.setSubClusterId(SubClusterId.newInstance((String)"SC1"));
        GetApplicationsHomeSubClusterResponse result = this.stateStore.getApplicationsHomeSubCluster(getRequest);
        Assertions.assertNotNull((Object)result);
        List items = result.getAppsHomeSubClusters();
        Assertions.assertNotNull((Object)items);
        Assertions.assertEquals((int)10, (int)items.size());
        GetApplicationsHomeSubClusterRequest getRequest1 = GetApplicationsHomeSubClusterRequest.newInstance();
        getRequest1.setSubClusterId(SubClusterId.newInstance((String)"SC2"));
        GetApplicationsHomeSubClusterResponse result1 = this.stateStore.getApplicationsHomeSubCluster(getRequest1);
        Assertions.assertNotNull((Object)result1);
        List items1 = result1.getAppsHomeSubClusters();
        Assertions.assertNotNull((Object)items1);
        Assertions.assertEquals((int)0, (int)items1.size());
    }

    @Test
    public void testUpdateApplicationHomeSubCluster() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        this.addApplicationHomeSC(appId, subClusterId1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ApplicationHomeSubCluster ahscUpdate = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId2);
        UpdateApplicationHomeSubClusterRequest updateRequest = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahscUpdate);
        UpdateApplicationHomeSubClusterResponse response = this.stateStore.updateApplicationHomeSubCluster(updateRequest);
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)subClusterId2, (Object)this.queryApplicationHomeSC(appId));
    }

    @Test
    public void testUpdateApplicationHomeSubClusterUnknownApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        UpdateApplicationHomeSubClusterRequest updateRequest = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc);
        try {
            this.stateStore.updateApplicationHomeSubCluster(updateRequest);
            Assertions.fail();
        }
        catch (FederationStateStoreException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Application " + appId.toString() + " does not exist"));
        }
    }

    @Test
    public void testSetPolicyConfiguration() throws Exception {
        SetSubClusterPolicyConfigurationRequest request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)this.createSCPolicyConf("Queue", "PolicyType"));
        SetSubClusterPolicyConfigurationResponse result = this.stateStore.setPolicyConfiguration(request);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)this.createSCPolicyConf("Queue", "PolicyType"), (Object)this.queryPolicy("Queue"));
    }

    @Test
    public void testSetPolicyConfigurationUpdateExisting() throws Exception {
        this.setPolicyConf("Queue", "PolicyType1");
        SetSubClusterPolicyConfigurationRequest request2 = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)this.createSCPolicyConf("Queue", "PolicyType2"));
        SetSubClusterPolicyConfigurationResponse result = this.stateStore.setPolicyConfiguration(request2);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)this.createSCPolicyConf("Queue", "PolicyType2"), (Object)this.queryPolicy("Queue"));
    }

    @Test
    public void testGetPolicyConfiguration() throws Exception {
        this.setPolicyConf("Queue", "PolicyType");
        GetSubClusterPolicyConfigurationRequest getRequest = GetSubClusterPolicyConfigurationRequest.newInstance((String)"Queue");
        GetSubClusterPolicyConfigurationResponse result = this.stateStore.getPolicyConfiguration(getRequest);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)this.createSCPolicyConf("Queue", "PolicyType"), (Object)result.getPolicyConfiguration());
    }

    @Test
    public void testGetPolicyConfigurationUnknownQueue() throws Exception {
        GetSubClusterPolicyConfigurationRequest request = GetSubClusterPolicyConfigurationRequest.newInstance((String)"Queue");
        GetSubClusterPolicyConfigurationResponse response = this.stateStore.getPolicyConfiguration(request);
        Assertions.assertNull((Object)response);
    }

    @Test
    public void testGetPoliciesConfigurations() throws Exception {
        this.setPolicyConf("Queue1", "PolicyType1");
        this.setPolicyConf("Queue2", "PolicyType2");
        GetSubClusterPoliciesConfigurationsResponse response = this.stateStore.getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest.newInstance());
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.getPoliciesConfigs());
        Assertions.assertEquals((int)2, (int)response.getPoliciesConfigs().size());
        Assertions.assertTrue((boolean)response.getPoliciesConfigs().contains(this.createSCPolicyConf("Queue1", "PolicyType1")));
        Assertions.assertTrue((boolean)response.getPoliciesConfigs().contains(this.createSCPolicyConf("Queue2", "PolicyType2")));
    }

    SubClusterInfo createSubClusterInfo(SubClusterId subClusterId) {
        String amRMAddress = "1.2.3.4:1";
        String clientRMAddress = "1.2.3.4:2";
        String rmAdminAddress = "1.2.3.4:3";
        String webAppAddress = "1.2.3.4:4";
        return SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMAddress, (String)clientRMAddress, (String)rmAdminAddress, (String)webAppAddress, (SubClusterState)SubClusterState.SC_NEW, (long)CLOCK.getTime(), (String)"capability");
    }

    private SubClusterPolicyConfiguration createSCPolicyConf(String queueName, String policyType) {
        ByteBuffer bb = ByteBuffer.allocate(100);
        bb.put((byte)2);
        return SubClusterPolicyConfiguration.newInstance((String)queueName, (String)policyType, (ByteBuffer)bb);
    }

    void addApplicationHomeSC(ApplicationId appId, SubClusterId subClusterId) throws YarnException {
        ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId);
        AddApplicationHomeSubClusterRequest request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc);
        this.stateStore.addApplicationHomeSubCluster(request);
    }

    void addApplicationHomeSC(ApplicationId appId, SubClusterId subClusterId, ApplicationSubmissionContext submissionContext) throws YarnException {
        long createTime = Time.now();
        ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (long)createTime, (SubClusterId)subClusterId, (ApplicationSubmissionContext)submissionContext);
        AddApplicationHomeSubClusterRequest request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc);
        this.stateStore.addApplicationHomeSubCluster(request);
    }

    private void setPolicyConf(String queue, String policyType) throws YarnException {
        SetSubClusterPolicyConfigurationRequest request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)this.createSCPolicyConf(queue, policyType));
        this.stateStore.setPolicyConfiguration(request);
    }

    private void registerSubCluster(SubClusterInfo subClusterInfo) throws YarnException {
        this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo));
    }

    SubClusterInfo querySubClusterInfo(SubClusterId subClusterId) throws YarnException {
        GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId);
        return this.stateStore.getSubCluster(request).getSubClusterInfo();
    }

    SubClusterId queryApplicationHomeSC(ApplicationId appId) throws YarnException {
        GetApplicationHomeSubClusterRequest request = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        GetApplicationHomeSubClusterResponse response = this.stateStore.getApplicationHomeSubCluster(request);
        return response.getApplicationHomeSubCluster().getHomeSubCluster();
    }

    private SubClusterPolicyConfiguration queryPolicy(String queue) throws YarnException {
        GetSubClusterPolicyConfigurationRequest request = GetSubClusterPolicyConfigurationRequest.newInstance((String)queue);
        GetSubClusterPolicyConfigurationResponse result = this.stateStore.getPolicyConfiguration(request);
        return result.getPolicyConfiguration();
    }

    protected void setConf(Configuration conf) {
        this.conf = conf;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected FederationStateStore getStateStore() {
        return this.stateStore;
    }

    SubClusterId queryReservationHomeSC(ReservationId reservationId) throws YarnException {
        GetReservationHomeSubClusterRequest request = GetReservationHomeSubClusterRequest.newInstance((ReservationId)reservationId);
        GetReservationHomeSubClusterResponse response = this.stateStore.getReservationHomeSubCluster(request);
        return response.getReservationHomeSubCluster().getHomeSubCluster();
    }

    @Test
    public void testAddReservationHomeSubCluster() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId);
        AddReservationHomeSubClusterRequest request = AddReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster);
        AddReservationHomeSubClusterResponse response = this.stateStore.addReservationHomeSubCluster(request);
        Assertions.assertEquals((Object)subClusterId, (Object)response.getHomeSubCluster());
        Assertions.assertEquals((Object)subClusterId, (Object)this.queryReservationHomeSC(reservationId));
    }

    private void addReservationHomeSC(ReservationId reservationId, SubClusterId subClusterId) throws YarnException {
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId);
        AddReservationHomeSubClusterRequest request = AddReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster);
        this.stateStore.addReservationHomeSubCluster(request);
    }

    @Test
    public void testAddReservationHomeSubClusterReservationAlreadyExists() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        this.addReservationHomeSC(reservationId, subClusterId1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ReservationHomeSubCluster reservationHomeSubCluster2 = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId2);
        AddReservationHomeSubClusterRequest request2 = AddReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster2);
        AddReservationHomeSubClusterResponse response = this.stateStore.addReservationHomeSubCluster(request2);
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)subClusterId1, (Object)response.getHomeSubCluster());
        Assertions.assertEquals((Object)subClusterId1, (Object)this.queryReservationHomeSC(reservationId));
    }

    @Test
    public void testAddReservationHomeSubClusterAppAlreadyExistsInTheSameSC() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        this.addReservationHomeSC(reservationId, subClusterId1);
        ReservationHomeSubCluster reservationHomeSubCluster2 = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId1);
        AddReservationHomeSubClusterRequest request2 = AddReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster2);
        AddReservationHomeSubClusterResponse response = this.stateStore.addReservationHomeSubCluster(request2);
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)subClusterId1, (Object)response.getHomeSubCluster());
        Assertions.assertEquals((Object)subClusterId1, (Object)this.queryReservationHomeSC(reservationId));
    }

    @Test
    public void testDeleteReservationHomeSubCluster() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC");
        this.addReservationHomeSC(reservationId, subClusterId1);
        DeleteReservationHomeSubClusterRequest delReservationRequest = DeleteReservationHomeSubClusterRequest.newInstance((ReservationId)reservationId);
        DeleteReservationHomeSubClusterResponse delReservationResponse = this.stateStore.deleteReservationHomeSubCluster(delReservationRequest);
        Assertions.assertNotNull((Object)delReservationResponse);
        LambdaTestUtils.intercept(YarnException.class, (String)("Reservation " + reservationId + " does not exist"), () -> this.queryReservationHomeSC(reservationId));
    }

    @Test
    public void testDeleteReservationHomeSubClusterUnknownApp() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        DeleteReservationHomeSubClusterRequest delReservationRequest = DeleteReservationHomeSubClusterRequest.newInstance((ReservationId)reservationId);
        LambdaTestUtils.intercept(YarnException.class, (String)("Reservation " + reservationId + " does not exist"), () -> this.stateStore.deleteReservationHomeSubCluster(delReservationRequest));
    }

    @Test
    public void testUpdateReservationHomeSubCluster() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC");
        this.addReservationHomeSC(reservationId, subClusterId1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId2);
        UpdateReservationHomeSubClusterRequest updateReservationRequest = UpdateReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster);
        UpdateReservationHomeSubClusterResponse updateReservationResponse = this.stateStore.updateReservationHomeSubCluster(updateReservationRequest);
        Assertions.assertNotNull((Object)updateReservationResponse);
        Assertions.assertEquals((Object)subClusterId2, (Object)this.queryReservationHomeSC(reservationId));
    }

    @Test
    public void testUpdateReservationHomeSubClusterUnknownApp() throws Exception {
        ReservationId reservationId = ReservationId.newInstance((long)Time.now(), (long)1L);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        ReservationHomeSubCluster reservationHomeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)reservationId, (SubClusterId)subClusterId1);
        UpdateReservationHomeSubClusterRequest updateReservationRequest = UpdateReservationHomeSubClusterRequest.newInstance((ReservationHomeSubCluster)reservationHomeSubCluster);
        LambdaTestUtils.intercept(YarnException.class, (String)("Reservation " + reservationId + " does not exist"), () -> this.stateStore.updateReservationHomeSubCluster(updateReservationRequest));
    }

    @Test
    public void testStoreNewMasterKey() throws Exception {
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        RouterMasterKey routerMasterKey = RouterMasterKey.newInstance((Integer)key.getKeyId(), (ByteBuffer)ByteBuffer.wrap(key.getEncodedKey()), (Long)key.getExpiryDate());
        RouterMasterKeyRequest routerMasterKeyRequest = RouterMasterKeyRequest.newInstance((RouterMasterKey)routerMasterKey);
        RouterMasterKeyResponse response = this.stateStore.storeNewMasterKey(routerMasterKeyRequest);
        Assertions.assertNotNull((Object)response);
        RouterMasterKey routerMasterKeyResp = response.getRouterMasterKey();
        Assertions.assertNotNull((Object)routerMasterKeyResp);
        Assertions.assertEquals((Integer)routerMasterKey.getKeyId(), (Integer)routerMasterKeyResp.getKeyId());
        Assertions.assertEquals((Object)routerMasterKey.getKeyBytes(), (Object)routerMasterKeyResp.getKeyBytes());
        Assertions.assertEquals((Long)routerMasterKey.getExpiryDate(), (Long)routerMasterKeyResp.getExpiryDate());
        this.checkRouterMasterKey(key, routerMasterKey);
    }

    @Test
    public void testGetMasterKeyByDelegationKey() throws YarnException, IOException {
        DelegationKey key = new DelegationKey(5678, 8765L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        RouterMasterKey routerMasterKey = RouterMasterKey.newInstance((Integer)key.getKeyId(), (ByteBuffer)ByteBuffer.wrap(key.getEncodedKey()), (Long)key.getExpiryDate());
        RouterMasterKeyRequest routerMasterKeyRequest = RouterMasterKeyRequest.newInstance((RouterMasterKey)routerMasterKey);
        RouterMasterKeyResponse response = this.stateStore.storeNewMasterKey(routerMasterKeyRequest);
        Assertions.assertNotNull((Object)response);
        RouterMasterKeyResponse routerMasterKeyResponse = this.stateStore.getMasterKeyByDelegationKey(routerMasterKeyRequest);
        Assertions.assertNotNull((Object)routerMasterKeyResponse);
        RouterMasterKey routerMasterKeyResp = routerMasterKeyResponse.getRouterMasterKey();
        Assertions.assertNotNull((Object)routerMasterKeyResp);
        Assertions.assertEquals((Integer)routerMasterKey.getKeyId(), (Integer)routerMasterKeyResp.getKeyId());
        Assertions.assertEquals((Object)routerMasterKey.getKeyBytes(), (Object)routerMasterKeyResp.getKeyBytes());
        Assertions.assertEquals((Long)routerMasterKey.getExpiryDate(), (Long)routerMasterKeyResp.getExpiryDate());
    }

    @Test
    public void testRemoveStoredMasterKey() throws YarnException, IOException {
        DelegationKey key = new DelegationKey(1234, 4321L, "keyBytes".getBytes());
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.add(key);
        RouterMasterKey routerMasterKey = RouterMasterKey.newInstance((Integer)key.getKeyId(), (ByteBuffer)ByteBuffer.wrap(key.getEncodedKey()), (Long)key.getExpiryDate());
        RouterMasterKeyRequest routerMasterKeyRequest = RouterMasterKeyRequest.newInstance((RouterMasterKey)routerMasterKey);
        RouterMasterKeyResponse response = this.stateStore.storeNewMasterKey(routerMasterKeyRequest);
        Assertions.assertNotNull((Object)response);
        RouterMasterKeyResponse masterKeyResponse = this.stateStore.removeStoredMasterKey(routerMasterKeyRequest);
        Assertions.assertNotNull((Object)masterKeyResponse);
        RouterMasterKey routerMasterKeyResp = masterKeyResponse.getRouterMasterKey();
        Assertions.assertEquals((Integer)routerMasterKey.getKeyId(), (Integer)routerMasterKeyResp.getKeyId());
        Assertions.assertEquals((Object)routerMasterKey.getKeyBytes(), (Object)routerMasterKeyResp.getKeyBytes());
        Assertions.assertEquals((Long)routerMasterKey.getExpiryDate(), (Long)routerMasterKeyResp.getExpiryDate());
    }

    @Test
    public void testStoreNewToken() throws IOException, YarnException, SQLException {
        RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier(new Text("owner1"), new Text("renewer1"), new Text("realuser1"));
        int sequenceNumber = 1;
        identifier.setSequenceNumber(sequenceNumber);
        Long renewDate = Time.now();
        String tokenInfo = "tokenInfo";
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, (Long)renewDate, (String)tokenInfo);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance((RouterStoreToken)storeToken);
        RouterRMTokenResponse routerRMTokenResponse = this.stateStore.storeNewToken(request);
        Assertions.assertNotNull((Object)routerRMTokenResponse);
        RouterStoreToken storeTokenResp = routerRMTokenResponse.getRouterStoreToken();
        Assertions.assertNotNull((Object)storeTokenResp);
        Assertions.assertEquals((Long)storeToken.getRenewDate(), (Long)storeTokenResp.getRenewDate());
        Assertions.assertEquals((Object)storeToken.getTokenIdentifier(), (Object)storeTokenResp.getTokenIdentifier());
        Assertions.assertEquals((Object)storeToken.getTokenInfo(), (Object)storeTokenResp.getTokenInfo());
        this.checkRouterStoreToken(identifier, storeTokenResp);
    }

    @Test
    public void testUpdateStoredToken() throws IOException, YarnException, SQLException {
        RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier(new Text("owner2"), new Text("renewer2"), new Text("realuser2"));
        int sequenceNumber = 2;
        String tokenInfo = "tokenInfo";
        identifier.setSequenceNumber(sequenceNumber);
        Long renewDate = Time.now();
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, (Long)renewDate, (String)tokenInfo);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance((RouterStoreToken)storeToken);
        RouterRMTokenResponse routerRMTokenResponse = this.stateStore.storeNewToken(request);
        Assertions.assertNotNull((Object)routerRMTokenResponse);
        Long renewDate2 = Time.now();
        String tokenInfo2 = "tokenInfo2";
        RouterStoreToken updateToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, (Long)renewDate2, (String)tokenInfo2);
        RouterRMTokenRequest updateTokenRequest = RouterRMTokenRequest.newInstance((RouterStoreToken)updateToken);
        RouterRMTokenResponse updateTokenResponse = this.stateStore.updateStoredToken(updateTokenRequest);
        Assertions.assertNotNull((Object)updateTokenResponse);
        RouterStoreToken updateTokenResp = updateTokenResponse.getRouterStoreToken();
        Assertions.assertNotNull((Object)updateTokenResp);
        Assertions.assertEquals((Long)updateToken.getRenewDate(), (Long)updateTokenResp.getRenewDate());
        Assertions.assertEquals((Object)updateToken.getTokenIdentifier(), (Object)updateTokenResp.getTokenIdentifier());
        Assertions.assertEquals((Object)updateToken.getTokenInfo(), (Object)updateTokenResp.getTokenInfo());
        this.checkRouterStoreToken(identifier, updateTokenResp);
    }

    @Test
    public void testRemoveStoredToken() throws IOException, YarnException {
        RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier(new Text("owner3"), new Text("renewer3"), new Text("realuser3"));
        int sequenceNumber = 3;
        identifier.setSequenceNumber(sequenceNumber);
        Long renewDate = Time.now();
        String tokenInfo = "tokenInfo";
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, (Long)renewDate, (String)tokenInfo);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance((RouterStoreToken)storeToken);
        RouterRMTokenResponse routerRMTokenResponse = this.stateStore.storeNewToken(request);
        Assertions.assertNotNull((Object)routerRMTokenResponse);
        RouterRMTokenResponse removeTokenResponse = this.stateStore.removeStoredToken(request);
        Assertions.assertNotNull((Object)removeTokenResponse);
        RouterStoreToken removeTokenResp = removeTokenResponse.getRouterStoreToken();
        Assertions.assertNotNull((Object)removeTokenResp);
        Assertions.assertEquals((Long)removeTokenResp.getRenewDate(), (Long)storeToken.getRenewDate());
        Assertions.assertEquals((Object)removeTokenResp.getTokenIdentifier(), (Object)storeToken.getTokenIdentifier());
    }

    @Test
    public void testGetTokenByRouterStoreToken() throws IOException, YarnException, SQLException {
        RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier(new Text("owner4"), new Text("renewer4"), new Text("realuser4"));
        int sequenceNumber = 4;
        identifier.setSequenceNumber(sequenceNumber);
        Long renewDate = Time.now();
        String tokenInfo = "tokenInfo";
        RouterStoreToken storeToken = RouterStoreToken.newInstance((YARNDelegationTokenIdentifier)identifier, (Long)renewDate, (String)tokenInfo);
        RouterRMTokenRequest request = RouterRMTokenRequest.newInstance((RouterStoreToken)storeToken);
        RouterRMTokenResponse routerRMTokenResponse = this.stateStore.storeNewToken(request);
        Assertions.assertNotNull((Object)routerRMTokenResponse);
        RouterRMTokenResponse getRouterRMTokenResp = this.stateStore.getTokenByRouterStoreToken(request);
        Assertions.assertNotNull((Object)getRouterRMTokenResp);
        RouterStoreToken getStoreTokenResp = getRouterRMTokenResp.getRouterStoreToken();
        Assertions.assertNotNull((Object)getStoreTokenResp);
        Assertions.assertEquals((Long)getStoreTokenResp.getRenewDate(), (Long)storeToken.getRenewDate());
        Assertions.assertEquals((Object)storeToken.getTokenInfo(), (Object)getStoreTokenResp.getTokenInfo());
        this.checkRouterStoreToken(identifier, getStoreTokenResp);
    }

    @Test
    public void testGetCurrentVersion() {
        Version version = this.stateStore.getCurrentVersion();
        Assertions.assertEquals((int)1, (int)version.getMajorVersion());
        Assertions.assertEquals((int)1, (int)version.getMinorVersion());
    }

    @Test
    public void testStoreVersion() throws Exception {
        this.stateStore.storeVersion();
        Version version = this.stateStore.getCurrentVersion();
        Assertions.assertEquals((int)1, (int)version.getMajorVersion());
        Assertions.assertEquals((int)1, (int)version.getMinorVersion());
    }

    @Test
    public void testLoadVersion() throws Exception {
        this.stateStore.storeVersion();
        Version version = this.stateStore.loadVersion();
        Assertions.assertEquals((int)1, (int)version.getMajorVersion());
        Assertions.assertEquals((int)1, (int)version.getMinorVersion());
    }

    @Test
    public void testCheckVersion() throws Exception {
        this.stateStore.checkVersion();
    }

    @Test
    public void testGetApplicationHomeSubClusterWithContext() throws Exception {
        FederationStateStore federationStateStore = this.getStateStore();
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)3);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        ApplicationSubmissionContext context = ApplicationSubmissionContext.newInstance((ApplicationId)appId, (String)"test", (String)"default", (Priority)Priority.newInstance((int)0), null, (boolean)true, (boolean)true, (int)2, (Resource)Resource.newInstance((int)10, (int)2), (String)"test");
        this.addApplicationHomeSC(appId, subClusterId, context);
        GetApplicationHomeSubClusterRequest getRequest = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId, (boolean)true);
        GetApplicationHomeSubClusterResponse result = federationStateStore.getApplicationHomeSubCluster(getRequest);
        ApplicationHomeSubCluster applicationHomeSubCluster = result.getApplicationHomeSubCluster();
        Assertions.assertEquals((Object)appId, (Object)applicationHomeSubCluster.getApplicationId());
        Assertions.assertEquals((Object)subClusterId, (Object)applicationHomeSubCluster.getHomeSubCluster());
        Assertions.assertEquals((Object)context, (Object)applicationHomeSubCluster.getApplicationSubmissionContext());
    }

    public void testDeleteStateStore() throws Exception {
        FederationStateStore federationStateStore = this.getStateStore();
        federationStateStore.deleteStateStore();
        GetSubClustersInfoRequest request = GetSubClustersInfoRequest.newInstance((boolean)true);
        List subClustersActive = this.stateStore.getSubClusters(request).getSubClusters();
        Assertions.assertNotNull((Object)subClustersActive);
        Assertions.assertEquals((int)0, (int)subClustersActive.size());
        GetApplicationsHomeSubClusterRequest getRequest = GetApplicationsHomeSubClusterRequest.newInstance();
        GetApplicationsHomeSubClusterResponse result = this.stateStore.getApplicationsHomeSubCluster(getRequest);
        Assertions.assertNotNull((Object)result);
        List appsHomeSubClusters = result.getAppsHomeSubClusters();
        Assertions.assertNotNull((Object)appsHomeSubClusters);
        Assertions.assertEquals((int)0, (int)appsHomeSubClusters.size());
    }

    @Test
    public void testDeletePoliciesConfigurations() throws Exception {
        FederationStateStore federationStateStore = this.getStateStore();
        this.setPolicyConf("Queue1", "PolicyType1");
        this.setPolicyConf("Queue2", "PolicyType2");
        this.setPolicyConf("Queue3", "PolicyType3");
        ArrayList<String> queues = new ArrayList<String>();
        queues.add("Queue1");
        queues.add("Queue2");
        queues.add("Queue3");
        GetSubClusterPoliciesConfigurationsRequest policyRequest = GetSubClusterPoliciesConfigurationsRequest.newInstance();
        GetSubClusterPoliciesConfigurationsResponse response = this.stateStore.getPoliciesConfigurations(policyRequest);
        Assertions.assertNotNull((Object)response);
        List policiesConfigs = response.getPoliciesConfigs();
        for (SubClusterPolicyConfiguration policyConfig : policiesConfigs) {
            Assertions.assertTrue((boolean)queues.contains(policyConfig.getQueue()));
        }
        ArrayList<String> deleteQueues = new ArrayList<String>();
        deleteQueues.add("Queue1");
        deleteQueues.add("Queue2");
        DeleteSubClusterPoliciesConfigurationsRequest deleteRequest = DeleteSubClusterPoliciesConfigurationsRequest.newInstance(deleteQueues);
        federationStateStore.deletePoliciesConfigurations(deleteRequest);
        GetSubClusterPoliciesConfigurationsRequest policyRequest2 = GetSubClusterPoliciesConfigurationsRequest.newInstance();
        GetSubClusterPoliciesConfigurationsResponse response2 = this.stateStore.getPoliciesConfigurations(policyRequest2);
        Assertions.assertNotNull((Object)response2);
        List policiesConfigs2 = response2.getPoliciesConfigs();
        for (SubClusterPolicyConfiguration policyConfig : policiesConfigs2) {
            Assertions.assertFalse((boolean)deleteQueues.contains(policyConfig.getQueue()));
        }
    }

    @Test
    public void testDeletePolicyStore() throws Exception {
        FederationStateStore federationStateStore = this.getStateStore();
        DeletePoliciesConfigurationsRequest request = DeletePoliciesConfigurationsRequest.newInstance();
        DeletePoliciesConfigurationsResponse response = federationStateStore.deleteAllPoliciesConfigurations(request);
        Assertions.assertNotNull((Object)response);
        GetSubClusterPoliciesConfigurationsRequest request1 = GetSubClusterPoliciesConfigurationsRequest.newInstance();
        GetSubClusterPoliciesConfigurationsResponse response1 = this.stateStore.getPoliciesConfigurations(request1);
        Assertions.assertNotNull((Object)response1);
        List policiesConfigs = response1.getPoliciesConfigs();
        Assertions.assertNotNull((Object)policiesConfigs);
        Assertions.assertEquals((int)0, (int)policiesConfigs.size());
    }
}

