/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.router.BaseRouterPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.WeightedRandomRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestWeightedRandomRouterPolicy
extends BaseRouterPoliciesTest {
    @BeforeEach
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new WeightedRandomRouterPolicy());
        this.setPolicyInfo(new WeightedPolicyInfo());
        this.configureWeights(20.0f);
        this.setupContext();
    }

    public void configureWeights(float numSubClusters) {
        FederationPolicyUtils.setRand((long)5L);
        this.setRand(5L);
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        HashMap<SubClusterIdInfo, Float> amrmWeights = new HashMap<SubClusterIdInfo, Float>();
        int i = 0;
        while ((float)i < numSubClusters) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            if (this.getRand().nextFloat() < 0.95f) {
                long now = Time.now();
                SubClusterInfo federationSubClusterInfo = SubClusterInfo.newInstance((SubClusterId)sc.toId(), (String)"dns1:80", (String)"dns1:81", (String)"dns1:82", (String)"dns1:83", (long)(now - 1000L), (SubClusterState)SubClusterState.SC_RUNNING, (long)(now - 2000L), (String)this.generateClusterMetricsInfo(i));
                this.getActiveSubclusters().put(sc.toId(), federationSubClusterInfo);
            }
            float weight = 0.8f / numSubClusters + 0.2f * this.getRand().nextFloat();
            if (i <= 5 || this.getRand().nextFloat() > 0.05f) {
                routerWeights.put(sc, Float.valueOf(weight));
                amrmWeights.put(sc, Float.valueOf(weight));
            }
            ++i;
        }
        this.getPolicyInfo().setRouterPolicyWeights(routerWeights);
        this.getPolicyInfo().setAMRMPolicyWeights(amrmWeights);
    }

    @Test
    public void testClusterChosenWithRightProbability() throws YarnException {
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)context.getQueue()).thenReturn((Object)"queue1");
        this.setApplicationSubmissionContext(context);
        HashMap<SubClusterId, AtomicLong> counter = new HashMap<SubClusterId, AtomicLong>();
        for (SubClusterIdInfo id : this.getPolicyInfo().getRouterPolicyWeights().keySet()) {
            counter.put(id.toId(), new AtomicLong(0L));
        }
        float numberOfDraws = 10000.0f;
        for (float i = 0.0f; i < numberOfDraws; i += 1.0f) {
            SubClusterId chosenId = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(this.getApplicationSubmissionContext(), null);
            ((AtomicLong)counter.get(chosenId)).incrementAndGet();
        }
        float totalActiveWeight = 0.0f;
        for (SubClusterId subClusterId : this.getActiveSubclusters().keySet()) {
            SubClusterIdInfo idInfo = new SubClusterIdInfo(subClusterId);
            if (!this.getPolicyInfo().getRouterPolicyWeights().containsKey(idInfo)) continue;
            totalActiveWeight += ((Float)this.getPolicyInfo().getRouterPolicyWeights().get(idInfo)).floatValue();
        }
        for (Map.Entry entry : counter.entrySet()) {
            float expectedWeight = ((Float)this.getPolicyInfo().getRouterPolicyWeights().get(new SubClusterIdInfo((SubClusterId)entry.getKey()))).floatValue() / totalActiveWeight;
            float actualWeight = ((AtomicLong)entry.getValue()).floatValue() / numberOfDraws;
            if (this.getActiveSubclusters().containsKey(entry.getKey())) {
                Assertions.assertTrue(((double)Math.abs(actualWeight - expectedWeight) < 0.01 ? 1 : 0) != 0, (String)("Id " + entry.getKey() + " Actual weight: " + actualWeight + " expected weight: " + expectedWeight));
                continue;
            }
            Assertions.assertTrue((actualWeight == 0.0f ? 1 : 0) != 0, (String)("Id " + entry.getKey() + " Actual weight: " + actualWeight + " expected weight: " + expectedWeight));
        }
    }
}

