/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.BaseRouterPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.RejectRouterPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRejectRouterPolicy
extends BaseRouterPoliciesTest {
    @BeforeEach
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new RejectRouterPolicy());
        this.setMockActiveSubclusters(2);
        this.setupContext();
    }

    @Test
    public void testNoClusterIsChosen() throws YarnException {
        Assertions.assertThrows(FederationPolicyException.class, () -> ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(this.getApplicationSubmissionContext(), null));
    }

    @Override
    @Test
    public void testNullQueueRouting() throws YarnException {
        Assertions.assertThrows(FederationPolicyException.class, () -> {
            FederationRouterPolicy localPolicy = (FederationRouterPolicy)this.getPolicy();
            ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
            localPolicy.getHomeSubcluster(applicationSubmissionContext, null);
        });
    }

    @Override
    @Test
    public void testFollowReservation() throws YarnException {
        Assertions.assertThrows(FederationPolicyException.class, () -> super.testFollowReservation());
    }

    @Override
    @Test
    public void testUpdateReservation() throws YarnException {
        Assertions.assertThrows(FederationPolicyException.class, () -> super.testUpdateReservation());
    }

    @Override
    @Test
    public void testDeleteReservation() throws Exception {
        Assertions.assertThrows(FederationPolicyException.class, () -> super.testDeleteReservation());
    }
}

