/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.HashMap;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.BaseRouterPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.PriorityRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPriorityRouterPolicy
extends BaseRouterPoliciesTest {
    @BeforeEach
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new PriorityRouterPolicy());
        this.setPolicyInfo(new WeightedPolicyInfo());
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        HashMap<SubClusterIdInfo, Float> amrmWeights = new HashMap<SubClusterIdInfo, Float>();
        for (int i = 0; i < 20; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            if (this.getRand().nextFloat() < 0.95f || i == 5) {
                long now = Time.now();
                SubClusterInfo federationSubClusterInfo = SubClusterInfo.newInstance((SubClusterId)sc.toId(), (String)"dns1:80", (String)"dns1:81", (String)"dns1:82", (String)"dns1:83", (long)(now - 1000L), (SubClusterState)SubClusterState.SC_RUNNING, (long)(now - 2000L), (String)this.generateClusterMetricsInfo(i));
                this.getActiveSubclusters().put(sc.toId(), federationSubClusterInfo);
            }
            float weight = this.getRand().nextFloat();
            if (i == 5) {
                weight = 1.1f;
            }
            if (i > 5 && !(this.getRand().nextFloat() > 0.05f)) continue;
            routerWeights.put(sc, Float.valueOf(weight));
            amrmWeights.put(sc, Float.valueOf(weight));
        }
        this.getPolicyInfo().setRouterPolicyWeights(routerWeights);
        this.getPolicyInfo().setAMRMPolicyWeights(amrmWeights);
        this.setupContext();
    }

    @Test
    public void testPickLowestWeight() throws YarnException {
        SubClusterId chosen = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(this.getApplicationSubmissionContext(), null);
        Assertions.assertEquals((Object)"sc5", (Object)chosen.getId());
    }

    @Test
    public void testZeroSubClustersWithPositiveWeight() throws Exception {
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        HashMap<SubClusterIdInfo, Float> amrmWeights = new HashMap<SubClusterIdInfo, Float>();
        for (int i = 0; i < 5; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            SubClusterInfo sci = SubClusterInfo.newInstance((SubClusterId)sc.toId(), (String)"dns1:80", (String)"dns1:81", (String)"dns1:82", (String)"dns1:83", (SubClusterState)SubClusterState.SC_RUNNING, (long)System.currentTimeMillis(), (String)"something");
            this.getActiveSubclusters().put(sc.toId(), sci);
            routerWeights.put(sc, Float.valueOf(0.0f));
            amrmWeights.put(sc, Float.valueOf(-1.0f));
        }
        this.getPolicyInfo().setRouterPolicyWeights(routerWeights);
        this.getPolicyInfo().setAMRMPolicyWeights(amrmWeights);
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), this.getPolicyInfo(), this.getActiveSubclusters());
        LambdaTestUtils.intercept(FederationPolicyException.class, (String)"No Active Subcluster with weight vector greater than zero.", () -> ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(this.getApplicationSubmissionContext(), null));
    }
}

