/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.router.BaseRouterPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.LoadBasedRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestLoadBasedRouterPolicy
extends BaseRouterPoliciesTest {
    @BeforeEach
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new LoadBasedRouterPolicy());
        this.setPolicyInfo(new WeightedPolicyInfo());
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        HashMap<SubClusterIdInfo, Float> amrmWeights = new HashMap<SubClusterIdInfo, Float>();
        long now = Time.now();
        for (int i = 0; i < 20; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo(String.format("sc%02d", i));
            SubClusterInfo federationSubClusterInfo = SubClusterInfo.newInstance((SubClusterId)sc.toId(), (String)"dns1:80", (String)"dns1:81", (String)"dns1:82", (String)"dns1:83", (long)(now - 1000L), (SubClusterState)SubClusterState.SC_RUNNING, (long)(now - 2000L), (String)this.generateClusterMetricsInfo(i));
            this.getActiveSubclusters().put(sc.toId(), federationSubClusterInfo);
            float weight = this.getRand().nextInt(2);
            if (i == 5) {
                weight = 1.0f;
            }
            if (i > 5 && !(this.getRand().nextFloat() > 0.05f)) continue;
            routerWeights.put(sc, Float.valueOf(weight));
            amrmWeights.put(sc, Float.valueOf(weight));
        }
        this.getPolicyInfo().setRouterPolicyWeights(routerWeights);
        this.getPolicyInfo().setAMRMPolicyWeights(amrmWeights);
        this.setupContext();
    }

    @Override
    public String generateClusterMetricsInfo(int id) {
        long mem = 1024 * this.getRand().nextInt(27699);
        if (id == 5) {
            mem = 28364800L;
        }
        String clusterMetrics = "{\"clusterMetrics\":{\"appsSubmitted\":65,\"appsCompleted\":64,\"appsPending\":0,\"appsRunning\":0,\"appsFailed\":0,\"appsKilled\":1,\"reservedMB\":0,\"availableMB\":" + mem + ",\"allocatedMB\":0,\"reservedVirtualCores\":0,\"availableVirtualCores\":2216,\"allocatedVirtualCores\":0,\"containersAllocated\":0,\"containersReserved\":0,\"containersPending\":0,\"totalMB\":28364800,\"totalVirtualCores\":2216,\"totalNodes\":278,\"lostNodes\":1,\"unhealthyNodes\":0,\"decommissionedNodes\":0,\"rebootedNodes\":0,\"activeNodes\":277}}\n";
        return clusterMetrics;
    }

    @Test
    public void testLoadIsRespected() throws YarnException {
        SubClusterId chosen = ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(this.getApplicationSubmissionContext(), null);
        Assertions.assertEquals((Object)"sc05", (Object)chosen.getId());
    }

    @Test
    public void testIfNoSubclustersWithWeightOne() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new LoadBasedRouterPolicy());
        this.setPolicyInfo(new WeightedPolicyInfo());
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        HashMap<SubClusterIdInfo, Float> amrmWeights = new HashMap<SubClusterIdInfo, Float>();
        SubClusterIdInfo sc = new SubClusterIdInfo(String.format("sc%02d", 0));
        SubClusterInfo federationSubClusterInfo = SubClusterInfo.newInstance((SubClusterId)sc.toId(), null, null, null, null, (long)-1L, (SubClusterState)SubClusterState.SC_RUNNING, (long)-1L, (String)this.generateClusterMetricsInfo(0));
        this.getActiveSubclusters().clear();
        this.getActiveSubclusters().put(sc.toId(), federationSubClusterInfo);
        routerWeights.put(sc, Float.valueOf(0.0f));
        amrmWeights.put(sc, Float.valueOf(0.0f));
        this.getPolicyInfo().setRouterPolicyWeights(routerWeights);
        this.getPolicyInfo().setAMRMPolicyWeights(amrmWeights);
        ConfigurableFederationPolicy policy = this.getPolicy();
        FederationPoliciesTestUtil.initializePolicyContext(policy, this.getPolicyInfo(), this.getActiveSubclusters());
        LambdaTestUtils.intercept(YarnException.class, (String)"Zero Active Subcluster with weight 1.", () -> ((FederationRouterPolicy)policy).getHomeSubcluster(this.getApplicationSubmissionContext(), null));
    }

    @Override
    @Test
    public void testUpdateReservation() throws YarnException {
        long now = Time.now();
        ReservationSubmissionRequest resReq = this.getReservationSubmissionRequest();
        Mockito.when((Object)resReq.getQueue()).thenReturn((Object)"queue1");
        Mockito.when((Object)resReq.getReservationId()).thenReturn((Object)ReservationId.newInstance((long)now, (long)1L));
        FederationRouterPolicy routerPolicy = (FederationRouterPolicy)this.getPolicy();
        SubClusterId chosen = routerPolicy.getReservationHomeSubcluster(resReq);
        FederationStateStoreFacade facade = this.getFederationPolicyContext().getFederationStateStoreFacade();
        ReservationHomeSubCluster subCluster = ReservationHomeSubCluster.newInstance((ReservationId)resReq.getReservationId(), (SubClusterId)chosen);
        facade.addReservationHomeSubCluster(subCluster);
        Map<SubClusterId, SubClusterInfo> activeSubClusters = this.getActiveSubclusters();
        WeightedPolicyInfo weightedPolicyInfo = this.getPolicyInfo();
        Map routerPolicyWeights = weightedPolicyInfo.getRouterPolicyWeights();
        ArrayList<SubClusterId> subClusterIds = new ArrayList<SubClusterId>();
        for (Map.Entry entry : routerPolicyWeights.entrySet()) {
            SubClusterIdInfo subClusterIdInfo = (SubClusterIdInfo)entry.getKey();
            Float subClusterWeight = (Float)entry.getValue();
            if (!((double)subClusterWeight.floatValue() >= 1.0)) continue;
            subClusterIds.add(subClusterIdInfo.toId());
        }
        SubClusterId chosen2 = (SubClusterId)subClusterIds.get(this.getRand().nextInt(subClusterIds.size()));
        ReservationHomeSubCluster subCluster2 = ReservationHomeSubCluster.newInstance((ReservationId)resReq.getReservationId(), (SubClusterId)chosen2);
        facade.updateReservationHomeSubCluster(subCluster2);
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)ApplicationId.newInstance((long)now, (int)1), (String)"app1", (String)"queue1", (Priority)Priority.newInstance((int)1), null, (boolean)false, (boolean)false, (int)1, null, null, (boolean)false);
        applicationSubmissionContext.setReservationID(resReq.getReservationId());
        SubClusterId chosen3 = routerPolicy.getHomeSubcluster(applicationSubmissionContext, new ArrayList());
        Assertions.assertEquals((Object)chosen2, (Object)chosen3);
    }
}

