/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.BaseFederationPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.RejectRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public abstract class BaseRouterPoliciesTest
extends BaseFederationPoliciesTest {
    @Test
    public void testNullQueueRouting() throws YarnException {
        FederationRouterPolicy localPolicy = (FederationRouterPolicy)this.getPolicy();
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        SubClusterId chosen = localPolicy.getHomeSubcluster(applicationSubmissionContext, null);
        Assertions.assertNotNull((Object)chosen);
    }

    @Test
    public void testNullAppContext() throws YarnException {
        Assertions.assertThrows(FederationPolicyException.class, () -> ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(null, null));
    }

    @Test
    public void testBlacklistSubcluster() throws YarnException {
        FederationRouterPolicy localPolicy = (FederationRouterPolicy)this.getPolicy();
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        Map<SubClusterId, SubClusterInfo> activeSubClusters = this.getActiveSubclusters();
        if (activeSubClusters != null && activeSubClusters.size() > 1 && !(localPolicy instanceof RejectRouterPolicy)) {
            Random random = new Random();
            ArrayList<SubClusterId> blacklistSubclusters = new ArrayList<SubClusterId>(activeSubClusters.keySet());
            SubClusterId removed = (SubClusterId)blacklistSubclusters.remove(random.nextInt(blacklistSubclusters.size()));
            this.getPolicyInfo().getRouterPolicyWeights().put(new SubClusterIdInfo(removed), Float.valueOf(1.0f));
            FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), this.getPolicyInfo(), this.getActiveSubclusters());
            SubClusterId chosen = localPolicy.getHomeSubcluster(applicationSubmissionContext, blacklistSubclusters);
            Assertions.assertNotNull((Object)chosen);
            Assertions.assertEquals((Object)removed, (Object)chosen);
        }
    }

    @Test
    public void testAllBlacklistSubcluster() throws YarnException {
        FederationRouterPolicy localPolicy = (FederationRouterPolicy)this.getPolicy();
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        Map<SubClusterId, SubClusterInfo> activeSubClusters = this.getActiveSubclusters();
        if (activeSubClusters != null && activeSubClusters.size() > 1 && !(localPolicy instanceof RejectRouterPolicy)) {
            ArrayList<SubClusterId> blacklistSubclusters = new ArrayList<SubClusterId>(activeSubClusters.keySet());
            try {
                localPolicy.getHomeSubcluster(applicationSubmissionContext, blacklistSubclusters);
                Assertions.fail();
            }
            catch (YarnException e) {
                Assertions.assertTrue((boolean)e.getMessage().equals("No active SubCluster available to submit the request."));
            }
        }
    }

    @Test
    public void testNullReservationContext() throws Exception {
        FederationRouterPolicy policy = (FederationRouterPolicy)this.getPolicy();
        LambdaTestUtils.intercept(FederationPolicyException.class, (String)"The ReservationSubmissionRequest cannot be null.", () -> policy.getReservationHomeSubcluster(null));
    }

    @Test
    public void testUnknownReservation() throws Exception {
        long now = Time.now();
        ReservationSubmissionRequest resReq = this.getReservationSubmissionRequest();
        ReservationId reservationId = ReservationId.newInstance((long)now, (long)1L);
        Mockito.when((Object)resReq.getQueue()).thenReturn((Object)"queue1");
        Mockito.when((Object)resReq.getReservationId()).thenReturn((Object)reservationId);
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)ApplicationId.newInstance((long)now, (int)1), (String)"app1", (String)"queue1", (Priority)Priority.newInstance((int)1), null, (boolean)false, (boolean)false, (int)1, null, null, (boolean)false);
        applicationSubmissionContext.setReservationID(resReq.getReservationId());
        FederationRouterPolicy policy = (FederationRouterPolicy)this.getPolicy();
        LambdaTestUtils.intercept(YarnException.class, (String)("Reservation " + reservationId + " does not exist"), () -> policy.getHomeSubcluster(applicationSubmissionContext, new ArrayList()));
    }

    @Test
    public void testFollowReservation() throws YarnException {
        long now = Time.now();
        ReservationSubmissionRequest resReq = this.getReservationSubmissionRequest();
        Mockito.when((Object)resReq.getQueue()).thenReturn((Object)"queue1");
        Mockito.when((Object)resReq.getReservationId()).thenReturn((Object)ReservationId.newInstance((long)now, (long)1L));
        FederationRouterPolicy routerPolicy = (FederationRouterPolicy)this.getPolicy();
        FederationPolicyInitializationContext fdContext = this.getFederationPolicyContext();
        FederationStateStoreFacade storeFacade = fdContext.getFederationStateStoreFacade();
        SubClusterId chosen = routerPolicy.getReservationHomeSubcluster(resReq);
        ReservationHomeSubCluster homeSubCluster = ReservationHomeSubCluster.newInstance((ReservationId)resReq.getReservationId(), (SubClusterId)chosen);
        storeFacade.addReservationHomeSubCluster(homeSubCluster);
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)ApplicationId.newInstance((long)now, (int)1), (String)"app1", (String)"queue1", (Priority)Priority.newInstance((int)1), null, (boolean)false, (boolean)false, (int)1, null, null, (boolean)false);
        applicationSubmissionContext.setReservationID(resReq.getReservationId());
        SubClusterId chosen2 = routerPolicy.getHomeSubcluster(applicationSubmissionContext, Collections.emptyList());
        Assertions.assertEquals((Object)chosen, (Object)chosen2);
    }

    @Test
    public void testUpdateReservation() throws YarnException {
        long now = Time.now();
        ReservationSubmissionRequest resReq = this.getReservationSubmissionRequest();
        Mockito.when((Object)resReq.getQueue()).thenReturn((Object)"queue1");
        Mockito.when((Object)resReq.getReservationId()).thenReturn((Object)ReservationId.newInstance((long)now, (long)1L));
        FederationRouterPolicy routerPolicy = (FederationRouterPolicy)this.getPolicy();
        SubClusterId chosen = routerPolicy.getReservationHomeSubcluster(resReq);
        FederationStateStoreFacade facade = this.getFederationPolicyContext().getFederationStateStoreFacade();
        ReservationHomeSubCluster subCluster = ReservationHomeSubCluster.newInstance((ReservationId)resReq.getReservationId(), (SubClusterId)chosen);
        facade.addReservationHomeSubCluster(subCluster);
        Map<SubClusterId, SubClusterInfo> activeSubClusters = this.getActiveSubclusters();
        ArrayList<SubClusterId> subClusterIds = new ArrayList<SubClusterId>(activeSubClusters.keySet());
        SubClusterId chosen2 = (SubClusterId)subClusterIds.get(this.getRand().nextInt(subClusterIds.size()));
        ReservationHomeSubCluster subCluster2 = ReservationHomeSubCluster.newInstance((ReservationId)resReq.getReservationId(), (SubClusterId)chosen2);
        facade.updateReservationHomeSubCluster(subCluster2);
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)ApplicationId.newInstance((long)now, (int)1), (String)"app1", (String)"queue1", (Priority)Priority.newInstance((int)1), null, (boolean)false, (boolean)false, (int)1, null, null, (boolean)false);
        applicationSubmissionContext.setReservationID(resReq.getReservationId());
        SubClusterId chosen3 = routerPolicy.getHomeSubcluster(applicationSubmissionContext, new ArrayList());
        Assertions.assertEquals((Object)chosen2, (Object)chosen3);
    }

    @Test
    public void testDeleteReservation() throws Exception {
        long now = Time.now();
        ReservationSubmissionRequest resReq = this.getReservationSubmissionRequest();
        Mockito.when((Object)resReq.getQueue()).thenReturn((Object)"queue1");
        Mockito.when((Object)resReq.getReservationId()).thenReturn((Object)ReservationId.newInstance((long)now, (long)1L));
        FederationRouterPolicy routerPolicy = (FederationRouterPolicy)this.getPolicy();
        SubClusterId chosen = routerPolicy.getReservationHomeSubcluster(resReq);
        FederationStateStoreFacade facade = this.getFederationPolicyContext().getFederationStateStoreFacade();
        ReservationHomeSubCluster subCluster = ReservationHomeSubCluster.newInstance((ReservationId)resReq.getReservationId(), (SubClusterId)chosen);
        facade.addReservationHomeSubCluster(subCluster);
        facade.deleteReservationHomeSubCluster(resReq.getReservationId());
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)ApplicationId.newInstance((long)now, (int)1), (String)"app1", (String)"queue1", (Priority)Priority.newInstance((int)1), null, (boolean)false, (boolean)false, (int)1, null, null, (boolean)false);
        applicationSubmissionContext.setReservationID(resReq.getReservationId());
        LambdaTestUtils.intercept(YarnException.class, (String)("Reservation " + resReq.getReservationId() + " does not exist"), () -> routerPolicy.getHomeSubcluster(applicationSubmissionContext, new ArrayList()));
    }
}

