/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.amrmproxy;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.BaseFederationPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.HomeAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHomeAMRMProxyPolicy
extends BaseFederationPoliciesTest {
    private static final int NUM_SUBCLUSTERS = 4;
    private static final String HOME_SC_NAME = "sc2";
    private static final SubClusterId HOME_SC_ID = SubClusterId.newInstance((String)"sc2");

    @BeforeEach
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new HomeAMRMProxyPolicy());
        this.setPolicyInfo((WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class));
        for (int i = 0; i < 4; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            SubClusterInfo sci = SubClusterInfo.newInstance((SubClusterId)sc.toId(), (String)"dns1:80", (String)"dns1:81", (String)"dns1:82", (String)"dns1:83", (SubClusterState)SubClusterState.SC_RUNNING, (long)System.currentTimeMillis(), (String)"something");
            this.getActiveSubclusters().put(sc.toId(), sci);
        }
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class), this.getActiveSubclusters(), HOME_SC_NAME);
    }

    @Test
    public void testSplitAllocateRequest() throws YarnException {
        String[] hosts = new String[]{"host0", "host1", "host2", "host3"};
        List<ResourceRequest> resourceRequests = FederationPoliciesTestUtil.createResourceRequests(hosts, 2048, 2, 1, 3, null, false);
        HomeAMRMProxyPolicy federationPolicy = (HomeAMRMProxyPolicy)this.getPolicy();
        Map response = federationPolicy.splitResourceRequests(resourceRequests, new HashSet());
        Assertions.assertEquals((int)1, (int)response.size());
        Assertions.assertNotNull(response.get(HOME_SC_ID));
        Assertions.assertEquals((int)9, (int)((List)response.get(HOME_SC_ID)).size());
    }

    @Test
    public void testHomeSubclusterNotActive() throws YarnException {
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class), this.getActiveSubclusters(), "badsc");
        try {
            String[] hosts = new String[]{"host0", "host1", "host2", "host3"};
            List<ResourceRequest> resourceRequests = FederationPoliciesTestUtil.createResourceRequests(hosts, 2048, 2, 1, 3, null, false);
            HomeAMRMProxyPolicy federationPolicy = (HomeAMRMProxyPolicy)this.getPolicy();
            federationPolicy.splitResourceRequests(resourceRequests, new HashSet());
            Assertions.fail((String)"It should fail when the home subcluster is not active");
        }
        catch (FederationPolicyException e) {
            GenericTestUtils.assertExceptionContains((String)"is not active", (Throwable)e);
        }
    }
}

