/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies;

import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.FederationPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestFederationPolicyInitializationContextValidator {
    private SubClusterPolicyConfiguration goodConfig;
    private SubClusterResolver goodSR;
    private FederationStateStoreFacade goodFacade;
    private SubClusterId goodHome;
    private FederationPolicyInitializationContext context;

    @BeforeEach
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.goodFacade = FederationPoliciesTestUtil.initFacade(conf);
        this.goodConfig = new MockPolicyManager().serializeConf();
        this.goodSR = FederationPoliciesTestUtil.initResolver();
        this.goodHome = SubClusterId.newInstance((String)"homesubcluster");
        this.context = new FederationPolicyInitializationContext(this.goodConfig, this.goodSR, this.goodFacade, this.goodHome);
    }

    @Test
    public void correcInit() throws Exception {
        FederationPolicyInitializationContextValidator.validate((FederationPolicyInitializationContext)this.context, (String)MockPolicyManager.class.getCanonicalName());
    }

    @Test
    public void nullContext() throws Exception {
        Assertions.assertThrows(FederationPolicyInitializationException.class, () -> FederationPolicyInitializationContextValidator.validate(null, (String)MockPolicyManager.class.getCanonicalName()));
    }

    @Test
    public void nullType() throws Exception {
        Assertions.assertThrows(FederationPolicyInitializationException.class, () -> FederationPolicyInitializationContextValidator.validate((FederationPolicyInitializationContext)this.context, null));
    }

    @Test
    public void wrongType() throws Exception {
        Assertions.assertThrows(FederationPolicyInitializationException.class, () -> FederationPolicyInitializationContextValidator.validate((FederationPolicyInitializationContext)this.context, (String)"WrongType"));
    }

    @Test
    public void nullConf() throws Exception {
        Assertions.assertThrows(FederationPolicyInitializationException.class, () -> {
            this.context.setSubClusterPolicyConfiguration(null);
            FederationPolicyInitializationContextValidator.validate((FederationPolicyInitializationContext)this.context, (String)MockPolicyManager.class.getCanonicalName());
        });
    }

    @Test
    public void nullResolver() throws Exception {
        Assertions.assertThrows(FederationPolicyInitializationException.class, () -> {
            this.context.setFederationSubclusterResolver(null);
            FederationPolicyInitializationContextValidator.validate((FederationPolicyInitializationContext)this.context, (String)MockPolicyManager.class.getCanonicalName());
        });
    }

    @Test
    public void nullFacade() throws Exception {
        Assertions.assertThrows(FederationPolicyInitializationException.class, () -> {
            this.context.setFederationStateStoreFacade(null);
            FederationPolicyInitializationContextValidator.validate((FederationPolicyInitializationContext)this.context, (String)MockPolicyManager.class.getCanonicalName());
        });
    }

    private class MockPolicyManager
    implements FederationPolicyManager {
        private MockPolicyManager() {
        }

        public FederationAMRMProxyPolicy getAMRMPolicy(FederationPolicyInitializationContext policyContext, FederationAMRMProxyPolicy oldInstance) throws FederationPolicyInitializationException {
            return null;
        }

        public FederationRouterPolicy getRouterPolicy(FederationPolicyInitializationContext policyContext, FederationRouterPolicy oldInstance) throws FederationPolicyInitializationException {
            return null;
        }

        public SubClusterPolicyConfiguration serializeConf() throws FederationPolicyInitializationException {
            ByteBuffer buf = ByteBuffer.allocate(0);
            return SubClusterPolicyConfiguration.newInstance((String)"queue1", (String)this.getClass().getCanonicalName(), (ByteBuffer)buf);
        }

        public String getQueue() {
            return "default";
        }

        public void setQueue(String queue) {
        }

        public WeightedPolicyInfo getWeightedPolicyInfo() {
            return null;
        }

        public void setWeightedPolicyInfo(WeightedPolicyInfo weightedPolicyInfo) {
        }

        public boolean isSupportWeightedPolicyInfo() {
            return false;
        }
    }
}

