/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.cache.FederationCache;
import org.apache.hadoop.yarn.server.federation.cache.FederationCaffeineCache;
import org.apache.hadoop.yarn.server.federation.cache.FederationGuavaCache;
import org.apache.hadoop.yarn.server.federation.cache.FederationJCache;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreTestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestFederationCache {
    private final long clusterTs = System.currentTimeMillis();
    private final int numSubClusters = 3;
    private final int numApps = 5;
    private final int numQueues = 2;
    private Configuration conf;
    private FederationStateStore stateStore;
    private FederationStateStoreTestUtil stateStoreTestUtil;
    private FederationStateStoreFacade facade;

    public static Collection<Class[]> getParameters() {
        return Arrays.asList({FederationGuavaCache.class}, {FederationJCache.class}, {FederationCaffeineCache.class});
    }

    private void initTestFederationCache(Class cacheClassName) throws IOException, YarnException {
        this.conf = new Configuration();
        this.conf.setInt("yarn.federation.cache-ttl.secs", 1);
        this.conf.setClass("yarn.federation.cache.class", cacheClassName, FederationCache.class);
        this.facade = FederationStateStoreFacade.getInstance((Configuration)this.conf);
        this.setUp();
    }

    public void setUp() throws IOException, YarnException {
        this.stateStore = new MemoryFederationStateStore();
        this.stateStore.init(this.conf);
        this.facade.reinitialize(this.stateStore, this.conf);
        this.stateStoreTestUtil = new FederationStateStoreTestUtil(this.stateStore);
        this.stateStoreTestUtil.registerSubClusters(3);
        this.stateStoreTestUtil.addAppsHomeSC(this.clusterTs, 5);
        this.stateStoreTestUtil.addPolicyConfigs(2);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.stateStore.close();
        this.stateStore = null;
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetSubCluster(Class cacheClassName) throws YarnException, IOException {
        this.initTestFederationCache(cacheClassName);
        for (int i = 0; i < 3; ++i) {
            SubClusterId subClusterId = SubClusterId.newInstance((String)("SC-" + i));
            SubClusterInfo expectedSubCluster = this.stateStoreTestUtil.querySubClusterInfo(subClusterId);
            SubClusterInfo cachedSubCluster = this.facade.getSubCluster(subClusterId);
            Assertions.assertEquals((Object)expectedSubCluster, (Object)cachedSubCluster);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetPoliciesConfigurations(Class cacheClassName) throws YarnException, IOException {
        this.initTestFederationCache(cacheClassName);
        Map queuePolicies = this.facade.getPoliciesConfigurations();
        for (String queue : queuePolicies.keySet()) {
            SubClusterPolicyConfiguration expectedPC = this.stateStoreTestUtil.queryPolicyConfiguration(queue);
            SubClusterPolicyConfiguration cachedPC = (SubClusterPolicyConfiguration)queuePolicies.get(queue);
            Assertions.assertEquals((Object)expectedPC, (Object)cachedPC);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testGetHomeSubClusterForApp(Class cacheClassName) throws YarnException, IOException {
        this.initTestFederationCache(cacheClassName);
        for (int i = 0; i < 5; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)this.clusterTs, (int)i);
            SubClusterId expectedSC = this.stateStoreTestUtil.queryApplicationHomeSC(appId);
            SubClusterId cachedPC = this.facade.getApplicationHomeSubCluster(appId);
            Assertions.assertEquals((Object)expectedSC, (Object)cachedPC);
        }
    }
}

