/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.util.Arrays;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RegisterNodeManagerRequestPBImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRegisterNodeManagerRequest {
    @Test
    public void testRegisterNodeManagerRequest() {
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host", (int)1234), (int)1234, (Resource)Resource.newInstance((int)0, (int)0), (String)"version", Arrays.asList(NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1234L, (int)1), (int)1), (long)1L), (int)0, (ContainerState)ContainerState.RUNNING, (Resource)Resource.newInstance((int)1024, (int)1), (String)"good", (int)-1, (Priority)Priority.newInstance((int)0), (long)1234L)), Arrays.asList(ApplicationId.newInstance((long)1234L, (int)1), ApplicationId.newInstance((long)1234L, (int)2)));
        RegisterNodeManagerRequestPBImpl request1 = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assertions.assertEquals((int)request1.getNMContainerStatuses().size(), (int)request.getNMContainerStatuses().size());
        Assertions.assertEquals((Object)((NMContainerStatus)request1.getNMContainerStatuses().get(0)).getContainerId(), (Object)((NMContainerStatus)request.getNMContainerStatuses().get(0)).getContainerId());
        Assertions.assertEquals((int)request1.getRunningApplications().size(), (int)request.getRunningApplications().size());
        Assertions.assertEquals(request1.getRunningApplications().get(0), request.getRunningApplications().get(0));
        Assertions.assertEquals(request1.getRunningApplications().get(1), request.getRunningApplications().get(1));
    }

    @Test
    public void testRegisterNodeManagerRequestWithNullArrays() {
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host", (int)1234), (int)1234, (Resource)Resource.newInstance((int)0, (int)0), (String)"version", null, null);
        RegisterNodeManagerRequestPBImpl request1 = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assertions.assertEquals((int)0, (int)request1.getNMContainerStatuses().size());
        Assertions.assertEquals((int)0, (int)request1.getRunningApplications().size());
    }
}

