/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerStatusPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NMContainerStatusPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NodeHeartbeatRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NodeHeartbeatResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RegisterNodeManagerRequestPBImpl;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.utils.YarnServerBuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtocolRecords {
    @Test
    public void testResource() {
        long mem = 123L;
        int vcores = 456;
        Resource r = Resource.newInstance((long)123L, (int)456);
        Assertions.assertFalse((boolean)(r instanceof ResourcePBImpl));
        Assertions.assertEquals((long)123L, (long)r.getMemorySize());
        Assertions.assertEquals((int)456, (int)r.getVirtualCores());
        YarnProtos.ResourceProto proto = ProtoUtils.convertToProtoFormat((Resource)r);
        Assertions.assertEquals((long)123L, (long)proto.getMemory());
        Assertions.assertEquals((int)456, (int)proto.getVirtualCores());
        Assertions.assertEquals((Object)r, (Object)ProtoUtils.convertFromProtoFormat((YarnProtos.ResourceProto)proto));
    }

    @Test
    public void testNMContainerStatus() {
        ApplicationId appId = ApplicationId.newInstance((long)123456789L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        Resource resource = Resource.newInstance((int)1000, (int)200);
        NMContainerStatus report = NMContainerStatus.newInstance((ContainerId)containerId, (int)0, (ContainerState)ContainerState.COMPLETE, (Resource)resource, (String)"diagnostics", (int)-100, (Priority)Priority.newInstance((int)10), (long)1234L);
        NMContainerStatusPBImpl reportProto = new NMContainerStatusPBImpl(((NMContainerStatusPBImpl)report).getProto());
        Assertions.assertEquals((Object)"diagnostics", (Object)reportProto.getDiagnostics());
        Assertions.assertEquals((Object)resource, (Object)reportProto.getAllocatedResource());
        Assertions.assertEquals((int)-100, (int)reportProto.getContainerExitStatus());
        Assertions.assertEquals((Object)ContainerState.COMPLETE, (Object)reportProto.getContainerState());
        Assertions.assertEquals((Object)containerId, (Object)reportProto.getContainerId());
        Assertions.assertEquals((Object)Priority.newInstance((int)10), (Object)reportProto.getPriority());
        Assertions.assertEquals((long)1234L, (long)reportProto.getCreationTime());
    }

    @Test
    public void testRegisterNodeManagerRequest() {
        ApplicationId appId = ApplicationId.newInstance((long)123456789L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)1L);
        NMContainerStatus containerReport = NMContainerStatus.newInstance((ContainerId)containerId, (int)0, (ContainerState)ContainerState.RUNNING, (Resource)Resource.newInstance((int)1024, (int)1), (String)"diagnostics", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        List<NMContainerStatus> reports = Arrays.asList(containerReport);
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"1.1.1.1", (int)1000), (int)8080, (Resource)Resource.newInstance((int)1024, (int)1), (String)"NM-version-id", reports, Arrays.asList(appId));
        RegisterNodeManagerRequestPBImpl requestProto = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assertions.assertEquals((Object)containerReport, requestProto.getNMContainerStatuses().get(0));
        Assertions.assertEquals((int)8080, (int)requestProto.getHttpPort());
        Assertions.assertEquals((Object)"NM-version-id", (Object)requestProto.getNMVersion());
        Assertions.assertEquals((Object)NodeId.newInstance((String)"1.1.1.1", (int)1000), (Object)requestProto.getNodeId());
        Assertions.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)requestProto.getResource());
        Assertions.assertEquals((int)1, (int)requestProto.getRunningApplications().size());
        Assertions.assertEquals((Object)appId, requestProto.getRunningApplications().get(0));
    }

    @Test
    public void testNodeHeartBeatResponse() throws IOException {
        NodeHeartbeatResponse record = (NodeHeartbeatResponse)Records.newRecord(NodeHeartbeatResponse.class);
        HashMap<ApplicationId, ByteBuffer> appCredentials = new HashMap<ApplicationId, ByteBuffer>();
        Credentials app1Cred = new Credentials();
        Token token1 = new Token();
        token1.setKind(new Text("kind1"));
        app1Cred.addToken(new Text("token1"), token1);
        Token token2 = new Token();
        token2.setKind(new Text("kind2"));
        app1Cred.addToken(new Text("token2"), token2);
        DataOutputBuffer dob = new DataOutputBuffer();
        app1Cred.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer byteBuffer = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        appCredentials.put(ApplicationId.newInstance((long)1234L, (int)1), byteBuffer);
        record.setSystemCredentialsForApps((Collection)YarnServerBuilderUtils.convertToProtoFormat(appCredentials));
        NodeHeartbeatResponsePBImpl proto = new NodeHeartbeatResponsePBImpl(((NodeHeartbeatResponsePBImpl)record).getProto());
        Assertions.assertEquals(appCredentials, (Object)YarnServerBuilderUtils.convertFromProtoFormat((Collection)proto.getSystemCredentialsForApps()));
    }

    @Test
    public void testNodeHeartBeatRequest() throws IOException {
        NodeHeartbeatRequest record = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        NodeStatus nodeStatus = (NodeStatus)Records.newRecord(NodeStatus.class);
        OpportunisticContainersStatus opportunisticContainersStatus = (OpportunisticContainersStatus)Records.newRecord(OpportunisticContainersStatus.class);
        opportunisticContainersStatus.setEstimatedQueueWaitTime(123);
        opportunisticContainersStatus.setWaitQueueLength(321);
        nodeStatus.setOpportunisticContainersStatus(opportunisticContainersStatus);
        record.setNodeStatus(nodeStatus);
        HashSet attributeSet = Sets.newHashSet((Object[])new NodeAttribute[]{NodeAttribute.newInstance((String)"attributeA", (NodeAttributeType)NodeAttributeType.STRING, (String)"valueA"), NodeAttribute.newInstance((String)"attributeB", (NodeAttributeType)NodeAttributeType.STRING, (String)"valueB")});
        record.setNodeAttributes((Set)attributeSet);
        NodeHeartbeatRequestPBImpl pb = new NodeHeartbeatRequestPBImpl(((NodeHeartbeatRequestPBImpl)record).getProto());
        Assertions.assertEquals((int)123, (int)pb.getNodeStatus().getOpportunisticContainersStatus().getEstimatedQueueWaitTime());
        Assertions.assertEquals((int)321, (int)pb.getNodeStatus().getOpportunisticContainersStatus().getWaitQueueLength());
        Assertions.assertEquals((int)2, (int)pb.getNodeAttributes().size());
    }

    @Test
    public void testContainerStatus() {
        ContainerStatus status = (ContainerStatus)Records.newRecord(ContainerStatus.class);
        List<String> ips = Arrays.asList("127.0.0.1", "139.5.25.2");
        status.setIPs(ips);
        status.setHost("locahost123");
        ContainerStatusPBImpl pb = new ContainerStatusPBImpl(((ContainerStatusPBImpl)status).getProto());
        Assertions.assertEquals(ips, (Object)pb.getIPs());
        Assertions.assertEquals((Object)"locahost123", (Object)pb.getHost());
        Assertions.assertEquals((Object)ExecutionType.GUARANTEED, (Object)pb.getExecutionType());
        status.setIPs(null);
        Assertions.assertNull((Object)status.getIPs());
    }
}

