/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.client.AMRMClientUtils;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.AMRMClientRelayer;
import org.apache.hadoop.yarn.server.scheduler.ResourceRequestSet;
import org.apache.hadoop.yarn.util.Records;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAMRMClientRelayer {
    private Configuration conf;
    private MockApplicationMasterService mockAMS;
    private AMRMClientRelayer relayer;
    private int responseId = 0;
    private List<ResourceRequest> asks = new ArrayList<ResourceRequest>();
    private List<ContainerId> releases = new ArrayList<ContainerId>();
    private List<String> blacklistAdditions = new ArrayList<String>();
    private List<String> blacklistRemoval = new ArrayList<String>();

    @BeforeEach
    public void setup() throws YarnException, IOException {
        this.conf = new Configuration();
        this.mockAMS = new MockApplicationMasterService();
        this.relayer = new AMRMClientRelayer((ApplicationMasterProtocol)this.mockAMS, null, "TEST", this.conf);
        this.relayer.registerApplicationMaster(RegisterApplicationMasterRequest.newInstance((String)"", (int)0, (String)""));
        this.clearAllocateRequestLists();
    }

    @AfterEach
    public void cleanup() {
        this.relayer.shutdown();
    }

    private void assertAsksAndReleases(int expectedAsk, int expectedRelease) {
        Assertions.assertEquals((int)expectedAsk, (int)this.mockAMS.lastAsk.size());
        Assertions.assertEquals((int)expectedRelease, (int)this.mockAMS.lastRelease.size());
    }

    private void assertBlacklistAdditionsAndRemovals(int expectedAdditions, int expectedRemovals) {
        Assertions.assertEquals((int)expectedAdditions, (int)this.mockAMS.lastBlacklistAdditions.size());
        Assertions.assertEquals((int)expectedRemovals, (int)this.mockAMS.lastBlacklistRemovals.size());
    }

    private AllocateRequest getAllocateRequest() {
        return AllocateRequest.newInstance((int)this.responseId, (float)0.0f, this.asks, this.releases, (ResourceBlacklistRequest)ResourceBlacklistRequest.newInstance(this.blacklistAdditions, this.blacklistRemoval));
    }

    private void clearAllocateRequestLists() {
        this.asks.clear();
        this.releases.clear();
        this.blacklistAdditions.clear();
        this.blacklistRemoval.clear();
    }

    private static ContainerId createContainerId(int id) {
        return ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1), (long)id);
    }

    protected ResourceRequest createResourceRequest(long id, String resource, int memory, int vCores, int priority, ExecutionType execType, int containers) {
        ResourceRequest req = (ResourceRequest)Records.newRecord(ResourceRequest.class);
        req.setAllocationRequestId(id);
        req.setResourceName(resource);
        req.setCapability(Resource.newInstance((int)memory, (int)vCores));
        req.setPriority(Priority.newInstance((int)priority));
        req.setExecutionTypeRequest(ExecutionTypeRequest.newInstance((ExecutionType)execType));
        req.setNumContainers(containers);
        return req;
    }

    @Test
    public void testResourceRequestCleanup() throws YarnException, IOException {
        this.asks.add(this.createResourceRequest(0L, "node", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "rack", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "*", 2048, 1, 1, ExecutionType.GUARANTEED, 2));
        this.relayer.allocate(this.getAllocateRequest());
        this.assertAsksAndReleases(3, 0);
        Assertions.assertEquals((int)1, (int)this.relayer.getRemotePendingAsks().size());
        ResourceRequestSet set = (ResourceRequestSet)this.relayer.getRemotePendingAsks().values().iterator().next();
        Assertions.assertEquals((int)3, (int)set.getAsks().size());
        this.clearAllocateRequestLists();
        this.asks.add(this.createResourceRequest(0L, "node", 2048, 1, 1, ExecutionType.GUARANTEED, 0));
        this.asks.add(this.createResourceRequest(0L, "*", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.relayer.allocate(this.getAllocateRequest());
        this.assertAsksAndReleases(2, 0);
        Assertions.assertEquals((int)1, (int)this.relayer.getRemotePendingAsks().size());
        set = (ResourceRequestSet)this.relayer.getRemotePendingAsks().values().iterator().next();
        Assertions.assertEquals((int)2, (int)set.getAsks().size());
        this.clearAllocateRequestLists();
        this.asks.add(this.createResourceRequest(0L, "*", 2048, 1, 1, ExecutionType.GUARANTEED, 0));
        this.relayer.allocate(AllocateRequest.newInstance((int)0, (float)0.0f, this.asks, null, null));
        this.assertAsksAndReleases(1, 0);
        Assertions.assertEquals((int)0, (int)this.relayer.getRemotePendingAsks().size());
    }

    @Test
    public void testResendRequestsOnRMRestart() throws YarnException, IOException {
        ContainerId c1 = TestAMRMClientRelayer.createContainerId(1);
        ContainerId c2 = TestAMRMClientRelayer.createContainerId(2);
        ContainerId c3 = TestAMRMClientRelayer.createContainerId(3);
        this.asks.add(this.createResourceRequest(0L, "node1", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "rack", 2048, 1, 1, ExecutionType.GUARANTEED, 1));
        this.asks.add(this.createResourceRequest(0L, "*", 2048, 1, 1, ExecutionType.GUARANTEED, 2));
        this.releases.add(c1);
        this.blacklistAdditions.add("node1");
        this.blacklistRemoval.add("node0");
        this.relayer.allocate(this.getAllocateRequest());
        this.assertAsksAndReleases(3, 1);
        this.assertBlacklistAdditionsAndRemovals(1, 1);
        this.clearAllocateRequestLists();
        this.relayer.allocate(this.getAllocateRequest());
        this.assertAsksAndReleases(0, 0);
        this.assertBlacklistAdditionsAndRemovals(0, 0);
        this.clearAllocateRequestLists();
        this.mockAMS.setFailoverFlag();
        this.blacklistAdditions.add("node2");
        this.releases.add(c2);
        this.relayer.allocate(this.getAllocateRequest());
        this.assertAsksAndReleases(3, 2);
        this.assertBlacklistAdditionsAndRemovals(2, 0);
        this.clearAllocateRequestLists();
    }

    @Test
    public void testResponseIdResync() throws YarnException, IOException {
        this.responseId = 10;
        AllocateResponse response = this.relayer.allocate(this.getAllocateRequest());
        Assertions.assertEquals((int)(this.responseId + 1), (int)response.getResponseId());
        int expected = 5;
        this.mockAMS.setResponseIdReset(expected);
        try {
            this.relayer.allocate(this.getAllocateRequest());
            Assertions.fail((String)"Expecting exception from RM");
        }
        catch (InvalidApplicationMasterRequestException invalidApplicationMasterRequestException) {
            // empty catch block
        }
        response = this.relayer.allocate(this.getAllocateRequest());
        Assertions.assertEquals((int)(expected + 1), (int)response.getResponseId());
        this.responseId = response.getResponseId();
        response = this.relayer.allocate(this.getAllocateRequest());
        Assertions.assertEquals((int)(this.responseId + 1), (int)response.getResponseId());
    }

    @Test
    public void testConcurrentReregister() throws YarnException, IOException {
        this.mockAMS.setFailoverFlag();
        this.mockAMS.setThrowAlreadyRegister();
        this.relayer.finishApplicationMaster(null);
    }

    public static class MockApplicationMasterService
    implements ApplicationMasterProtocol {
        private boolean failover = false;
        private boolean throwAlreadyRegister = false;
        private int responseIdReset = -1;
        private List<ResourceRequest> lastAsk;
        private List<ContainerId> lastRelease;
        private List<String> lastBlacklistAdditions;
        private List<String> lastBlacklistRemovals;

        public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
            if (this.throwAlreadyRegister) {
                this.throwAlreadyRegister = false;
                throw new InvalidApplicationMasterRequestException("Application Master is already registered : appId");
            }
            return null;
        }

        public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
            if (this.failover) {
                this.failover = false;
                throw new ApplicationMasterNotRegisteredException("Mock RM restarted");
            }
            return null;
        }

        public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
            if (this.failover) {
                this.failover = false;
                throw new ApplicationMasterNotRegisteredException("Mock RM restarted");
            }
            if (this.responseIdReset != -1) {
                String errorMessage = AMRMClientUtils.assembleInvalidResponseIdExceptionMessage(null, (int)this.responseIdReset, (int)request.getResponseId());
                this.responseIdReset = -1;
                throw new InvalidApplicationMasterRequestException(errorMessage);
            }
            this.lastAsk = request.getAskList();
            this.lastRelease = request.getReleaseList();
            this.lastBlacklistAdditions = request.getResourceBlacklistRequest().getBlacklistAdditions();
            this.lastBlacklistRemovals = request.getResourceBlacklistRequest().getBlacklistRemovals();
            return AllocateResponse.newInstance((int)(request.getResponseId() + 1), null, null, new ArrayList(), (Resource)Resource.newInstance((int)0, (int)0), null, (int)0, null, null);
        }

        public void setFailoverFlag() {
            this.failover = true;
        }

        public void setThrowAlreadyRegister() {
            this.throwAlreadyRegister = true;
        }

        public void setResponseIdReset(int expectedResponseId) {
            this.responseIdReset = expectedResponseId;
        }
    }
}

