/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.SerializedExceptionPBImpl;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NodeHeartbeatRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NodeHeartbeatResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RegisterNodeManagerRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RegisterNodeManagerResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.UnRegisterNodeManagerRequestPBImpl;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.impl.pb.MasterKeyPBImpl;
import org.apache.hadoop.yarn.server.api.records.impl.pb.NodeStatusPBImpl;
import org.apache.hadoop.yarn.server.utils.YarnServerBuilderUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestYarnServerApiClasses {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testRegisterNodeManagerResponsePBImpl() {
        RegisterNodeManagerResponsePBImpl original = new RegisterNodeManagerResponsePBImpl();
        original.setContainerTokenMasterKey(this.getMasterKey());
        original.setNMTokenMasterKey(this.getMasterKey());
        original.setNodeAction(NodeAction.NORMAL);
        original.setDiagnosticsMessage("testDiagnosticMessage");
        RegisterNodeManagerResponsePBImpl copy = new RegisterNodeManagerResponsePBImpl(original.getProto());
        Assertions.assertEquals((int)1, (int)copy.getContainerTokenMasterKey().getKeyId());
        Assertions.assertEquals((int)1, (int)copy.getNMTokenMasterKey().getKeyId());
        Assertions.assertEquals((Object)NodeAction.NORMAL, (Object)copy.getNodeAction());
        Assertions.assertEquals((Object)"testDiagnosticMessage", (Object)copy.getDiagnosticsMessage());
        Assertions.assertFalse((boolean)copy.getAreNodeLabelsAcceptedByRM());
    }

    @Test
    public void testRegisterNodeManagerResponsePBImplWithRMAcceptLbls() {
        RegisterNodeManagerResponsePBImpl original = new RegisterNodeManagerResponsePBImpl();
        original.setAreNodeLabelsAcceptedByRM(true);
        RegisterNodeManagerResponsePBImpl copy = new RegisterNodeManagerResponsePBImpl(original.getProto());
        Assertions.assertTrue((boolean)copy.getAreNodeLabelsAcceptedByRM());
    }

    @Test
    public void testNodeHeartbeatRequestPBImpl() {
        NodeHeartbeatRequestPBImpl original = new NodeHeartbeatRequestPBImpl();
        original.setLastKnownContainerTokenMasterKey(this.getMasterKey());
        original.setLastKnownNMTokenMasterKey(this.getMasterKey());
        original.setNodeStatus(this.getNodeStatus());
        original.setNodeLabels(this.getValidNodeLabels());
        Map<ApplicationId, AppCollectorData> collectors = this.getCollectors(false);
        original.setRegisteringCollectors(collectors);
        NodeHeartbeatRequestPBImpl copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Assertions.assertEquals((int)1, (int)copy.getLastKnownContainerTokenMasterKey().getKeyId());
        Assertions.assertEquals((int)1, (int)copy.getLastKnownNMTokenMasterKey().getKeyId());
        Assertions.assertEquals((Object)"localhost", (Object)copy.getNodeStatus().getNodeId().getHost());
        Assertions.assertEquals(collectors, (Object)copy.getRegisteringCollectors());
        Assertions.assertTrue((boolean)original.getNodeLabels().containsAll(copy.getNodeLabels()));
        original.setNodeLabels(new HashSet());
        copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Assertions.assertNotNull((Object)copy.getNodeLabels());
        Assertions.assertEquals((int)0, (int)copy.getNodeLabels().size());
    }

    @Test
    public void testNodeHBRequestPBImplWithNullCollectorToken() {
        NodeHeartbeatRequestPBImpl original = new NodeHeartbeatRequestPBImpl();
        Map<ApplicationId, AppCollectorData> collectors = this.getCollectors(true);
        original.setRegisteringCollectors(collectors);
        NodeHeartbeatRequestPBImpl copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Assertions.assertEquals(collectors, (Object)copy.getRegisteringCollectors());
    }

    @Test
    public void testNodeHeartbeatRequestPBImplWithNullLabels() {
        NodeHeartbeatRequestPBImpl original = new NodeHeartbeatRequestPBImpl();
        NodeHeartbeatRequestPBImpl copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Assertions.assertNull((Object)copy.getNodeLabels());
    }

    @Test
    public void testNodeHeartbeatResponsePBImpl() throws IOException {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        original.setDiagnosticsMessage("testDiagnosticMessage");
        original.setContainerTokenMasterKey(this.getMasterKey());
        original.setNMTokenMasterKey(this.getMasterKey());
        original.setNextHeartBeatInterval(1000L);
        original.setNodeAction(NodeAction.NORMAL);
        original.setResponseId(100);
        Map<ApplicationId, AppCollectorData> collectors = this.getCollectors(false);
        original.setAppCollectors(collectors);
        Text userText1 = new Text("user1");
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(userText1, new Text("renewer1"), userText1);
        org.apache.hadoop.security.token.Token expectedToken1 = new org.apache.hadoop.security.token.Token(dtId1.getBytes(), "password12".getBytes(), dtId1.getKind(), new Text("service1"));
        Credentials credentials1 = new Credentials();
        credentials1.addToken(expectedToken1.getService(), expectedToken1);
        DataOutputBuffer dob1 = new DataOutputBuffer();
        credentials1.writeTokenStorageToStream((DataOutputStream)dob1);
        ByteBuffer byteBuffer1 = ByteBuffer.wrap(dob1.getData(), 0, dob1.getLength());
        HashMap<ApplicationId, ByteBuffer> systemCredentials = new HashMap<ApplicationId, ByteBuffer>();
        systemCredentials.put(this.getApplicationId(1), byteBuffer1);
        original.setSystemCredentialsForApps((Collection)YarnServerBuilderUtils.convertToProtoFormat(systemCredentials));
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Assertions.assertEquals((int)100, (int)copy.getResponseId());
        Assertions.assertEquals((Object)NodeAction.NORMAL, (Object)copy.getNodeAction());
        Assertions.assertEquals((long)1000L, (long)copy.getNextHeartBeatInterval());
        Assertions.assertEquals((int)1, (int)copy.getContainerTokenMasterKey().getKeyId());
        Assertions.assertEquals((int)1, (int)copy.getNMTokenMasterKey().getKeyId());
        Assertions.assertEquals((Object)"testDiagnosticMessage", (Object)copy.getDiagnosticsMessage());
        Assertions.assertEquals(collectors, (Object)copy.getAppCollectors());
        Assertions.assertEquals((Object)false, (Object)copy.getAreNodeLabelsAcceptedByRM());
        Assertions.assertEquals((int)1, (int)copy.getSystemCredentialsForApps().size());
        Credentials credentials1Out = new Credentials();
        DataInputByteBuffer buf = new DataInputByteBuffer();
        ByteBuffer buffer = (ByteBuffer)YarnServerBuilderUtils.convertFromProtoFormat((Collection)copy.getSystemCredentialsForApps()).get(this.getApplicationId(1));
        Assertions.assertNotNull((Object)buffer);
        buffer.rewind();
        buf.reset(new ByteBuffer[]{buffer});
        credentials1Out.readTokenStorageStream((DataInputStream)buf);
        Assertions.assertEquals((int)1, (int)credentials1Out.getAllTokens().size());
        Assertions.assertEquals((int)10, (int)((org.apache.hadoop.security.token.Token)credentials1Out.getAllTokens().iterator().next()).getPassword().length);
    }

    @Test
    public void testNodeHeartbeatResponsePBImplWithRMAcceptLbls() {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        original.setAreNodeLabelsAcceptedByRM(true);
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Assertions.assertTrue((boolean)copy.getAreNodeLabelsAcceptedByRM());
    }

    @Test
    public void testNodeHBResponsePBImplWithNullCollectorToken() {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        Map<ApplicationId, AppCollectorData> collectors = this.getCollectors(true);
        original.setAppCollectors(collectors);
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Assertions.assertEquals(collectors, (Object)copy.getAppCollectors());
    }

    @Test
    public void testNodeHeartbeatResponsePBImplWithDecreasedContainers() {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        original.addAllContainersToUpdate(Arrays.asList(this.getDecreasedContainer(1, 2, 2048, 2), this.getDecreasedContainer(2, 3, 1024, 1)));
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Assertions.assertEquals((long)1L, (long)((Container)copy.getContainersToUpdate().get(0)).getId().getContainerId());
        Assertions.assertEquals((long)1024L, (long)((Container)copy.getContainersToUpdate().get(1)).getResource().getMemorySize());
    }

    @Test
    public void testRegisterNodeManagerRequestPBImpl() {
        RegisterNodeManagerRequestPBImpl original = new RegisterNodeManagerRequestPBImpl();
        original.setHttpPort(8080);
        original.setNodeId(this.getNodeId());
        Resource resource = (Resource)recordFactory.newRecordInstance(Resource.class);
        resource.setMemorySize(10000L);
        resource.setVirtualCores(2);
        original.setResource(resource);
        original.setPhysicalResource(resource);
        RegisterNodeManagerRequestPBImpl copy = new RegisterNodeManagerRequestPBImpl(original.getProto());
        Assertions.assertEquals((int)8080, (int)copy.getHttpPort());
        Assertions.assertEquals((int)9090, (int)copy.getNodeId().getPort());
        Assertions.assertEquals((long)10000L, (long)copy.getResource().getMemorySize());
        Assertions.assertEquals((int)2, (int)copy.getResource().getVirtualCores());
        Assertions.assertEquals((long)10000L, (long)copy.getPhysicalResource().getMemorySize());
        Assertions.assertEquals((int)2, (int)copy.getPhysicalResource().getVirtualCores());
    }

    @Test
    public void testMasterKeyPBImpl() {
        MasterKeyPBImpl original = new MasterKeyPBImpl();
        original.setBytes(ByteBuffer.allocate(0));
        original.setKeyId(1);
        MasterKeyPBImpl copy = new MasterKeyPBImpl(original.getProto());
        Assertions.assertEquals((int)1, (int)copy.getKeyId());
        Assertions.assertTrue((boolean)original.equals((Object)copy));
        Assertions.assertEquals((int)original.hashCode(), (int)copy.hashCode());
    }

    @Test
    public void testSerializedExceptionPBImpl() {
        SerializedExceptionPBImpl original = new SerializedExceptionPBImpl();
        original.init("testMessage");
        SerializedExceptionPBImpl copy = new SerializedExceptionPBImpl(original.getProto());
        Assertions.assertEquals((Object)"testMessage", (Object)copy.getMessage());
        original = new SerializedExceptionPBImpl();
        original.init("testMessage", new Throwable(new Throwable("parent")));
        copy = new SerializedExceptionPBImpl(original.getProto());
        Assertions.assertEquals((Object)"testMessage", (Object)copy.getMessage());
        Assertions.assertEquals((Object)"parent", (Object)copy.getCause().getMessage());
        Assertions.assertTrue((boolean)copy.getRemoteTrace().startsWith("java.lang.Throwable: java.lang.Throwable: parent"));
    }

    @Test
    public void testNodeStatusPBImpl() {
        NodeStatusPBImpl original = new NodeStatusPBImpl();
        original.setContainersStatuses(Arrays.asList(this.getContainerStatus(1, 2, 1), this.getContainerStatus(2, 3, 1)));
        original.setKeepAliveApplications(Arrays.asList(this.getApplicationId(3), this.getApplicationId(4)));
        original.setNodeHealthStatus(this.getNodeHealthStatus());
        original.setNodeId(this.getNodeId());
        original.setResponseId(1);
        original.setIncreasedContainers(Arrays.asList(this.getIncreasedContainer(1, 2, 2048, 2), this.getIncreasedContainer(2, 3, 4096, 3)));
        NodeStatusPBImpl copy = new NodeStatusPBImpl(original.getProto());
        Assertions.assertEquals((long)3L, (long)((ContainerStatus)copy.getContainersStatuses().get(1)).getContainerId().getContainerId());
        Assertions.assertEquals((int)3, (int)((ApplicationId)copy.getKeepAliveApplications().get(0)).getId());
        Assertions.assertEquals((long)1000L, (long)copy.getNodeHealthStatus().getLastHealthReportTime());
        Assertions.assertEquals((int)9090, (int)copy.getNodeId().getPort());
        Assertions.assertEquals((int)1, (int)copy.getResponseId());
        Assertions.assertEquals((long)1L, (long)((Container)copy.getIncreasedContainers().get(0)).getId().getContainerId());
        Assertions.assertEquals((long)4096L, (long)((Container)copy.getIncreasedContainers().get(1)).getResource().getMemorySize());
    }

    @Test
    public void testRegisterNodeManagerRequestWithNullLabels() {
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host", (int)1234), (int)1234, (Resource)Resource.newInstance((int)0, (int)0), (String)"version", null, null);
        RegisterNodeManagerRequestPBImpl request1 = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assertions.assertNull((Object)request1.getNodeLabels());
    }

    @Test
    public void testRegisterNodeManagerRequestWithValidLabels() {
        HashSet<NodeLabel> nodeLabels = this.getValidNodeLabels();
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host", (int)1234), (int)1234, (Resource)Resource.newInstance((int)0, (int)0), (String)"version", null, null, nodeLabels);
        RegisterNodeManagerRequestPBImpl copy = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assertions.assertEquals((Object)true, (Object)nodeLabels.containsAll(copy.getNodeLabels()));
        request.setNodeLabels(new HashSet());
        copy = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assertions.assertNotNull((Object)copy.getNodeLabels());
        Assertions.assertEquals((int)0, (int)copy.getNodeLabels().size());
    }

    @Test
    public void testUnRegisterNodeManagerRequestPBImpl() throws Exception {
        UnRegisterNodeManagerRequestPBImpl request = new UnRegisterNodeManagerRequestPBImpl();
        NodeId nodeId = NodeId.newInstance((String)"host", (int)1234);
        request.setNodeId(nodeId);
        UnRegisterNodeManagerRequestPBImpl copy = new UnRegisterNodeManagerRequestPBImpl(request.getProto());
        Assertions.assertEquals((Object)nodeId, (Object)copy.getNodeId());
    }

    private HashSet<NodeLabel> getValidNodeLabels() {
        HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>();
        nodeLabels.add(NodeLabel.newInstance((String)"java"));
        nodeLabels.add(NodeLabel.newInstance((String)"windows"));
        nodeLabels.add(NodeLabel.newInstance((String)"gpu"));
        nodeLabels.add(NodeLabel.newInstance((String)"x86"));
        return nodeLabels;
    }

    private Map<ApplicationId, AppCollectorData> getCollectors(boolean hasNullCollectorToken) {
        ApplicationId appID = ApplicationId.newInstance((long)1L, (int)1);
        String collectorAddr = "localhost:0";
        AppCollectorData data = AppCollectorData.newInstance((ApplicationId)appID, (String)collectorAddr);
        if (!hasNullCollectorToken) {
            data.setCollectorToken(Token.newInstance((byte[])new byte[0], (String)"kind", (byte[])new byte[0], (String)"s"));
        }
        HashMap<ApplicationId, AppCollectorData> collectorMap = new HashMap<ApplicationId, AppCollectorData>();
        collectorMap.put(appID, data);
        return collectorMap;
    }

    private ContainerStatus getContainerStatus(int applicationId, int containerID, int appAttemptId) {
        ContainerStatus status = (ContainerStatus)recordFactory.newRecordInstance(ContainerStatus.class);
        status.setContainerId(this.getContainerId(containerID, appAttemptId));
        return status;
    }

    private ApplicationAttemptId getApplicationAttemptId(int appAttemptId) {
        ApplicationAttemptId result = ApplicationAttemptIdPBImpl.newInstance((ApplicationId)this.getApplicationId(appAttemptId), (int)appAttemptId);
        return result;
    }

    private ContainerId getContainerId(int containerID, int appAttemptId) {
        ContainerId containerId = ContainerIdPBImpl.newContainerId((ApplicationAttemptId)this.getApplicationAttemptId(appAttemptId), (long)containerID);
        return containerId;
    }

    private ApplicationId getApplicationId(int applicationId) {
        ApplicationIdPBImpl appId = new ApplicationIdPBImpl(){

            public ApplicationIdPBImpl setParameters(int id, long timestamp) {
                this.setClusterTimestamp(timestamp);
                this.setId(id);
                this.build();
                return this;
            }
        }.setParameters(applicationId, 1000L);
        return new ApplicationIdPBImpl(appId.getProto());
    }

    private Container getDecreasedContainer(int containerID, int appAttemptId, int memory, int vCores) {
        ContainerId containerId = this.getContainerId(containerID, appAttemptId);
        Resource capability = Resource.newInstance((int)memory, (int)vCores);
        return Container.newInstance((ContainerId)containerId, null, null, (Resource)capability, null, null);
    }

    private Container getIncreasedContainer(int containerID, int appAttemptId, int memory, int vCores) {
        ContainerId containerId = this.getContainerId(containerID, appAttemptId);
        Resource capability = Resource.newInstance((int)memory, (int)vCores);
        return Container.newInstance((ContainerId)containerId, null, null, (Resource)capability, null, null);
    }

    private NodeStatus getNodeStatus() {
        NodeStatus status = (NodeStatus)recordFactory.newRecordInstance(NodeStatus.class);
        status.setContainersStatuses(new ArrayList());
        status.setKeepAliveApplications(new ArrayList());
        status.setNodeHealthStatus(this.getNodeHealthStatus());
        status.setNodeId(this.getNodeId());
        status.setResponseId(1);
        return status;
    }

    private NodeId getNodeId() {
        return NodeId.newInstance((String)"localhost", (int)9090);
    }

    private NodeHealthStatus getNodeHealthStatus() {
        NodeHealthStatus healStatus = (NodeHealthStatus)recordFactory.newRecordInstance(NodeHealthStatus.class);
        healStatus.setHealthReport("healthReport");
        healStatus.setIsNodeHealthy(true);
        healStatus.setLastHealthReportTime(1000L);
        return healStatus;
    }

    private MasterKey getMasterKey() {
        MasterKey key = (MasterKey)recordFactory.newRecordInstance(MasterKey.class);
        key.setBytes(ByteBuffer.allocate(0));
        key.setKeyId(1);
        return key;
    }
}

