/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.impl.pb.RpcClientFactoryPBImpl;
import org.apache.hadoop.yarn.factories.impl.pb.RpcServerFactoryPBImpl;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestYSCRPCFactories {
    @Test
    public void test() {
        this.testPbServerFactory();
        this.testPbClientFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPbServerFactory() {
        InetSocketAddress addr = new InetSocketAddress(0);
        Configuration conf = new Configuration();
        ResourceTrackerTestImpl instance = new ResourceTrackerTestImpl();
        Server server = null;
        try {
            server = RpcServerFactoryPBImpl.get().getServer(ResourceTracker.class, (Object)instance, addr, conf, null, 1);
            server.start();
        }
        catch (YarnRuntimeException e) {
            e.printStackTrace();
            Assertions.fail((String)"Failed to create server");
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPbClientFactory() {
        InetSocketAddress addr = new InetSocketAddress(0);
        System.err.println(addr.getHostName() + addr.getPort());
        Configuration conf = new Configuration();
        ResourceTrackerTestImpl instance = new ResourceTrackerTestImpl();
        Server server = null;
        try {
            server = RpcServerFactoryPBImpl.get().getServer(ResourceTracker.class, (Object)instance, addr, conf, null, 1);
            server.start();
            System.err.println(server.getListenerAddress());
            System.err.println(NetUtils.getConnectAddress((Server)server));
            ResourceTracker client = null;
            try {
                client = (ResourceTracker)RpcClientFactoryPBImpl.get().getClient(ResourceTracker.class, 1L, NetUtils.getConnectAddress((Server)server), conf);
            }
            catch (YarnRuntimeException e) {
                e.printStackTrace();
                Assertions.fail((String)"Failed to create client");
            }
        }
        catch (YarnRuntimeException e) {
            e.printStackTrace();
            Assertions.fail((String)"Failed to create server");
        }
        finally {
            server.stop();
        }
    }

    public class ResourceTrackerTestImpl
    implements ResourceTracker {
        public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnException, IOException {
            return null;
        }

        public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnException, IOException {
            return null;
        }

        public UnRegisterNodeManagerResponse unRegisterNodeManager(UnRegisterNodeManagerRequest request) throws YarnException, IOException {
            return null;
        }
    }
}

