/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factories.impl.pb.RpcClientFactoryPBImpl;
import org.apache.hadoop.yarn.factories.impl.pb.RpcServerFactoryPBImpl;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.ResourceTracker;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerResponse;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestResourceTrackerPBClientImpl {
    private static ResourceTracker client;
    private static Server server;
    private static final RecordFactory recordFactory;

    @BeforeAll
    public static void start() {
        InetSocketAddress address = new InetSocketAddress(0);
        Configuration configuration = new Configuration();
        ResourceTrackerTestImpl instance = new ResourceTrackerTestImpl();
        server = RpcServerFactoryPBImpl.get().getServer(ResourceTracker.class, (Object)instance, address, configuration, null, 1);
        server.start();
        client = (ResourceTracker)RpcClientFactoryPBImpl.get().getClient(ResourceTracker.class, 1L, NetUtils.getConnectAddress((Server)server), configuration);
    }

    @AfterAll
    public static void stop() {
        if (server != null) {
            server.stop();
        }
    }

    @Test
    public void testResourceTrackerPBClientImpl() throws Exception {
        RegisterNodeManagerRequest request = (RegisterNodeManagerRequest)recordFactory.newRecordInstance(RegisterNodeManagerRequest.class);
        Assertions.assertNotNull((Object)client.registerNodeManager(request));
        ResourceTrackerTestImpl.exception = true;
        try {
            client.registerNodeManager(request);
            Assertions.fail((String)"there  should be YarnException");
        }
        catch (YarnException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("testMessage"));
        }
        finally {
            ResourceTrackerTestImpl.exception = false;
        }
    }

    @Test
    public void testNodeHeartbeat() throws Exception {
        NodeHeartbeatRequest request = (NodeHeartbeatRequest)recordFactory.newRecordInstance(NodeHeartbeatRequest.class);
        Assertions.assertNotNull((Object)client.nodeHeartbeat(request));
        ResourceTrackerTestImpl.exception = true;
        try {
            client.nodeHeartbeat(request);
            Assertions.fail((String)"there  should be YarnException");
        }
        catch (YarnException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("testMessage"));
        }
        finally {
            ResourceTrackerTestImpl.exception = false;
        }
    }

    @Test
    public void testUnRegisterNodeManager() throws Exception {
        UnRegisterNodeManagerRequest request = UnRegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host1", (int)1234));
        Assertions.assertNotNull((Object)client.unRegisterNodeManager(request));
        ResourceTrackerTestImpl.exception = true;
        try {
            client.unRegisterNodeManager(request);
            Assertions.fail((String)"there  should be YarnException");
        }
        catch (YarnException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("testMessage"));
        }
        finally {
            ResourceTrackerTestImpl.exception = false;
        }
    }

    static {
        recordFactory = RecordFactoryProvider.getRecordFactory(null);
    }

    public static class ResourceTrackerTestImpl
    implements ResourceTracker {
        public static boolean exception = false;

        public RegisterNodeManagerResponse registerNodeManager(RegisterNodeManagerRequest request) throws YarnException, IOException {
            if (exception) {
                throw new YarnException("testMessage");
            }
            return (RegisterNodeManagerResponse)recordFactory.newRecordInstance(RegisterNodeManagerResponse.class);
        }

        public NodeHeartbeatResponse nodeHeartbeat(NodeHeartbeatRequest request) throws YarnException, IOException {
            if (exception) {
                throw new YarnException("testMessage");
            }
            return (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
        }

        public UnRegisterNodeManagerResponse unRegisterNodeManager(UnRegisterNodeManagerRequest request) throws YarnException, IOException {
            if (exception) {
                throw new YarnException("testMessage");
            }
            return UnRegisterNodeManagerResponse.newInstance();
        }
    }
}

