/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.metrics;

import org.apache.hadoop.yarn.server.federation.store.metrics.FederationStateStoreClientMetrics;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFederationStateStoreClientMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(TestFederationStateStoreClientMetrics.class);
    private MockBadFederationStateStore badStateStore = new MockBadFederationStateStore();
    private MockGoodFederationStateStore goodStateStore = new MockGoodFederationStateStore();

    @Test
    public void testAggregateMetricInit() {
        LOG.info("Test: aggregate metrics are initialized correctly");
        Assert.assertEquals((long)0L, (long)FederationStateStoreClientMetrics.getNumSucceededCalls());
        Assert.assertEquals((long)0L, (long)FederationStateStoreClientMetrics.getNumFailedCalls());
        LOG.info("Test: aggregate metrics are updated correctly");
    }

    @Test
    public void testSuccessfulCalls() {
        LOG.info("Test: Aggregate and method successful calls updated correctly");
        long totalGoodBefore = FederationStateStoreClientMetrics.getNumSucceededCalls();
        long apiGoodBefore = FederationStateStoreClientMetrics.getNumSucceessfulCallsForMethod((String)"registerSubCluster");
        this.goodStateStore.registerSubCluster(100L);
        Assert.assertEquals((long)(totalGoodBefore + 1L), (long)FederationStateStoreClientMetrics.getNumSucceededCalls());
        Assert.assertEquals((double)100.0, (double)FederationStateStoreClientMetrics.getLatencySucceededCalls(), (double)0.0);
        Assert.assertEquals((long)(apiGoodBefore + 1L), (long)FederationStateStoreClientMetrics.getNumSucceededCalls());
        Assert.assertEquals((double)100.0, (double)FederationStateStoreClientMetrics.getLatencySucceessfulCallsForMethod((String)"registerSubCluster"), (double)0.0);
        LOG.info("Test: Running stats correctly calculated for 2 metrics");
        this.goodStateStore.registerSubCluster(200L);
        Assert.assertEquals((long)(totalGoodBefore + 2L), (long)FederationStateStoreClientMetrics.getNumSucceededCalls());
        Assert.assertEquals((double)150.0, (double)FederationStateStoreClientMetrics.getLatencySucceededCalls(), (double)0.0);
        Assert.assertEquals((long)(apiGoodBefore + 2L), (long)FederationStateStoreClientMetrics.getNumSucceededCalls());
        Assert.assertEquals((double)150.0, (double)FederationStateStoreClientMetrics.getLatencySucceessfulCallsForMethod((String)"registerSubCluster"), (double)0.0);
    }

    @Test
    public void testFailedCalls() {
        long totalBadbefore = FederationStateStoreClientMetrics.getNumFailedCalls();
        long apiBadBefore = FederationStateStoreClientMetrics.getNumFailedCallsForMethod((String)"registerSubCluster");
        this.badStateStore.registerSubCluster();
        LOG.info("Test: Aggregate and method failed calls updated correctly");
        Assert.assertEquals((long)(totalBadbefore + 1L), (long)FederationStateStoreClientMetrics.getNumFailedCalls());
        Assert.assertEquals((long)(apiBadBefore + 1L), (long)FederationStateStoreClientMetrics.getNumFailedCallsForMethod((String)"registerSubCluster"));
    }

    @Test
    public void testCallsUnknownMethod() {
        long totalBadbefore = FederationStateStoreClientMetrics.getNumFailedCalls();
        long apiBadBefore = FederationStateStoreClientMetrics.getNumFailedCallsForMethod((String)"registerSubCluster");
        long totalGoodBefore = FederationStateStoreClientMetrics.getNumSucceededCalls();
        long apiGoodBefore = FederationStateStoreClientMetrics.getNumSucceessfulCallsForMethod((String)"registerSubCluster");
        LOG.info("Calling Metrics class directly");
        FederationStateStoreClientMetrics.failedStateStoreCall();
        FederationStateStoreClientMetrics.succeededStateStoreCall((long)100L);
        LOG.info("Test: Aggregate and method calls did not update");
        Assert.assertEquals((long)totalBadbefore, (long)FederationStateStoreClientMetrics.getNumFailedCalls());
        Assert.assertEquals((long)apiBadBefore, (long)FederationStateStoreClientMetrics.getNumFailedCallsForMethod((String)"registerSubCluster"));
        Assert.assertEquals((long)totalGoodBefore, (long)FederationStateStoreClientMetrics.getNumSucceededCalls());
        Assert.assertEquals((long)apiGoodBefore, (long)FederationStateStoreClientMetrics.getNumSucceessfulCallsForMethod((String)"registerSubCluster"));
    }

    private class MockBadFederationStateStore {
        private MockBadFederationStateStore() {
        }

        public void registerSubCluster() {
            LOG.info("Mocked: failed registerSubCluster call");
            FederationStateStoreClientMetrics.failedStateStoreCall();
        }
    }

    private class MockGoodFederationStateStore {
        private MockGoodFederationStateStore() {
        }

        public void registerSubCluster(long duration) {
            LOG.info("Mocked: successful registerSubCluster call with duration {}", (Object)duration);
            FederationStateStoreClientMetrics.succeededStateStoreCall((long)duration);
        }
    }
}

