/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocolPB;
import org.apache.hadoop.yarn.api.protocolrecords.CommitResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ContainerUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLocalizationStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReInitializeContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceLocalizationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RestartContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RollbackResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.HadoopYarnProtoRPC;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.api.CollectorNodemanagerProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetTimelineCollectorContextResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReportNewCollectorInfoRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReportNewCollectorInfoResponse;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;

public class TestRPC {
    private static final String EXCEPTION_MSG = "test error";
    private static final String EXCEPTION_CAUSE = "exception cause";
    private static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);
    public static final String ILLEGAL_NUMBER_MESSAGE = "collectors' number in ReportNewCollectorInfoRequest is not ONE.";
    public static final String DEFAULT_COLLECTOR_ADDR = "localhost:0";
    private static final Token DEFAULT_COLLECTOR_TOKEN;
    public static final ApplicationId DEFAULT_APP_ID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnknownCall() {
        Configuration conf = new Configuration();
        conf.set("yarn.ipc.rpc.class", HadoopYarnProtoRPC.class.getName());
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String bindAddr = DEFAULT_COLLECTOR_ADDR;
        InetSocketAddress addr = NetUtils.createSocketAddr((String)bindAddr);
        Server server = rpc.getServer(ContainerManagementProtocol.class, (Object)new DummyContainerManager(), addr, conf, null, 1);
        server.start();
        ApplicationClientProtocol proxy = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, NetUtils.getConnectAddress((Server)server), conf);
        try {
            proxy.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
            Assert.fail((String)"Excepted RPC call to fail with unknown method.");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().matches("Unknown method getNewApplication called on.*org.apache.hadoop.yarn.proto.ApplicationClientProtocol\\$ApplicationClientProtocolService\\$BlockingInterface protocol."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testRPCOnCollectorNodeManagerProtocol() throws IOException {
        ReportNewCollectorInfoRequest request;
        Configuration conf = new Configuration();
        conf.set("yarn.ipc.rpc.class", HadoopYarnProtoRPC.class.getName());
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String bindAddr = DEFAULT_COLLECTOR_ADDR;
        InetSocketAddress addr = NetUtils.createSocketAddr((String)bindAddr);
        Server server = rpc.getServer(CollectorNodemanagerProtocol.class, (Object)new DummyNMCollectorService(), addr, conf, null, 1);
        server.start();
        ApplicationClientProtocol unknownProxy = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, NetUtils.getConnectAddress((Server)server), conf);
        try {
            unknownProxy.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
            Assert.fail((String)"Excepted RPC call to fail with unknown method.");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().matches("Unknown method getNewApplication called on.*org.apache.hadoop.yarn.proto.ApplicationClientProtocol\\$ApplicationClientProtocolService\\$BlockingInterface protocol."));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CollectorNodemanagerProtocol proxy = (CollectorNodemanagerProtocol)rpc.getProxy(CollectorNodemanagerProtocol.class, NetUtils.getConnectAddress((Server)server), conf);
        try {
            request = ReportNewCollectorInfoRequest.newInstance((ApplicationId)DEFAULT_APP_ID, (String)DEFAULT_COLLECTOR_ADDR, null);
            proxy.reportNewCollectorInfo(request);
        }
        catch (YarnException e) {
            Assert.fail((String)"RPC call failured is not expected here.");
        }
        try {
            request = ReportNewCollectorInfoRequest.newInstance((ApplicationId)DEFAULT_APP_ID, (String)DEFAULT_COLLECTOR_ADDR, (Token)DEFAULT_COLLECTOR_TOKEN);
            proxy.reportNewCollectorInfo(request);
        }
        catch (YarnException e) {
            Assert.fail((String)"RPC call failured is not expected here.");
        }
        try {
            proxy.reportNewCollectorInfo((ReportNewCollectorInfoRequest)Records.newRecord(ReportNewCollectorInfoRequest.class));
            Assert.fail((String)"Excepted RPC call to fail with YarnException.");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(ILLEGAL_NUMBER_MESSAGE));
        }
        try {
            request = GetTimelineCollectorContextRequest.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1));
            GetTimelineCollectorContextResponse response = proxy.getTimelineCollectorContext((GetTimelineCollectorContextRequest)request);
            Assert.assertEquals((Object)"test_user_id", (Object)response.getUserId());
            Assert.assertEquals((Object)"test_flow_name", (Object)response.getFlowName());
            Assert.assertEquals((Object)"test_flow_version", (Object)response.getFlowVersion());
            Assert.assertEquals((long)12345678L, (long)response.getFlowRunId());
        }
        catch (IOException | YarnException e) {
            Assert.fail((String)"RPC call failured is not expected here.");
        }
        try {
            request = GetTimelineCollectorContextRequest.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)2));
            proxy.getTimelineCollectorContext((GetTimelineCollectorContextRequest)request);
            Assert.fail((String)"RPC call failured is expected here.");
        }
        catch (IOException | YarnException e) {
            Assert.assertTrue((boolean)(e instanceof YarnException));
            Assert.assertTrue((boolean)e.getMessage().contains("The application is not found."));
        }
        server.stop();
    }

    @Test
    public void testHadoopProtoRPC() throws Exception {
        this.test(HadoopYarnProtoRPC.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(String rpcClass) throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.ipc.rpc.class", rpcClass);
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String bindAddr = DEFAULT_COLLECTOR_ADDR;
        InetSocketAddress addr = NetUtils.createSocketAddr((String)bindAddr);
        Server server = rpc.getServer(ContainerManagementProtocol.class, (Object)new DummyContainerManager(), addr, conf, null, 1);
        server.start();
        RPC.setProtocolEngine((Configuration)conf, ContainerManagementProtocolPB.class, ProtobufRpcEngine2.class);
        ContainerManagementProtocol proxy = (ContainerManagementProtocol)rpc.getProxy(ContainerManagementProtocol.class, NetUtils.getConnectAddress((Server)server), conf);
        ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)RECORD_FACTORY.newRecordInstance(ContainerLaunchContext.class);
        ApplicationId applicationId = ApplicationId.newInstance((long)0L, (int)0);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)0);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)100L);
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)1234);
        Resource resource = Resource.newInstance((int)1234, (int)2);
        ContainerTokenIdentifier containerTokenIdentifier = new ContainerTokenIdentifier(containerId, "localhost", "user", resource, System.currentTimeMillis() + 10000L, 42, 42L, Priority.newInstance((int)0), 0L);
        Token containerToken = TestRPC.newContainerToken(nodeId, "password".getBytes(), containerTokenIdentifier);
        StartContainerRequest scRequest = StartContainerRequest.newInstance((ContainerLaunchContext)containerLaunchContext, (Token)containerToken);
        ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
        list.add(scRequest);
        StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
        proxy.startContainers(allRequests);
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        GetContainerStatusesRequest gcsRequest = GetContainerStatusesRequest.newInstance(containerIds);
        GetContainerStatusesResponse response = proxy.getContainerStatuses(gcsRequest);
        List statuses = response.getContainerStatuses();
        boolean exception = false;
        try {
            StopContainersRequest stopRequest = (StopContainersRequest)RECORD_FACTORY.newRecordInstance(StopContainersRequest.class);
            stopRequest.setContainerIds(containerIds);
            proxy.stopContainers(stopRequest);
        }
        catch (YarnException e) {
            exception = true;
            Assert.assertTrue((boolean)e.getMessage().contains(EXCEPTION_MSG));
            Assert.assertTrue((boolean)e.getMessage().contains(EXCEPTION_CAUSE));
            System.out.println("Test Exception is " + e.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            server.stop();
        }
        Assert.assertTrue((boolean)exception);
        Assert.assertNotNull(statuses.get(0));
        Assert.assertEquals((Object)ContainerState.RUNNING, (Object)((ContainerStatus)statuses.get(0)).getState());
    }

    public static ContainerTokenIdentifier newContainerTokenIdentifier(Token containerToken) throws IOException {
        org.apache.hadoop.security.token.Token token = new org.apache.hadoop.security.token.Token(containerToken.getIdentifier().array(), containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
        return (ContainerTokenIdentifier)token.decodeIdentifier();
    }

    public static Token newContainerToken(NodeId nodeId, byte[] password, ContainerTokenIdentifier tokenIdentifier) {
        InetSocketAddress addr = NetUtils.createSocketAddrForHost((String)nodeId.getHost(), (int)nodeId.getPort());
        Token containerToken = Token.newInstance((byte[])tokenIdentifier.getBytes(), (String)ContainerTokenIdentifier.KIND.toString(), (byte[])password, (String)SecurityUtil.buildTokenService((InetSocketAddress)addr).toString());
        return containerToken;
    }

    static {
        TimelineDelegationTokenIdentifier identifier = new TimelineDelegationTokenIdentifier();
        identifier.setOwner(new Text("user"));
        identifier.setRenewer(new Text("user"));
        identifier.setRealUser(new Text("user"));
        long now = Time.now();
        identifier.setIssueDate(now);
        identifier.setMaxDate(now + 1000L);
        identifier.setMasterKeyId(500);
        identifier.setSequenceNumber(5);
        DEFAULT_COLLECTOR_TOKEN = Token.newInstance((byte[])identifier.getBytes(), (String)identifier.getKind().toString(), (byte[])identifier.getBytes(), (String)DEFAULT_COLLECTOR_ADDR);
        DEFAULT_APP_ID = ApplicationId.newInstance((long)0L, (int)0);
    }

    public class DummyContainerManager
    implements ContainerManagementProtocol {
        private List<ContainerStatus> statuses = new ArrayList<ContainerStatus>();

        public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException {
            GetContainerStatusesResponse response = (GetContainerStatusesResponse)RECORD_FACTORY.newRecordInstance(GetContainerStatusesResponse.class);
            response.setContainerStatuses(this.statuses);
            return response;
        }

        public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException {
            StartContainersResponse response = (StartContainersResponse)RECORD_FACTORY.newRecordInstance(StartContainersResponse.class);
            for (StartContainerRequest request : requests.getStartContainerRequests()) {
                Token containerToken = request.getContainerToken();
                ContainerTokenIdentifier tokenId = null;
                try {
                    tokenId = TestRPC.newContainerTokenIdentifier(containerToken);
                }
                catch (IOException e) {
                    throw RPCUtil.getRemoteException((Throwable)e);
                }
                ContainerStatus status = (ContainerStatus)RECORD_FACTORY.newRecordInstance(ContainerStatus.class);
                status.setState(ContainerState.RUNNING);
                status.setContainerId(tokenId.getContainerID());
                status.setExitStatus(0);
                this.statuses.add(status);
            }
            return response;
        }

        public StopContainersResponse stopContainers(StopContainersRequest request) throws YarnException {
            Exception e = new Exception(TestRPC.EXCEPTION_MSG, new Exception(TestRPC.EXCEPTION_CAUSE));
            throw new YarnException((Throwable)e);
        }

        @Deprecated
        public IncreaseContainersResourceResponse increaseContainersResource(IncreaseContainersResourceRequest request) throws YarnException, IOException {
            return null;
        }

        public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException {
            Exception e = new Exception(TestRPC.EXCEPTION_MSG, new Exception(TestRPC.EXCEPTION_CAUSE));
            throw new YarnException((Throwable)e);
        }

        public ResourceLocalizationResponse localize(ResourceLocalizationRequest request) throws YarnException, IOException {
            return null;
        }

        public ReInitializeContainerResponse reInitializeContainer(ReInitializeContainerRequest request) throws YarnException, IOException {
            return null;
        }

        public RestartContainerResponse restartContainer(ContainerId containerId) throws YarnException, IOException {
            return null;
        }

        public RollbackResponse rollbackLastReInitialization(ContainerId containerId) throws YarnException, IOException {
            return null;
        }

        public CommitResponse commitLastReInitialization(ContainerId containerId) throws YarnException, IOException {
            return null;
        }

        public ContainerUpdateResponse updateContainer(ContainerUpdateRequest request) throws YarnException, IOException {
            return null;
        }

        public GetLocalizationStatusesResponse getLocalizationStatuses(GetLocalizationStatusesRequest request) throws YarnException, IOException {
            return null;
        }
    }

    public class DummyNMCollectorService
    implements CollectorNodemanagerProtocol {
        public ReportNewCollectorInfoResponse reportNewCollectorInfo(ReportNewCollectorInfoRequest request) throws YarnException, IOException {
            List appCollectors = request.getAppCollectorsList();
            if (appCollectors.size() != 1) {
                throw new YarnException(TestRPC.ILLEGAL_NUMBER_MESSAGE);
            }
            AppCollectorData appCollector = (AppCollectorData)appCollectors.get(0);
            Assert.assertEquals((Object)appCollector.getApplicationId(), (Object)DEFAULT_APP_ID);
            Assert.assertEquals((Object)appCollector.getCollectorAddr(), (Object)TestRPC.DEFAULT_COLLECTOR_ADDR);
            Assert.assertTrue((appCollector.getCollectorToken() == null || appCollector.getCollectorToken().equals(DEFAULT_COLLECTOR_TOKEN) ? 1 : 0) != 0);
            ReportNewCollectorInfoResponse response = (ReportNewCollectorInfoResponse)RECORD_FACTORY.newRecordInstance(ReportNewCollectorInfoResponse.class);
            return response;
        }

        public GetTimelineCollectorContextResponse getTimelineCollectorContext(GetTimelineCollectorContextRequest request) throws YarnException, IOException {
            if (request.getApplicationId().getId() == 1) {
                return GetTimelineCollectorContextResponse.newInstance((String)"test_user_id", (String)"test_flow_name", (String)"test_flow_version", (long)12345678L);
            }
            throw new YarnException("The application is not found.");
        }
    }
}

