/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.sql;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.yarn.server.federation.store.impl.MySQLFederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.sql.FederationSQLAccuracyTest;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFederationMySQLScriptAccuracy
extends FederationSQLAccuracyTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestFederationMySQLScriptAccuracy.class);
    private static final String MYSQL_COMPATIBILITY = ";sql.syntax_mys=true";

    protected MySQLFederationStateStore createStateStore() {
        return new MySQLFederationStateStore();
    }

    @Override
    protected String getSQLURL() {
        return "jdbc:hsqldb:mem:state" + System.currentTimeMillis() + MYSQL_COMPATIBILITY;
    }

    @Test
    public void checkMysqlScriptAccuracy() throws SQLException {
        MySQLFederationStateStore federationStateStore = this.createStateStore();
        federationStateStore.initConnection(this.getConf());
        List<String> tables = federationStateStore.getTables();
        for (String table : tables) {
            federationStateStore.getConn().prepareStatement(table).execute();
        }
        LOG.info("FederationStateStore create {} tables.", (Object)tables.size());
    }
}

