/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.utils;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;

public class YarnServerBuilderUtils {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public static NodeHeartbeatResponse newNodeHeartbeatResponse(NodeAction action, String diagnosticsMessage) {
        NodeHeartbeatResponse response = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
        response.setNodeAction(action);
        response.setDiagnosticsMessage(diagnosticsMessage);
        return response;
    }

    public static NodeHeartbeatResponse newNodeHeartbeatResponse(int responseId, NodeAction action, List<ContainerId> containersToCleanUp, List<ApplicationId> applicationsToCleanUp, MasterKey containerTokenMasterKey, MasterKey nmTokenMasterKey, long nextHeartbeatInterval) {
        NodeHeartbeatResponse response = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
        response.setResponseId(responseId);
        response.setNodeAction(action);
        response.setContainerTokenMasterKey(containerTokenMasterKey);
        response.setNMTokenMasterKey(nmTokenMasterKey);
        response.setNextHeartBeatInterval(nextHeartbeatInterval);
        if (containersToCleanUp != null) {
            response.addAllContainersToCleanup(containersToCleanUp);
        }
        if (applicationsToCleanUp != null) {
            response.addAllApplicationsToCleanup(applicationsToCleanUp);
        }
        return response;
    }

    public static YarnServerCommonServiceProtos.SystemCredentialsForAppsProto newSystemCredentialsForAppsProto(ApplicationId applicationId, ByteBuffer credentials) {
        YarnServerCommonServiceProtos.SystemCredentialsForAppsProto systemCredentialsForAppsProto = YarnServerCommonServiceProtos.SystemCredentialsForAppsProto.newBuilder().setAppId(ProtoUtils.convertToProtoFormat((ApplicationId)applicationId)).setCredentialsForApp((ByteString)ProtoUtils.BYTE_STRING_INTERNER.intern((Object)ProtoUtils.convertToProtoFormat((ByteBuffer)credentials.duplicate()))).build();
        return systemCredentialsForAppsProto;
    }

    public static Map<ApplicationId, ByteBuffer> convertFromProtoFormat(Collection<YarnServerCommonServiceProtos.SystemCredentialsForAppsProto> systemCredentials) {
        HashMap<ApplicationId, ByteBuffer> systemCredentialsForApps = new HashMap<ApplicationId, ByteBuffer>(systemCredentials.size());
        for (YarnServerCommonServiceProtos.SystemCredentialsForAppsProto proto : systemCredentials) {
            systemCredentialsForApps.put((ApplicationId)ProtoUtils.convertFromProtoFormat((YarnProtos.ApplicationIdProto)proto.getAppId()), ProtoUtils.convertFromProtoFormat((ByteString)proto.getCredentialsForApp()));
        }
        return systemCredentialsForApps;
    }

    public static List<YarnServerCommonServiceProtos.SystemCredentialsForAppsProto> convertToProtoFormat(Map<ApplicationId, ByteBuffer> systemCredentialsForApps) {
        ArrayList<YarnServerCommonServiceProtos.SystemCredentialsForAppsProto> systemCredentials = new ArrayList<YarnServerCommonServiceProtos.SystemCredentialsForAppsProto>(systemCredentialsForApps.size());
        for (Map.Entry<ApplicationId, ByteBuffer> entry : systemCredentialsForApps.entrySet()) {
            YarnServerCommonServiceProtos.SystemCredentialsForAppsProto proto = YarnServerBuilderUtils.newSystemCredentialsForAppsProto(entry.getKey(), entry.getValue());
            systemCredentials.add(proto);
        }
        return systemCredentials;
    }
}

