/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.api.records.timeline.writer.TimelineDomainWriter;
import org.apache.hadoop.yarn.api.records.timeline.writer.TimelineDomainsWriter;
import org.apache.hadoop.yarn.api.records.timeline.writer.TimelineEntitiesWriter;
import org.apache.hadoop.yarn.api.records.timeline.writer.TimelineEntityWriter;
import org.apache.hadoop.yarn.api.records.timeline.writer.TimelineEventsWriter;
import org.apache.hadoop.yarn.api.records.timeline.writer.TimelinePutResponseWriter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.ContextFactory;
import org.apache.hadoop.yarn.server.timeline.TestMemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.reader.TimelineAboutReader;
import org.apache.hadoop.yarn.server.timeline.reader.TimelineDomainReader;
import org.apache.hadoop.yarn.server.timeline.reader.TimelineDomainsReader;
import org.apache.hadoop.yarn.server.timeline.reader.TimelineEntitiesReader;
import org.apache.hadoop.yarn.server.timeline.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.server.timeline.reader.TimelineEventsReader;
import org.apache.hadoop.yarn.server.timeline.reader.TimelinePutResponseReader;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;
import org.apache.hadoop.yarn.server.timeline.webapp.TimelineWebServices;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.assertj.core.api.Assertions;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestTimelineWebServices
extends JerseyTestBase {
    private static TimelineStore store;
    private static TimelineACLsManager timelineACLsManager;
    private static AdminACLsManager adminACLsManager;
    private static long beforeTime;
    private static HttpServletRequest request;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(TimelineWebServices.class);
        config.register(TimelineEntitiesReader.class);
        config.register(TimelineEntitiesWriter.class);
        config.register(TimelineEntityWriter.class);
        config.register(TimelineDomainReader.class);
        config.register(TimelineDomainsWriter.class);
        config.register(TimelineDomainWriter.class);
        config.register(TimelineEventsWriter.class);
        config.register(GenericExceptionHandler.class);
        config.register(TimelinePutResponseWriter.class);
        config.register((Object)new JettisonFeature()).register(YarnJacksonJaxbJsonProvider.class);
        this.forceSet("jersey.config.test.container.port", "0");
        return config;
    }

    private static TimelineStore mockTimelineStore() throws Exception {
        beforeTime = System.currentTimeMillis() - 1L;
        TestMemoryTimelineStore store = new TestMemoryTimelineStore();
        store.setup();
        return store.getTimelineStore();
    }

    @Test
    void testAbout() {
        WebTarget target = (WebTarget)this.target().register(TimelineAboutReader.class);
        Response response = (Response)target.path("ws").path("v1").path("timeline").request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelineAbout actualAbout = (TimelineAbout)response.readEntity(TimelineAbout.class);
        TimelineAbout expectedAbout = TimelineUtils.createTimelineAbout((String)"Timeline API");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)actualAbout, (String)"Timeline service about response is null");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getAbout(), (Object)actualAbout.getAbout());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceVersion(), (Object)actualAbout.getTimelineServiceVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceBuildVersion(), (Object)actualAbout.getTimelineServiceBuildVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceVersionBuiltOn(), (Object)actualAbout.getTimelineServiceVersionBuiltOn());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopVersion(), (Object)actualAbout.getHadoopVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopBuildVersion(), (Object)actualAbout.getHadoopBuildVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopVersionBuiltOn(), (Object)actualAbout.getHadoopVersionBuiltOn());
    }

    private static void verifyEntities(TimelineEntities entities) {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entities);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)entities.getEntities().size());
        TimelineEntity entity1 = (TimelineEntity)entities.getEntities().get(0);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_1", (Object)entity1.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity1.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity1.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)entity1.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity1.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity1.getOtherInfo().size());
        TimelineEntity entity2 = (TimelineEntity)entities.getEntities().get(1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_2", (Object)entity2.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity2.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity2.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)entity2.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity2.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity2.getOtherInfo().size());
        TimelineEntity entity3 = (TimelineEntity)entities.getEntities().get(2);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_6", (Object)entity3.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity3.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)61L, (long)entity3.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)entity3.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity3.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity3.getOtherInfo().size());
    }

    @Test
    void testGetEntities() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntitiesReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.readEntity(TimelineEntities.class));
    }

    @Test
    void testFromId() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntitiesReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", new Object[]{"id_2"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((TimelineEntities)response.readEntity(TimelineEntities.class)).getEntities().size());
        response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", new Object[]{"id_1"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((TimelineEntities)response.readEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testFromTs() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntitiesReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", new Object[]{Long.toString(beforeTime)}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((TimelineEntities)response.readEntity(TimelineEntities.class)).getEntities().size());
        response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", new Object[]{Long.toString(System.currentTimeMillis())}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((TimelineEntities)response.readEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testPrimaryFilterString() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntitiesReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", new Object[]{"user:username"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.readEntity(TimelineEntities.class));
    }

    @Test
    public void testPrimaryFilterInteger() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntitiesReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", new Object[]{"appname:2147483647"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.readEntity(TimelineEntities.class));
    }

    @Test
    public void testPrimaryFilterLong() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntitiesReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", new Object[]{"long:2147483648"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.readEntity(TimelineEntities.class));
    }

    @Test
    public void testSecondaryFilters() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntitiesReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("secondaryFilter", new Object[]{"user:username,appname:2147483647"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.readEntity(TimelineEntities.class));
    }

    @Test
    public void testGetEntity() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntityReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelineEntity entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)entity.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEntityFields1() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntityReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", new Object[]{"events,otherinfo"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelineEntity entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)entity.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)entity.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEntityFields2() {
        WebTarget r = (WebTarget)this.target().register(TimelineEntityReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", new Object[]{"lasteventonly,primaryfilters,relatedentities"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelineEntity entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)entity.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEvents() {
        WebTarget r = (WebTarget)this.target().register(TimelineEventsReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("type_1").path("events").queryParam("entityId", new Object[]{"id_1"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelineEvents events = (TimelineEvents)response.readEntity(TimelineEvents.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)events);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.getAllEvents().size());
        TimelineEvents.EventsOfOneEntity partEvents = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)partEvents.getEvents().size());
        TimelineEvent event1 = (TimelineEvent)partEvents.getEvents().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)456L, (long)event1.getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"end_event", (Object)event1.getEventType());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)event1.getEventInfo().size());
        TimelineEvent event2 = (TimelineEvent)partEvents.getEvents().get(1);
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)event2.getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"start_event", (Object)event2.getEventType());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)event2.getEventInfo().size());
    }

    @Test
    public void testPostEntitiesWithPrimaryFilter() {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        HashMap filters = new HashMap();
        filters.put(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), new HashSet());
        entity.setPrimaryFilters(filters);
        entity.setEntityId("test id 6");
        entity.setEntityType("test type 6");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entities.addEntity(entity);
        WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"tester");
        Response response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"tester"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
        TimelinePutResponse putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
    }

    @Test
    public void testPostEntities() {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId("test id 1");
        entity.setEntityType("test type 1");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entity.setDomainId("domain_id_1");
        entities.addEntity(entity);
        WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"tester");
        response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"tester"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelinePutResponse putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)putResponse);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
        response = (Response)r.path("ws").path("v1").path("timeline").path("test type 1").path("test id 1").request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 1", (Object)entity.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test type 1", (Object)entity.getEntityType());
    }

    @Test
    public void testPostIncompleteEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity1 = new TimelineEntity();
        entity1.setEntityId("test id 1");
        entity1.setEntityType("test type 1");
        entity1.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entity1.setDomainId("domain_id_1");
        entities.addEntity(entity1);
        entities.addEntity(new TimelineEntity());
        WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"tester");
        Response response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"tester"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostEntitiesWithYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 2");
            entity.setEntityType("test type 2");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"writer_user_1");
            Response response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"writer_user_1"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)putResponse);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"writer_user_3");
            response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"writer_user_3"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)putResponse);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)putResponse.getErrors().size());
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)((TimelinePutResponse.TimelinePutError)putResponse.getErrors().get(0)).getErrorCode());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 3");
            entity.setEntityType("test type 2");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            entity.setRelatedEntities(Collections.singletonMap("test type 2", Collections.singleton("test id 2")));
            entities.addEntity(entity);
            r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"writer_user_3");
            response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"writer_user_3"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)putResponse);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)putResponse.getErrors().size());
            org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)((TimelinePutResponse.TimelinePutError)putResponse.getErrors().get(0)).getErrorCode());
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"reader_user_3");
            response = (Response)r.path("ws").path("v1").path("timeline").path("test type 2").path("test id 3").queryParam("user.name", new Object[]{"reader_user_3"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 3", (Object)entity.getEntityId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test type 2", (Object)entity.getEntityType());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostEntitiesToDefaultDomain() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 7");
            entity.setEntityType("test type 7");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entities.addEntity(entity);
            WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"anybody_1");
            Response response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"anybody_1"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)putResponse);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"any_body_2");
            response = (Response)r.path("ws").path("v1").path("timeline").path("test type 7").path("test id 7").queryParam("user.name", new Object[]{"any_body_2"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 7", (Object)entity.getEntityId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test type 7", (Object)entity.getEntityType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"DEFAULT", (Object)entity.getDomainId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntityWithYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 3");
            entity.setEntityType("test type 3");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"writer_user_1");
            Response response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"writer_user_1"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            response = (Response)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("user.name", new Object[]{"reader_user_1"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"reader_user_1");
            response = (Response)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("fields", new Object[]{"relatedentities"}).queryParam("user.name", new Object[]{"reader_user_1"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"reader_user_1");
            response = (Response)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("fields", new Object[]{"primaryfilters"}).queryParam("user.name", new Object[]{"reader_user_1"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            entity = (TimelineEntity)response.readEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"reader_user_2");
            response = (Response)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("user.name", new Object[]{"reader_user_2"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEntitiesWithYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 4");
            entity.setEntityType("test type 4");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"writer_user_1");
            Response response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"writer_user_1"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 5");
            entity.setEntityType("test type 4");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            entities.addEntity(entity);
            r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"writer_user_3");
            response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"writer_user_3"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"reader_user_1");
            response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"reader_user_1"}).path("test type 4").request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            entities = (TimelineEntities)response.readEntity(TimelineEntities.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)entities.getEntities().size());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test type 4", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 4", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetEventsWithYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 5");
            entity.setEntityType("test type 5");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            TimelineEvent event = new TimelineEvent();
            event.setEventType("event type 1");
            event.setTimestamp(System.currentTimeMillis());
            entity.addEvent(event);
            entities.addEntity(entity);
            WebTarget r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class)).register(TimelineEventsReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"writer_user_1");
            Response response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"writer_user_1"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 6");
            entity.setEntityType("test type 5");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            event = new TimelineEvent();
            event.setEventType("event type 2");
            event.setTimestamp(System.currentTimeMillis());
            entity.addEvent(event);
            entities.addEntity(entity);
            r = (WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)((WebTarget)this.target().register(TimelineDomainsReader.class)).register(TimelineEntitiesWriter.class)).register(TimelineDomainReader.class)).register(TimelineEntityReader.class)).register(TimelinePutResponseReader.class)).register(TimelineEntitiesReader.class)).register(TimelineEventsReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"writer_user_3");
            response = (Response)r.path("ws").path("v1").path("timeline").queryParam("user.name", new Object[]{"writer_user_3"}).request(new String[]{"application/json"}).post(Entity.json((Object)entities), Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            putResponse = (TimelinePutResponse)response.readEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"reader_user_1");
            response = (Response)r.path("ws").path("v1").path("timeline").path("test type 5").path("events").queryParam("user.name", new Object[]{"reader_user_1"}).queryParam("entityId", new Object[]{"test id 5,test id 6"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            TimelineEvents events = (TimelineEvents)response.readEntity(TimelineEvents.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.getAllEvents().size());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 5", (Object)((TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0)).getEntityId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    public void testGetDomain() throws Exception {
        WebTarget r = (WebTarget)this.target().register(TimelineDomainReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelineDomain domain = (TimelineDomain)response.readEntity(TimelineDomain.class);
        TestTimelineWebServices.verifyDomain(domain, "domain_id_1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDomainYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            WebTarget r = (WebTarget)this.target().register(TimelineDomainReader.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"owner_1");
            Response response = (Response)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").queryParam("user.name", new Object[]{"owner_1"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            TimelineDomain domain = (TimelineDomain)response.readEntity(TimelineDomain.class);
            TestTimelineWebServices.verifyDomain(domain, "domain_id_1");
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"tester");
            response = (Response)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").queryParam("user.name", new Object[]{"tester"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    public void testGetDomains() throws Exception {
        WebTarget r = (WebTarget)this.target().register(TimelineDomainsReader.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("domain").queryParam("owner", new Object[]{"owner_1"}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelineDomains domains = (TimelineDomains)response.readEntity(TimelineDomains.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)domains.getDomains().size());
        for (int i = 0; i < domains.getDomains().size(); ++i) {
            TestTimelineWebServices.verifyDomain((TimelineDomain)domains.getDomains().get(i), i == 0 ? "domain_id_4" : "domain_id_1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDomainsYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"owner_1");
            WebTarget r = (WebTarget)this.target().register(TimelineDomainsReader.class);
            Response response = (Response)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", new Object[]{"owner_1"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            TimelineDomains domains = (TimelineDomains)response.readEntity(TimelineDomains.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)domains.getDomains().size());
            for (int i = 0; i < domains.getDomains().size(); ++i) {
                TestTimelineWebServices.verifyDomain((TimelineDomain)domains.getDomains().get(i), i == 0 ? "domain_id_4" : "domain_id_1");
            }
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"testerw");
            response = (Response)r.path("ws").path("v1").path("timeline").path("domain").queryParam("owner", new Object[]{"owner_1"}).queryParam("user.name", new Object[]{"tester"}).request(new String[]{"application/json"}).get(Response.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
            domains = (TimelineDomains)response.readEntity(TimelineDomains.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)domains.getDomains().size());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    public void testPutDomain() throws Exception {
        TimelineDomain domain = new TimelineDomain();
        domain.setId("test_domain_id");
        WebTarget r = (WebTarget)((WebTarget)this.target().register(TimelineDomainReader.class)).register(TimelineDomainWriter.class);
        Response response = (Response)r.path("ws").path("v1").path("timeline").path("domain").request(new String[]{"application/json"}).put(Entity.json((Object)domain), Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"tester");
        response = (Response)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", new Object[]{"tester"}).request(new String[]{"application/json"}).put(Entity.json((Object)domain), Response.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
        response = (Response)r.path("ws").path("v1").path("timeline").path("domain").path("test_domain_id").request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        domain = (TimelineDomain)response.readEntity(TimelineDomain.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test_domain_id", (Object)domain.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"tester", (Object)domain.getOwner());
        org.junit.jupiter.api.Assertions.assertNull((Object)domain.getDescription());
        domain.setDescription("test_description");
        response = (Response)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", new Object[]{"tester"}).request(new String[]{"application/json"}).put(Entity.json((Object)domain), Response.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
        response = (Response)r.path("ws").path("v1").path("timeline").path("domain").path("test_domain_id").request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        domain = (TimelineDomain)response.readEntity(TimelineDomain.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test_domain_id", (Object)domain.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test_description", (Object)domain.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutDomainYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineDomain domain = new TimelineDomain();
            domain.setId("test_domain_id_acl");
            WebTarget r = (WebTarget)((WebTarget)this.target().register(TimelineDomainReader.class)).register(TimelineDomainWriter.class);
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"tester");
            Response response = (Response)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", new Object[]{"tester"}).request(new String[]{"application/json"}).put(Entity.json((Object)domain), Response.class);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
            Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"other");
            response = (Response)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", new Object[]{"other"}).request(new String[]{"application/json"}).put(Entity.json((Object)domain), Response.class);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    public void testContextFactory() throws Exception {
        JAXBContext jaxbContext1 = ContextFactory.createContext((Class[])new Class[]{TimelineDomain.class}, (Map)Collections.EMPTY_MAP);
        JAXBContext jaxbContext2 = ContextFactory.createContext((Class[])new Class[]{TimelineDomain.class}, (Map)Collections.EMPTY_MAP);
        org.junit.jupiter.api.Assertions.assertEquals((Object)jaxbContext1, (Object)jaxbContext2);
        try {
            ContextFactory.createContext((Class[])new Class[]{TimelineEntity.class}, (Map)Collections.EMPTY_MAP);
            org.junit.jupiter.api.Assertions.fail((String)"Expected JAXBException");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(JAXBException.class);
        }
    }

    private static void verifyDomain(TimelineDomain domain, String domainId) {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain);
        org.junit.jupiter.api.Assertions.assertEquals((Object)domainId, (Object)domain.getId());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getDescription());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getOwner());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getReaders());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getWriters());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getCreatedTime());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getModifiedTime());
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            try {
                store = TestTimelineWebServices.mockTimelineStore();
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.fail();
            }
            YarnConfiguration conf = new YarnConfiguration();
            conf.setBoolean("yarn.acl.enable", false);
            timelineACLsManager = new TimelineACLsManager((Configuration)conf);
            timelineACLsManager.setTimelineStore(store);
            conf.setBoolean("yarn.acl.enable", true);
            conf.set("yarn.admin.acl", "admin");
            adminACLsManager = new AdminACLsManager((Configuration)conf);
            TimelineDataManager timelineDataManager = new TimelineDataManager(store, timelineACLsManager);
            timelineDataManager.init((Configuration)conf);
            timelineDataManager.start();
            this.bind(timelineDataManager).to(TimelineDataManager.class);
            TimelineAuthenticationFilter taFilter = new TimelineAuthenticationFilter();
            FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)filterConfig.getInitParameter("config.prefix")).thenReturn(null);
            Mockito.when((Object)filterConfig.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)filterConfig.getInitParameter("simple.anonymous.allowed")).thenReturn((Object)"true");
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)filterConfig.getServletContext()).thenReturn((Object)context);
            Enumeration names = (Enumeration)Mockito.mock(Enumeration.class);
            Mockito.when((Object)names.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
            Mockito.when((Object)((String)names.nextElement())).thenReturn((Object)"type", (Object[])new String[]{"simple.anonymous.allowed", "delegation-token.token-kind"});
            Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn((Object)names);
            Mockito.when((Object)filterConfig.getInitParameter("delegation-token.token-kind")).thenReturn((Object)TimelineDelegationTokenIdentifier.KIND_NAME.toString());
            try {
                taFilter.init(filterConfig);
            }
            catch (ServletException e) {
                org.junit.jupiter.api.Assertions.fail((String)("Unable to initialize TimelineAuthenticationFilter: " + e.getMessage()));
            }
            taFilter = (TimelineAuthenticationFilter)Mockito.spy((Object)taFilter);
            try {
                ((TimelineAuthenticationFilter)Mockito.doNothing().when((Object)taFilter)).init((FilterConfig)ArgumentMatchers.any(FilterConfig.class));
            }
            catch (ServletException e) {
                org.junit.jupiter.api.Assertions.fail((String)("Unable to initialize TimelineAuthenticationFilter: " + e.getMessage()));
            }
            request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
        }
    }
}

