/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;

@Provider
@Consumes(value={"application/json"})
public class TimelineEventsReader
implements MessageBodyReader<TimelineEvents> {
    private ObjectMapper objectMapper = new ObjectMapper();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == TimelineEvents.class;
    }

    public TimelineEvents readFrom(Class<TimelineEvents> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        TimelineEvents timelineEvents = (TimelineEvents)this.objectMapper.readValue(entityStream, TimelineEvents.class);
        if (timelineEvents != null) {
            List allEvents = timelineEvents.getAllEvents();
            for (TimelineEvents.EventsOfOneEntity oneEvent : allEvents) {
                if (oneEvent.getEvents() == null) {
                    oneEvent.setEvents(new ArrayList());
                    continue;
                }
                List events = oneEvent.getEvents();
                for (TimelineEvent event : events) {
                    Map eventInfo = event.getEventInfo();
                    if (eventInfo != null) continue;
                    event.setEventInfo(new HashMap());
                }
            }
        }
        return timelineEvents;
    }
}

