/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.reader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;

@Provider
@Consumes(value={"application/json"})
public class ContainerLogsInfoListReader
implements MessageBodyReader<List<ContainerLogsInfo>> {
    private ObjectMapper objectMapper = new ObjectMapper();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public List<ContainerLogsInfo> readFrom(Class<List<ContainerLogsInfo>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ArrayList<ContainerLogsInfo> containerLogsInfos = new ArrayList<ContainerLogsInfo>();
        JsonNode jsonNode = this.objectMapper.readTree(entityStream);
        JsonNode jnContainerLogsInfoes = jsonNode.get("containerLogsInfoes");
        if (!jnContainerLogsInfoes.isArray()) {
            JsonNode jnContainerLogsInfo = jnContainerLogsInfoes.get("containerLogsInfo");
            if (jnContainerLogsInfo.isArray()) {
                for (JsonNode jnContainerLogsInfoItem : jnContainerLogsInfo) {
                    ContainerLogsInfo containerLogsInfo = this.getContainerLogsInfo(jnContainerLogsInfoItem);
                    containerLogsInfos.add(containerLogsInfo);
                }
            } else {
                ContainerLogsInfo containerLogsInfo = this.getContainerLogsInfo(jnContainerLogsInfo);
                containerLogsInfos.add(containerLogsInfo);
            }
        }
        return containerLogsInfos;
    }

    private ContainerLogsInfo getContainerLogsInfo(JsonNode jnContainerLogsInfo) {
        JsonNode jnContainerLogInfo;
        JsonNode jnNodeId;
        JsonNode jnContainerId;
        ContainerLogsInfo containerLogsInfo = new ContainerLogsInfo();
        containerLogsInfo.setContainerLogsInfo(new ArrayList());
        JsonNode jnLogAggregationType = jnContainerLogsInfo.get("logAggregationType");
        if (jnLogAggregationType != null) {
            containerLogsInfo.setLogType(jnLogAggregationType.asText());
        }
        if ((jnContainerId = jnContainerLogsInfo.get("containerId")) != null) {
            containerLogsInfo.setContainerId(jnContainerId.asText());
        }
        if ((jnNodeId = jnContainerLogsInfo.get("nodeId")) != null) {
            containerLogsInfo.setNodeId(jnNodeId.asText());
        }
        if ((jnContainerLogInfo = jnContainerLogsInfo.get("containerLogInfo")) != null && !jnContainerLogInfo.isArray()) {
            ContainerLogFileInfo containerLogFileInfo = new ContainerLogFileInfo();
            JsonNode jnFileName = jnContainerLogInfo.get("fileName");
            JsonNode jnFileSize = jnContainerLogInfo.get("fileSize");
            JsonNode jnLastModifiedTime = jnContainerLogInfo.get("lastModifiedTime");
            containerLogFileInfo.setFileName(jnFileName.asText());
            containerLogFileInfo.setFileSize(jnFileSize.asText());
            containerLogFileInfo.setLastModifiedTime(jnLastModifiedTime.asText());
            containerLogsInfo.getContainerLogsInfo().add(containerLogFileInfo);
        }
        return containerLogsInfo;
    }
}

