/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TestLeveldbTimelineStore
extends TimelineStoreTestUtils {
    private FileContext fsContext;
    private File fsPath;
    private Configuration config = new YarnConfiguration();

    @BeforeEach
    public void setup() throws Exception {
        this.fsContext = FileContext.getLocalFSFileContext();
        this.fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        this.config.set("yarn.timeline-service.leveldb-timeline-store.path", this.fsPath.getAbsolutePath());
        this.config.setBoolean("yarn.timeline-service.ttl-enable", false);
        this.store = new LeveldbTimelineStore();
        this.store.init(this.config);
        this.store.start();
        this.loadTestEntityData();
        this.loadVerificationEntityData();
        this.loadTestDomainData();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.store.stop();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
    }

    @Test
    void testRootDirPermission() throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new YarnConfiguration());
        FileStatus file = fs.getFileStatus(new Path(this.fsPath.getAbsolutePath(), "leveldb-timeline-store.ldb"));
        Assertions.assertNotNull((Object)file);
        Assertions.assertEquals((Object)LeveldbTimelineStore.LEVELDB_DIR_UMASK, (Object)file.getPermission());
    }

    @Override
    @Test
    public void testGetSingleEntity() throws IOException {
        super.testGetSingleEntity();
        ((LeveldbTimelineStore)this.store).clearStartTimeCache();
        super.testGetSingleEntity();
        this.loadTestEntityData();
    }

    @Override
    @Test
    public void testGetEntities() throws IOException {
        super.testGetEntities();
    }

    @Override
    @Test
    public void testGetEntitiesWithFromId() throws IOException {
        super.testGetEntitiesWithFromId();
    }

    @Override
    @Test
    public void testGetEntitiesWithFromTs() throws IOException {
        super.testGetEntitiesWithFromTs();
    }

    @Override
    @Test
    public void testGetEntitiesWithPrimaryFilters() throws IOException {
        super.testGetEntitiesWithPrimaryFilters();
    }

    @Override
    @Test
    public void testGetEntitiesWithSecondaryFilters() throws IOException {
        super.testGetEntitiesWithSecondaryFilters();
    }

    @Override
    @Test
    public void testGetEvents() throws IOException {
        super.testGetEvents();
    }

    @Test
    void testCacheSizes() {
        Configuration conf = new Configuration();
        Assertions.assertEquals((int)10000, (int)LeveldbTimelineStore.getStartTimeReadCacheSize((Configuration)conf));
        Assertions.assertEquals((int)10000, (int)LeveldbTimelineStore.getStartTimeWriteCacheSize((Configuration)conf));
        conf.setInt("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 10001);
        Assertions.assertEquals((int)10001, (int)LeveldbTimelineStore.getStartTimeReadCacheSize((Configuration)conf));
        conf = new Configuration();
        conf.setInt("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 10002);
        Assertions.assertEquals((int)10002, (int)LeveldbTimelineStore.getStartTimeWriteCacheSize((Configuration)conf));
    }

    private boolean deleteNextEntity(String entityType, byte[] ts) throws IOException, InterruptedException {
        boolean bl;
        LeveldbIterator iterator = null;
        LeveldbIterator pfIterator = null;
        try {
            iterator = ((LeveldbTimelineStore)this.store).getDbIterator(false);
            pfIterator = ((LeveldbTimelineStore)this.store).getDbIterator(false);
            bl = ((LeveldbTimelineStore)this.store).deleteNextEntity(entityType, ts, iterator, pfIterator, false);
        }
        catch (DBException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{iterator, pfIterator});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{iterator, pfIterator});
        return bl;
    }

    @Test
    void testGetEntityTypes() throws IOException {
        List entityTypes = ((LeveldbTimelineStore)this.store).getEntityTypes();
        Assertions.assertEquals((int)7, (int)entityTypes.size());
        Assertions.assertEquals((Object)"ACL_ENTITY_TYPE_1", entityTypes.get(0));
        Assertions.assertEquals((Object)"OLD_ENTITY_TYPE_1", entityTypes.get(1));
        Assertions.assertEquals((Object)this.entityType1, entityTypes.get(2));
        Assertions.assertEquals((Object)this.entityType2, entityTypes.get(3));
        Assertions.assertEquals((Object)this.entityType4, entityTypes.get(4));
        Assertions.assertEquals((Object)this.entityType5, entityTypes.get(5));
    }

    @Test
    void testDeleteEntities() throws IOException, InterruptedException {
        Assertions.assertEquals((int)3, (int)this.getEntities("type_1").size());
        Assertions.assertEquals((int)1, (int)this.getEntities("type_2").size());
        Assertions.assertEquals((Object)false, (Object)this.deleteNextEntity(this.entityType1, GenericObjectMapper.writeReverseOrderedLong((long)60L)));
        Assertions.assertEquals((int)3, (int)this.getEntities("type_1").size());
        Assertions.assertEquals((int)1, (int)this.getEntities("type_2").size());
        Assertions.assertEquals((Object)true, (Object)this.deleteNextEntity(this.entityType1, GenericObjectMapper.writeReverseOrderedLong((long)123L)));
        List<TimelineEntity> entities = this.getEntities("type_2");
        Assertions.assertEquals((int)1, (int)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId2, this.entityType2, this.events2, Collections.singletonMap(this.entityType1, Collections.singleton(this.entityId1b)), EMPTY_PRIMARY_FILTERS, EMPTY_MAP, entities.get(0), this.domainId1);
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.userFilter);
        Assertions.assertEquals((int)2, (int)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId2);
        ((LeveldbTimelineStore)this.store).discardOldEntities(0L);
        Assertions.assertEquals((int)2, (int)this.getEntities("type_1").size());
        Assertions.assertEquals((int)0, (int)this.getEntities("type_2").size());
        Assertions.assertEquals((int)6, (int)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assertions.assertEquals((int)0, (int)this.getEntities("type_1").size());
        Assertions.assertEquals((int)0, (int)this.getEntities("type_2").size());
        Assertions.assertEquals((int)0, (int)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }

    @Test
    void testDeleteEntitiesPrimaryFilters() throws IOException, InterruptedException {
        Map<String, Set<Object>> primaryFilter = Collections.singletonMap("user", Collections.singleton("otheruser"));
        TimelineEntities atsEntities = new TimelineEntities();
        atsEntities.setEntities(Collections.singletonList(TestLeveldbTimelineStore.createEntity(this.entityId1b, this.entityType1, 789L, Collections.singletonList(this.ev2), null, primaryFilter, null, this.domainId1)));
        TimelinePutResponse response = this.store.put(atsEntities);
        Assertions.assertEquals((int)0, (int)response.getErrors().size());
        NameValuePair pfPair = new NameValuePair("user", (Object)"otheruser");
        List<TimelineEntity> entities = this.getEntitiesWithPrimaryFilter("type_1", pfPair);
        Assertions.assertEquals((int)1, (int)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId1b, this.entityType1, Collections.singletonList(this.ev2), EMPTY_REL_ENTITIES, primaryFilter, EMPTY_MAP, entities.get(0), this.domainId1);
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.userFilter);
        Assertions.assertEquals((int)3, (int)entities.size());
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TestLeveldbTimelineStore.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        ((LeveldbTimelineStore)this.store).discardOldEntities(-123L);
        Assertions.assertEquals((int)1, (int)this.getEntitiesWithPrimaryFilter("type_1", pfPair).size());
        Assertions.assertEquals((int)3, (int)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assertions.assertEquals((int)0, (int)this.getEntities("type_1").size());
        Assertions.assertEquals((int)0, (int)this.getEntities("type_2").size());
        Assertions.assertEquals((int)0, (int)((LeveldbTimelineStore)this.store).getEntityTypes().size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_1", pfPair).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }

    @Test
    void testFromTsWithDeletion() throws IOException, InterruptedException {
        long l = System.currentTimeMillis();
        Assertions.assertEquals((int)3, (int)this.getEntitiesFromTs("type_1", l).size());
        Assertions.assertEquals((int)1, (int)this.getEntitiesFromTs("type_2", l).size());
        Assertions.assertEquals((int)3, (int)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        ((LeveldbTimelineStore)this.store).discardOldEntities(123L);
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTs("type_1", l).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTs("type_2", l).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        Assertions.assertEquals((int)0, (int)this.getEntities("type_1").size());
        Assertions.assertEquals((int)0, (int)this.getEntities("type_2").size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        this.loadTestEntityData();
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTs("type_1", l).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTs("type_2", l).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, l).size());
        Assertions.assertEquals((int)3, (int)this.getEntities("type_1").size());
        Assertions.assertEquals((int)1, (int)this.getEntities("type_2").size());
        Assertions.assertEquals((int)3, (int)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
    }

    @Test
    void testCheckVersion() throws IOException {
        LeveldbTimelineStore dbStore = (LeveldbTimelineStore)this.store;
        Version defaultVersion = dbStore.getCurrentVersion();
        Assertions.assertEquals((Object)defaultVersion, (Object)dbStore.loadVersion());
        Version compatibleVersion = Version.newInstance((int)defaultVersion.getMajorVersion(), (int)(defaultVersion.getMinorVersion() + 2));
        dbStore.storeVersion(compatibleVersion);
        Assertions.assertEquals((Object)compatibleVersion, (Object)dbStore.loadVersion());
        this.restartTimelineStore();
        dbStore = (LeveldbTimelineStore)this.store;
        Assertions.assertEquals((Object)defaultVersion, (Object)dbStore.loadVersion());
        Version incompatibleVersion = Version.newInstance((int)(defaultVersion.getMajorVersion() + 1), (int)defaultVersion.getMinorVersion());
        dbStore.storeVersion(incompatibleVersion);
        try {
            this.restartTimelineStore();
            Assertions.fail((String)"Incompatible version, should expect fail here.");
        }
        catch (ServiceStateException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Incompatible version for timeline store"), (String)"Exception message mismatch");
        }
    }

    @Test
    void testValidateConfig() throws IOException {
        YarnConfiguration newConfig;
        YarnConfiguration copyConfig = new YarnConfiguration(this.config);
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.ttl-ms", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.ttl-ms"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.read-cache-size", -1L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.read-cache-size"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size"));
        }
        try {
            newConfig = new YarnConfiguration((Configuration)copyConfig);
            newConfig.setLong("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 0L);
            this.config = newConfig;
            this.restartTimelineStore();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size"));
        }
        this.config = copyConfig;
        this.restartTimelineStore();
    }

    private void restartTimelineStore() throws IOException {
        if (this.store != null) {
            this.store.close();
        }
        this.store = new LeveldbTimelineStore();
        this.store.init(this.config);
        this.store.start();
    }

    @Override
    @Test
    public void testGetDomain() throws IOException {
        super.testGetDomain();
    }

    @Override
    @Test
    public void testGetDomains() throws IOException {
        super.testGetDomains();
    }

    @Test
    void testRelatingToNonExistingEntity() throws IOException {
        TimelineEntity entityToStore = new TimelineEntity();
        entityToStore.setEntityType("TEST_ENTITY_TYPE_1");
        entityToStore.setEntityId("TEST_ENTITY_ID_1");
        entityToStore.setDomainId("DEFAULT");
        entityToStore.addRelatedEntity("TEST_ENTITY_TYPE_2", "TEST_ENTITY_ID_2");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        this.store.put(entities);
        TimelineEntity entityToGet = this.store.getEntity("TEST_ENTITY_ID_2", "TEST_ENTITY_TYPE_2", null);
        Assertions.assertNotNull((Object)entityToGet);
        Assertions.assertEquals((Object)"DEFAULT", (Object)entityToGet.getDomainId());
        Assertions.assertEquals((Object)"TEST_ENTITY_TYPE_1", entityToGet.getRelatedEntities().keySet().iterator().next());
        Assertions.assertEquals((Object)"TEST_ENTITY_ID_1", ((Set)entityToGet.getRelatedEntities().values().iterator().next()).iterator().next());
    }

    @Test
    void testRelatingToOldEntityWithoutDomainId() throws IOException {
        TimelineEntity entityToStore = new TimelineEntity();
        entityToStore.setEntityType("NEW_ENTITY_TYPE_1");
        entityToStore.setEntityId("NEW_ENTITY_ID_1");
        entityToStore.setDomainId("DEFAULT");
        entityToStore.addRelatedEntity("OLD_ENTITY_TYPE_1", "OLD_ENTITY_ID_1");
        TimelineEntities entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        this.store.put(entities);
        TimelineEntity entityToGet = this.store.getEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", null);
        Assertions.assertNotNull((Object)entityToGet);
        Assertions.assertNull((Object)entityToGet.getDomainId());
        Assertions.assertEquals((Object)"NEW_ENTITY_TYPE_1", entityToGet.getRelatedEntities().keySet().iterator().next());
        Assertions.assertEquals((Object)"NEW_ENTITY_ID_1", ((Set)entityToGet.getRelatedEntities().values().iterator().next()).iterator().next());
        entityToStore = new TimelineEntity();
        entityToStore.setEntityType("NEW_ENTITY_TYPE_2");
        entityToStore.setEntityId("NEW_ENTITY_ID_2");
        entityToStore.setDomainId("NON_DEFAULT");
        entityToStore.addRelatedEntity("OLD_ENTITY_TYPE_1", "OLD_ENTITY_ID_1");
        entities = new TimelineEntities();
        entities.addEntity(entityToStore);
        TimelinePutResponse response = this.store.put(entities);
        Assertions.assertEquals((int)1, (int)response.getErrors().size());
        Assertions.assertEquals((int)6, (int)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getErrorCode());
        entityToGet = this.store.getEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", null);
        Assertions.assertNotNull((Object)entityToGet);
        Assertions.assertNull((Object)entityToGet.getDomainId());
        Assertions.assertEquals((int)1, (int)entityToGet.getRelatedEntities().keySet().size());
        Assertions.assertEquals((int)1, (int)((Set)entityToGet.getRelatedEntities().values().iterator().next()).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLevelDbRepair() throws IOException {
        LeveldbTimelineStore store = new LeveldbTimelineStore();
        JniDBFactory factory = (JniDBFactory)Mockito.mock(JniDBFactory.class);
        Mockito.when((Object)factory.open((File)Mockito.any(File.class), (Options)Mockito.any(Options.class))).thenThrow(new Throwable[]{new IOException()}).thenCallRealMethod();
        store.setFactory(factory);
        File path = new File("target", this.getClass().getSimpleName() + "-tmpDir1").getAbsoluteFile();
        Configuration conf = new Configuration(this.config);
        conf.set("yarn.timeline-service.leveldb-timeline-store.path", path.getAbsolutePath());
        try {
            store.init(conf);
            ((JniDBFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).repair((File)Mockito.any(File.class), (Options)Mockito.any(Options.class));
            WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{"*.backup-*"}).get();
            Assertions.assertTrue((path.listFiles((FileFilter)fileFilter).length > 0 ? 1 : 0) != 0);
        }
        finally {
            store.close();
            this.fsContext.delete(new Path(path.getAbsolutePath()), true);
        }
    }
}

