/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.net.URI;
import java.util.EnumSet;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import net.jodah.failsafe.RetryPolicy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.impl.DirectTimelineWriter;
import org.apache.hadoop.yarn.client.api.impl.TimelineClientImpl;
import org.apache.hadoop.yarn.client.api.impl.TimelineWriter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestTimelineWebServicesWithSSL {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestTimelineWebServicesWithSSL.class.getSimpleName();
    private static String keystoresDir;
    private static String sslConfDir;
    private static ApplicationHistoryServer timelineServer;
    private static TimelineStore store;
    private static Configuration conf;

    @BeforeAll
    public static void setupServer() throws Exception {
        conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
        conf.set("yarn.http.policy", "HTTPS_ONLY");
        conf.setFloat("yarn.timeline-service.version", 1.0f);
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestTimelineWebServicesWithSSL.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.addResource("ssl-server.xml");
        conf.addResource("ssl-client.xml");
        timelineServer = new ApplicationHistoryServer();
        timelineServer.init(conf);
        timelineServer.start();
        store = timelineServer.getTimelineStore();
    }

    @AfterAll
    public static void tearDownServer() throws Exception {
        if (timelineServer != null) {
            timelineServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPutEntities() throws Exception {
        TestTimelineClient client = new TestTimelineClient();
        try {
            client.init(conf);
            client.start();
            TimelineEntity expectedEntity = new TimelineEntity();
            expectedEntity.setEntityType("test entity type");
            expectedEntity.setEntityId("test entity id");
            expectedEntity.setDomainId("test domain id");
            TimelineEvent event = new TimelineEvent();
            event.setEventType("test event type");
            event.setTimestamp(0L);
            expectedEntity.addEvent(event);
            TimelinePutResponse response = client.putEntities(new TimelineEntity[]{expectedEntity});
            Assertions.assertEquals((int)0, (int)response.getErrors().size());
            Assertions.assertTrue((boolean)client.resp.toString().contains("https"));
            TimelineEntity actualEntity = store.getEntity(expectedEntity.getEntityId(), expectedEntity.getEntityType(), EnumSet.allOf(TimelineReader.Field.class));
            Assertions.assertNotNull((Object)actualEntity);
            Assertions.assertEquals((Object)expectedEntity.getEntityId(), (Object)actualEntity.getEntityId());
            Assertions.assertEquals((Object)expectedEntity.getEntityType(), (Object)actualEntity.getEntityType());
        }
        finally {
            client.stop();
            client.close();
        }
    }

    private static class TestTimelineClient
    extends TimelineClientImpl {
        private Response resp;

        private TestTimelineClient() {
        }

        protected TimelineWriter createTimelineWriter(Configuration conf, UserGroupInformation authUgi, Client client, URI resURI, RetryPolicy<Object> retryPolicy) {
            return new DirectTimelineWriter(authUgi, client, resURI, retryPolicy){

                public Response doPostingObject(Object obj, String path) throws JsonProcessingException {
                    resp = super.doPostingObject(obj, path);
                    return resp;
                }
            };
        }
    }
}

