/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.inject.Singleton;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.TestContainerLogsUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.TestApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebServices;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.reader.ContainerLogsInfoListReader;
import org.apache.hadoop.yarn.server.timeline.reader.TimelineAboutReader;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.server.webapp.LogServlet;
import org.apache.hadoop.yarn.server.webapp.LogWebServiceUtils;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.assertj.core.api.Assertions;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestAHSWebServices
extends JerseyTestBase {
    private static ApplicationHistoryClientService historyClientService;
    private static AHSWebServices ahsWebservice;
    private static final String[] USERS;
    private static final int MAX_APPS = 6;
    private static Configuration conf;
    private static FileSystem fs;
    private static final String remoteLogRootDir = "target/logs/";
    private static final String rootLogDir = "target/LocalLogs";
    private static final String NM_WEBADDRESS = "test-nm-web-address:9999";
    private static final String NM_ID = "test:1234";
    private static HttpServletRequest request;

    protected Application configure() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new JerseyBinder());
        config.register(AHSWebServices.class);
        config.register(GenericExceptionHandler.class);
        config.register(TestSimpleAuthFilter.class);
        config.register((Object)new JettisonFeature()).register(JAXBContextResolver.class);
        return config;
    }

    public static void setupClass() throws Exception {
        conf = new YarnConfiguration();
        TimelineStore store = TestApplicationHistoryManagerOnTimelineStore.createStore(6);
        TimelineACLsManager aclsManager = new TimelineACLsManager(conf);
        aclsManager.setTimelineStore(store);
        TimelineDataManager dataManager = new TimelineDataManager(store, aclsManager);
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "foo");
        conf.setBoolean("yarn.log-aggregation-enable", true);
        conf.set("yarn.nodemanager.remote-app-log-dir", remoteLogRootDir);
        dataManager.init(conf);
        ApplicationACLsManager appAclsManager = new ApplicationACLsManager(conf);
        ApplicationHistoryManagerOnTimelineStore historyManager = new ApplicationHistoryManagerOnTimelineStore(dataManager, appAclsManager);
        historyManager.init(conf);
        historyClientService = new ApplicationHistoryClientService((ApplicationHistoryManager)historyManager){

            protected void serviceStart() throws Exception {
            }
        };
        historyClientService.init(conf);
        historyClientService.start();
        ahsWebservice = new AHSWebServices((ApplicationBaseProtocol)historyClientService, conf);
        LogServlet logServlet = (LogServlet)Mockito.spy((Object)ahsWebservice.getLogServlet());
        ((LogServlet)Mockito.doReturn(null).when((Object)logServlet)).getNMWebAddressFromRM((String)ArgumentMatchers.any());
        ((LogServlet)Mockito.doReturn((Object)NM_WEBADDRESS).when((Object)logServlet)).getNMWebAddressFromRM(NM_ID);
        ahsWebservice.setLogServlet(logServlet);
        fs = FileSystem.get((Configuration)conf);
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        if (historyClientService != null) {
            historyClientService.stop();
        }
        fs.delete(new Path(remoteLogRootDir), true);
        fs.delete(new Path(rootLogDir), true);
    }

    public static Collection<Object[]> rounds() {
        return Arrays.asList({0}, {1});
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    void testInvalidApp(int round) {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)7);
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        WebServicesTestUtils.assertResponseStatusCode((String)"404 not found expected", (Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    void testInvalidAttempt(int round) {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)7);
        WebTarget r = this.target();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERS[round]);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        if (round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        WebServicesTestUtils.assertResponseStatusCode((String)"404 not found expected", (Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    void testInvalidContainer(int round) throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)7L);
        WebTarget r = this.target();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERS[round]);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").path(containerId.toString()).queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        if (round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        WebServicesTestUtils.assertResponseStatusCode((String)"404 not found expected", (Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    void testInvalidUri(int round) throws JSONException, Exception {
        WebTarget r = this.target();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("applicationhistory").path("bogus").queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(String.class);
            org.junit.jupiter.api.Assertions.fail((String)"should have thrown exception on invalid uri");
        }
        catch (NotFoundException ue) {
            Response response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    public void testInvalidUri2(int round) throws JSONException, Exception {
        WebTarget r = this.target();
        String responseStr = "";
        try {
            responseStr = (String)r.queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(String.class);
            org.junit.jupiter.api.Assertions.fail((String)"should have thrown exception on invalid uri");
        }
        catch (NotFoundException ue) {
            Response response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    public void testInvalidAccept(int round) throws JSONException, Exception {
        WebTarget r = this.target();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("applicationhistory").queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"text/plain"}).get(String.class);
            org.junit.jupiter.api.Assertions.fail((String)"should have thrown exception on invalid uri");
        }
        catch (NotAcceptableException ue) {
            Response response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_ACCEPTABLE, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    public void testAbout(int round) throws Exception {
        WebTarget r = (WebTarget)this.target().register(TimelineAboutReader.class);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("about").queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        TimelineAbout actualAbout = (TimelineAbout)response.readEntity(TimelineAbout.class);
        TimelineAbout expectedAbout = TimelineUtils.createTimelineAbout((String)"Generic History Service API");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)actualAbout, (String)"Timeline service about response is null");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getAbout(), (Object)actualAbout.getAbout());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceVersion(), (Object)actualAbout.getTimelineServiceVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceBuildVersion(), (Object)actualAbout.getTimelineServiceBuildVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceVersionBuiltOn(), (Object)actualAbout.getTimelineServiceVersionBuiltOn());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopVersion(), (Object)actualAbout.getHadoopVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopBuildVersion(), (Object)actualAbout.getHadoopBuildVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopVersionBuiltOn(), (Object)actualAbout.getHadoopVersionBuiltOn());
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    void testAppsQuery(int round) throws Exception {
        WebTarget r = this.targetWithJsonObject();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERS[round]);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").queryParam("state", new Object[]{YarnApplicationState.FINISHED.toString()}).queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject apps = json.getJSONObject("apps");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)apps.length(), (String)"incorrect number of elements");
        JSONArray array = apps.getJSONArray("app");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)array.length(), (String)"incorrect number of elements");
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    public void testQueueQuery(int round) throws Exception {
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").queryParam("queue", new Object[]{"test queue"}).queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        String entity = (String)response.readEntity(String.class);
        JSONObject json = new JSONObject(entity);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject apps = json.getJSONObject("apps");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)apps.length(), (String)"incorrect number of elements");
        JSONArray array = apps.getJSONArray("app");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)array.length(), (String)"incorrect number of elements");
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    void testSingleApp(int round) throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        WebTarget r = this.targetWithJsonObject();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERS[round]);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject app = json.getJSONObject("app");
        org.junit.jupiter.api.Assertions.assertEquals((Object)appId.toString(), (Object)app.getString("appId"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test app", (Object)app.get("name"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)(round == 0 ? "test diagnostics info" : ""), (Object)app.get("diagnosticsInfo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)0x80000000L, (Object)app.get("submittedTime"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test queue", (Object)app.get("queue"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"user1", (Object)app.get("user"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test app type", (Object)app.get("type"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)FinalApplicationStatus.UNDEFINED.toString(), (Object)app.get("finalAppStatus"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)YarnApplicationState.FINISHED.toString(), (Object)app.get("appState"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)app.get("aggregateResourceAllocation"), (String)"Aggregate resource allocation is null");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)app.get("aggregatePreemptedResourceAllocation"), (String)"Aggregate Preempted Resource Allocation is null");
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    void testMultipleAttempts(int round) throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        WebTarget r = this.targetWithJsonObject();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERS[round]);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        if (round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject appAttempts = json.getJSONObject("appAttempts");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)appAttempts.length(), (String)"incorrect number of elements");
        JSONArray array = appAttempts.getJSONArray("appAttempt");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)array.length(), (String)"incorrect number of elements");
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    public void testSingleAttempt(int round) throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        WebTarget r = this.targetWithJsonObject();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERS[round]);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        if (round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject appAttempt = json.getJSONObject("appAttempt");
        org.junit.jupiter.api.Assertions.assertEquals((Object)appAttemptId.toString(), (Object)appAttempt.getString("appAttemptId"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test host", (Object)appAttempt.getString("host"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test diagnostics info", (Object)appAttempt.getString("diagnosticsInfo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test tracking url", (Object)appAttempt.getString("trackingUrl"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)YarnApplicationAttemptState.FINISHED.toString(), (Object)appAttempt.get("appAttemptState"));
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    public void testMultipleContainers(int round) throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        WebTarget r = this.targetWithJsonObject();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERS[round]);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        if (round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject containers = json.getJSONObject("containers");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)containers.length(), (String)"incorrect number of elements");
        JSONArray array = containers.getJSONArray("container");
        org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)array.length(), (String)"incorrect number of elements");
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    void testSingleContainer(int round) throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        WebTarget r = this.targetWithJsonObject();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)USERS[round]);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").path(containerId.toString()).queryParam("user.name", new Object[]{USERS[round]}).request(new String[]{"application/json"}).get(Response.class);
        if (round == 1) {
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
            return;
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json;charset=utf-8", (Object)response.getMediaType().toString());
        JSONObject json = (JSONObject)response.readEntity(JSONObject.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)json.length(), (String)"incorrect number of elements");
        JSONObject container = json.getJSONObject("container");
        org.junit.jupiter.api.Assertions.assertEquals((Object)containerId.toString(), (Object)container.getString("containerId"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test diagnostics info", (Object)container.getString("diagnosticsInfo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-1", (Object)container.getString("allocatedMB"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-1", (Object)container.getString("allocatedVCores"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)NodeId.newInstance((String)"test host", (int)100).toString(), (Object)container.getString("assignedNodeId"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-1", (Object)container.getString("priority"));
        YarnConfiguration conf = new YarnConfiguration();
        org.junit.jupiter.api.Assertions.assertEquals((Object)(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf) + "/applicationhistory/logs/test host:100/container_0_0001_01_000001/container_0_0001_01_000001/user1"), (Object)container.getString("logUrl"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ContainerState.COMPLETE.toString(), (Object)container.getString("containerState"));
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    @Timeout(value=10000L)
    void testContainerLogsForFinishedApps(int round) throws Exception {
        String fileName = "syslog";
        String user = "user1";
        NodeId nodeId = NodeId.newInstance((String)"test host", (int)100);
        NodeId nodeId2 = NodeId.newInstance((String)"host2", (int)1234);
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerId containerId100 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)100L);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ApplicationId)appId, Collections.singletonMap(containerId1, "Hello." + containerId1), (NodeId)nodeId, (String)fileName, (String)user, (boolean)true);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ApplicationId)appId, Collections.singletonMap(containerId100, "Hello." + containerId100), (NodeId)nodeId2, (String)fileName, (String)user, (boolean)false);
        WebTarget r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1.toString()).path(fileName).queryParam("user.name", new Object[]{user}).request(new String[]{"text/plain"}).get(Response.class);
        String responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains("Hello." + containerId1));
        r = this.target();
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").path(fileName).queryParam("user.name", new Object[]{user}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains("Hello." + containerId1));
        r = this.target();
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId100.toString()).path(fileName).queryParam("user.name", new Object[]{user}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains("Hello." + containerId100));
        r = this.target();
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId100.toString()).path("logs").path(fileName).queryParam("user.name", new Object[]{user}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains("Hello." + containerId100));
        ApplicationId appId100 = ApplicationId.newInstance((long)0L, (int)100);
        ApplicationAttemptId appAttemptId100 = ApplicationAttemptId.newInstance((ApplicationId)appId100, (int)1);
        ContainerId containerId1ForApp100 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId100, (long)1L);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ApplicationId)appId100, Collections.singletonMap(containerId1ForApp100, "Hello." + containerId1ForApp100), (NodeId)nodeId, (String)fileName, (String)user, (boolean)true);
        r = this.target();
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", new Object[]{user}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains("Hello." + containerId1ForApp100));
        int fullTextSize = responseText.getBytes().length;
        String tailEndSeparator = StringUtils.repeat((String)"*", (int)("End of LogType:syslog".length() + 50)) + "\n\n";
        int tailTextSize = "\nEnd of LogType:syslog\n".getBytes().length + tailEndSeparator.getBytes().length;
        String logMessage = "Hello." + containerId1ForApp100;
        int fileContentSize = logMessage.getBytes().length;
        r = this.target();
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", new Object[]{user}).queryParam("size", new Object[]{"5"}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)responseText.getBytes().length, (int)(fullTextSize - fileContentSize + 5));
        org.junit.jupiter.api.Assertions.assertTrue((fullTextSize >= responseText.getBytes().length ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new String(responseText.getBytes(), fullTextSize - fileContentSize - tailTextSize, 5), (Object)new String(logMessage.getBytes(), 0, 5));
        r = this.target();
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", new Object[]{user}).queryParam("size", new Object[]{"-5"}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)responseText.getBytes().length, (int)(fullTextSize - fileContentSize + 5));
        org.junit.jupiter.api.Assertions.assertTrue((fullTextSize >= responseText.getBytes().length ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new String(responseText.getBytes(), fullTextSize - fileContentSize - tailTextSize, 5), (Object)new String(logMessage.getBytes(), fileContentSize - 5, 5));
        r = this.target();
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", new Object[]{user}).queryParam("size", new Object[]{"10000"}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        Assertions.assertThat((byte[])responseText.getBytes()).hasSize(fullTextSize);
        r = this.target();
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1ForApp100.toString()).path(fileName).queryParam("user.name", new Object[]{user}).queryParam("size", new Object[]{"-10000"}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        Assertions.assertThat((byte[])responseText.getBytes()).hasSize(fullTextSize);
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    @Timeout(value=10000L)
    public void testContainerLogsForRunningApps(int round) throws Exception {
        String fileName = "syslog";
        String user = "user1";
        ApplicationId appId = ApplicationId.newInstance((long)1234L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        WebTarget r = this.target();
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        URI requestURI = r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1.toString()).path(fileName).queryParam("user.name", new Object[]{user}).getUri();
        String redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        org.junit.jupiter.api.Assertions.assertTrue((redirectURL != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(NM_ID));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("/logs/" + fileName));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("user.name=" + user));
        requestURI = r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1.toString()).path(fileName).queryParam("user.name", new Object[]{user}).queryParam("nm.id", new Object[]{NM_ID}).getUri();
        redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        org.junit.jupiter.api.Assertions.assertTrue((redirectURL != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(NM_WEBADDRESS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("/logs/" + fileName));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("user.name=" + user));
        requestURI = r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").path(fileName).queryParam("user.name", new Object[]{user}).getUri();
        redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        org.junit.jupiter.api.Assertions.assertTrue((redirectURL != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(NM_ID));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("/logs/" + fileName));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("user.name=" + user));
        requestURI = r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").path(fileName).queryParam("user.name", new Object[]{user}).queryParam("nm.id", new Object[]{NM_ID}).getUri();
        redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        org.junit.jupiter.api.Assertions.assertTrue((redirectURL != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(NM_WEBADDRESS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("/logs/" + fileName));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("user.name=" + user));
        ContainerId containerId1000 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1000L);
        String content = "Hello." + containerId1000;
        NodeId nodeId = NodeId.newInstance((String)"test host", (int)100);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ApplicationId)appId, Collections.singletonMap(containerId1000, content), (NodeId)nodeId, (String)fileName, (String)user, (boolean)true);
        r = this.target();
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1000.toString()).path(fileName).queryParam("user.name", new Object[]{user}).request(new String[]{"text/plain"}).get(Response.class);
        String responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains(content));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains("LogAggregationType: " + ContainerLogAggregationType.LOCAL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains(LogWebServiceUtils.getNoRedirectWarning()));
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containerlogs").path(containerId1000.toString()).path(fileName).queryParam("nm.id", new Object[]{"invalid-nm:1234"}).queryParam("user.name", new Object[]{user}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains(content));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains("LogAggregationType: " + ContainerLogAggregationType.LOCAL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains(LogWebServiceUtils.getNoRedirectWarning()));
        String content1 = "Hello." + containerId1;
        NodeId nodeId1 = NodeId.fromString((String)NM_ID);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ApplicationId)appId, Collections.singletonMap(containerId1, content1), (NodeId)nodeId1, (String)fileName, (String)user, (boolean)true);
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").path(fileName).queryParam("user.name", new Object[]{user}).queryParam("redirected_from_node", new Object[]{"true"}).request(new String[]{"text/plain"}).get(Response.class);
        responseText = (String)response.readEntity(String.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains(content1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)responseText.contains("LogAggregationType: " + ContainerLogAggregationType.AGGREGATED));
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    @Timeout(value=10000L)
    public void testContainerLogsMetaForRunningApps(int round) throws Exception {
        List logMeta;
        String user = "user1";
        ApplicationId appId = ApplicationId.newInstance((long)1234L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        WebTarget r = (WebTarget)this.target().register(ContainerLogsInfoListReader.class);
        URI requestURI = r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").queryParam("user.name", new Object[]{user}).queryParam("nm.id", new Object[]{NM_ID}).getUri();
        String redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        org.junit.jupiter.api.Assertions.assertTrue((redirectURL != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(NM_WEBADDRESS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("/logs"));
        requestURI = r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").queryParam("user.name", new Object[]{user}).getUri();
        redirectURL = TestAHSWebServices.getRedirectURL(requestURI.toString());
        org.junit.jupiter.api.Assertions.assertTrue((redirectURL != null ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(NM_ID));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("ws/v1/node/containers"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains(containerId1.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)redirectURL.contains("/logs"));
        ContainerId containerId1000 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1000L);
        String fileName = "syslog";
        String content = "Hello." + containerId1000;
        NodeId nodeId = NodeId.newInstance((String)"test host", (int)100);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ApplicationId)appId, Collections.singletonMap(containerId1000, content), (NodeId)nodeId, (String)fileName, (String)user, (boolean)true);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1000.toString()).path("logs").queryParam("user.name", new Object[]{user}).request(new String[]{"application/json"}).get(Response.class);
        List responseText = (List)response.readEntity((GenericType)new GenericType<List<ContainerLogsInfo>>(){});
        org.junit.jupiter.api.Assertions.assertTrue((responseText.size() == 2 ? 1 : 0) != 0);
        for (ContainerLogsInfo logInfo : responseText) {
            if (logInfo.getLogType().equals(ContainerLogAggregationType.AGGREGATED.toString())) {
                logMeta = logInfo.getContainerLogsInfo();
                org.junit.jupiter.api.Assertions.assertTrue((logMeta.size() == 1 ? 1 : 0) != 0);
                Assertions.assertThat((String)((ContainerLogFileInfo)logMeta.get(0)).getFileName()).isEqualTo((Object)fileName);
                Assertions.assertThat((String)((ContainerLogFileInfo)logMeta.get(0)).getFileSize()).isEqualTo((Object)String.valueOf(content.length()));
                continue;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)logInfo.getLogType(), (Object)ContainerLogAggregationType.LOCAL.toString());
        }
        response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1000.toString()).path("logs").queryParam("nm.id", new Object[]{"invalid-nm:1234"}).queryParam("user.name", new Object[]{user}).request(new String[]{"application/json"}).get(Response.class);
        responseText = (List)response.readEntity((GenericType)new GenericType<List<ContainerLogsInfo>>(){});
        org.junit.jupiter.api.Assertions.assertTrue((responseText.size() == 2 ? 1 : 0) != 0);
        for (ContainerLogsInfo logInfo : responseText) {
            if (logInfo.getLogType().equals(ContainerLogAggregationType.AGGREGATED.toString())) {
                logMeta = logInfo.getContainerLogsInfo();
                org.junit.jupiter.api.Assertions.assertTrue((logMeta.size() == 1 ? 1 : 0) != 0);
                Assertions.assertThat((String)((ContainerLogFileInfo)logMeta.get(0)).getFileName()).isEqualTo((Object)fileName);
                Assertions.assertThat((String)((ContainerLogFileInfo)logMeta.get(0)).getFileSize()).isEqualTo((Object)String.valueOf(content.length()));
                continue;
            }
            Assertions.assertThat((String)logInfo.getLogType()).isEqualTo((Object)ContainerLogAggregationType.LOCAL.toString());
        }
    }

    @MethodSource(value={"rounds"})
    @ParameterizedTest
    @Timeout(value=10000L)
    void testContainerLogsMetaForFinishedApps(int round) throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        String fileName = "syslog";
        String user = "user1";
        String content = "Hello." + containerId1;
        NodeId nodeId = NodeId.newInstance((String)"test host", (int)100);
        TestContainerLogsUtils.createContainerLogFileInRemoteFS((Configuration)conf, (FileSystem)fs, (String)rootLogDir, (ApplicationId)appId, Collections.singletonMap(containerId1, content), (NodeId)nodeId, (String)fileName, (String)user, (boolean)true);
        WebTarget r = (WebTarget)this.target().register(ContainerLogsInfoListReader.class);
        Response response = (Response)r.path("ws").path("v1").path("applicationhistory").path("containers").path(containerId1.toString()).path("logs").queryParam("user.name", new Object[]{user}).request(new String[]{"application/json"}).get(Response.class);
        List responseText = (List)response.readEntity((GenericType)new GenericType<List<ContainerLogsInfo>>(){});
        org.junit.jupiter.api.Assertions.assertTrue((responseText.size() == 1 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)((ContainerLogsInfo)responseText.get(0)).getLogType(), (Object)ContainerLogAggregationType.AGGREGATED.toString());
        List logMeta = ((ContainerLogsInfo)responseText.get(0)).getContainerLogsInfo();
        org.junit.jupiter.api.Assertions.assertTrue((logMeta.size() == 1 ? 1 : 0) != 0);
        Assertions.assertThat((String)((ContainerLogFileInfo)logMeta.get(0)).getFileName()).isEqualTo((Object)fileName);
        Assertions.assertThat((String)((ContainerLogFileInfo)logMeta.get(0)).getFileSize()).isEqualTo((Object)String.valueOf(content.length()));
    }

    private static String getRedirectURL(String url) {
        String redirectUrl = null;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setInstanceFollowRedirects(false);
            if (conn.getResponseCode() == 307) {
                redirectUrl = conn.getHeaderField("Location");
                String queryParams = TestAHSWebServices.getQueryParams(url);
                if (queryParams != null && !queryParams.isEmpty()) {
                    redirectUrl = TestAHSWebServices.appendQueryParams(redirectUrl, queryParams);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return redirectUrl;
    }

    private static String getQueryParams(String url) {
        try {
            URL u = new URL(url);
            String query = u.getQuery();
            return query != null ? query : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String appendQueryParams(String url, String queryParams) {
        if (url == null || queryParams == null || queryParams.isEmpty()) {
            return url;
        }
        return url + (url.contains("?") ? "&" : "?") + queryParams;
    }

    static {
        USERS = new String[]{"foo", "bar"};
    }

    private static class JerseyBinder
    extends AbstractBinder {
        private JerseyBinder() {
        }

        protected void configure() {
            try {
                TestAHSWebServices.setupClass();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ((InstanceBinding)this.bind(conf).to(Configuration.class)).named("conf");
            ((InstanceBinding)this.bind(historyClientService).to(ApplicationBaseProtocol.class)).named("appBaseProt");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.bind(response).to(HttpServletResponse.class);
            this.bind(request).to(HttpServletRequest.class);
            this.bind(ahsWebservice).to(AHSWebServices.class);
        }
    }

    @Singleton
    public static class TestSimpleAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties properties = super.getConfiguration(configPrefix, filterConfig);
            properties.put("type", "simple");
            properties.put("simple.anonymous.allowed", "false");
            return properties;
        }
    }
}

