/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimelineACLsManager {
    private static TimelineDomain domain = new TimelineDomain();

    @Test
    void testYarnACLsNotEnabledForEntity() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", false);
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        timelineACLsManager.setTimelineStore((TimelineStore)new TestTimelineStore());
        TimelineEntity entity = new TimelineEntity();
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"owner");
        entity.setDomainId("domain_id_1");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"user"), ApplicationAccessType.VIEW_APP, entity), (String)"Always true when ACLs are not enabled");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"user"), ApplicationAccessType.MODIFY_APP, entity), (String)"Always true when ACLs are not enabled");
    }

    @Test
    void testYarnACLsEnabledForEntity() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "admin");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        timelineACLsManager.setTimelineStore((TimelineStore)new TestTimelineStore());
        TimelineEntity entity = new TimelineEntity();
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"owner");
        entity.setDomainId("domain_id_1");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), ApplicationAccessType.VIEW_APP, entity), (String)"Owner should be allowed to view");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"reader"), ApplicationAccessType.VIEW_APP, entity), (String)"Reader should be allowed to view");
        Assertions.assertFalse((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"other"), ApplicationAccessType.VIEW_APP, entity), (String)"Other shouldn't be allowed to view");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"admin"), ApplicationAccessType.VIEW_APP, entity), (String)"Admin should be allowed to view");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), ApplicationAccessType.MODIFY_APP, entity), (String)"Owner should be allowed to modify");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"writer"), ApplicationAccessType.MODIFY_APP, entity), (String)"Writer should be allowed to modify");
        Assertions.assertFalse((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"other"), ApplicationAccessType.MODIFY_APP, entity), (String)"Other shouldn't be allowed to modify");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"admin"), ApplicationAccessType.MODIFY_APP, entity), (String)"Admin should be allowed to modify");
    }

    @Test
    void testCorruptedOwnerInfoForEntity() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "owner");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        timelineACLsManager.setTimelineStore((TimelineStore)new TestTimelineStore());
        TimelineEntity entity = new TimelineEntity();
        try {
            timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), ApplicationAccessType.VIEW_APP, entity);
            Assertions.fail((String)"Exception is expected");
        }
        catch (YarnException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("doesn't exist."), (String)"It's not the exact expected exception");
        }
    }

    @Test
    void testYarnACLsNotEnabledForDomain() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", false);
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineDomain domain = new TimelineDomain();
        domain.setOwner("owner");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"user"), domain), (String)"Always true when ACLs are not enabled");
    }

    @Test
    void testYarnACLsEnabledForDomain() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "admin");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineDomain domain = new TimelineDomain();
        domain.setOwner("owner");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), domain), (String)"Owner should be allowed to access");
        Assertions.assertFalse((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"other"), domain), (String)"Other shouldn't be allowed to access");
        Assertions.assertTrue((boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"admin"), domain), (String)"Admin should be allowed to access");
    }

    @Test
    void testCorruptedOwnerInfoForDomain() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "owner");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineDomain domain = new TimelineDomain();
        try {
            timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), domain);
            Assertions.fail((String)"Exception is expected");
        }
        catch (YarnException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("is corrupted."), (String)"It's not the exact expected exception");
        }
    }

    static {
        domain.setId("domain_id_1");
        domain.setOwner("owner");
        domain.setReaders("reader");
        domain.setWriters("writer");
    }

    private static class TestTimelineStore
    extends MemoryTimelineStore {
        private TestTimelineStore() {
        }

        public TimelineDomain getDomain(String domainId) throws IOException {
            if (domainId == null) {
                return null;
            }
            return domain;
        }
    }
}

