/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AdminACLsManager;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.ContextFactory;
import org.apache.hadoop.yarn.server.timeline.TestMemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;
import org.apache.hadoop.yarn.server.timeline.webapp.TimelineWebServices;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestTimelineWebServices
extends JerseyTestBase {
    private static TimelineStore store;
    private static TimelineACLsManager timelineACLsManager;
    private static AdminACLsManager adminACLsManager;
    private static long beforeTime;

    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    private static TimelineStore mockTimelineStore() throws Exception {
        beforeTime = System.currentTimeMillis() - 1L;
        TestMemoryTimelineStore store = new TestMemoryTimelineStore();
        store.setup();
        return store.getTimelineStore();
    }

    public TestTimelineWebServices() {
        super(((WebAppDescriptor.Builder)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.applicationhistoryservice.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").clientConfig((ClientConfig)new DefaultClientConfig(new Class[]{YarnJacksonJaxbJsonProvider.class}))).build());
    }

    @Test
    void testAbout() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelineAbout actualAbout = (TimelineAbout)response.getEntity(TimelineAbout.class);
        TimelineAbout expectedAbout = TimelineUtils.createTimelineAbout((String)"Timeline API");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)actualAbout, (String)"Timeline service about response is null");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getAbout(), (Object)actualAbout.getAbout());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceVersion(), (Object)actualAbout.getTimelineServiceVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceBuildVersion(), (Object)actualAbout.getTimelineServiceBuildVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getTimelineServiceVersionBuiltOn(), (Object)actualAbout.getTimelineServiceVersionBuiltOn());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopVersion(), (Object)actualAbout.getHadoopVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopBuildVersion(), (Object)actualAbout.getHadoopBuildVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedAbout.getHadoopVersionBuiltOn(), (Object)actualAbout.getHadoopVersionBuiltOn());
    }

    private static void verifyEntities(TimelineEntities entities) {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entities);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)entities.getEntities().size());
        TimelineEntity entity1 = (TimelineEntity)entities.getEntities().get(0);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_1", (Object)entity1.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity1.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity1.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)entity1.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity1.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity1.getOtherInfo().size());
        TimelineEntity entity2 = (TimelineEntity)entities.getEntities().get(1);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_2", (Object)entity2.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity2.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity2.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)entity2.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity2.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity2.getOtherInfo().size());
        TimelineEntity entity3 = (TimelineEntity)entities.getEntities().get(2);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_6", (Object)entity3.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity3.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)61L, (long)entity3.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)entity3.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity3.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity3.getOtherInfo().size());
    }

    @Test
    void testGetEntities() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    void testFromId() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", "id_2").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", "id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    void testFromTs() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", Long.toString(beforeTime)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", Long.toString(System.currentTimeMillis())).accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    void testPrimaryFilterString() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "user:username").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    void testPrimaryFilterInteger() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "appname:" + Integer.toString(Integer.MAX_VALUE)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    void testPrimaryFilterLong() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "long:" + Long.toString(0x80000000L)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    void testSecondaryFilters() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("secondaryFilter", "user:username,appname:" + Integer.toString(Integer.MAX_VALUE)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TestTimelineWebServices.verifyEntities((TimelineEntities)response.getEntity(TimelineEntities.class));
    }

    @Test
    void testGetEntity() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)entity.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity.getOtherInfo().size());
    }

    @Test
    void testGetEntityFields1() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", "events,otherinfo").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)entity.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)entity.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity.getOtherInfo().size());
    }

    @Test
    void testGetEntityFields2() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", "lasteventonly,primaryfilters,relatedentities").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"id_1", (Object)entity.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"type_1", (Object)entity.getEntityType());
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)entity.getStartTime());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)entity.getEvents().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)entity.getPrimaryFilters().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)entity.getOtherInfo().size());
    }

    @Test
    void testGetEvents() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("events").queryParam("entityId", "id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelineEvents events = (TimelineEvents)response.getEntity(TimelineEvents.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)events);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.getAllEvents().size());
        TimelineEvents.EventsOfOneEntity partEvents = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)partEvents.getEvents().size());
        TimelineEvent event1 = (TimelineEvent)partEvents.getEvents().get(0);
        org.junit.jupiter.api.Assertions.assertEquals((long)456L, (long)event1.getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"end_event", (Object)event1.getEventType());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)event1.getEventInfo().size());
        TimelineEvent event2 = (TimelineEvent)partEvents.getEvents().get(1);
        org.junit.jupiter.api.Assertions.assertEquals((long)123L, (long)event2.getTimestamp());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"start_event", (Object)event2.getEventType());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)event2.getEventInfo().size());
    }

    @Test
    void testPostEntitiesWithPrimaryFilter() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        HashMap filters = new HashMap();
        filters.put(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), new HashSet());
        entity.setPrimaryFilters(filters);
        entity.setEntityId("test id 6");
        entity.setEntityType("test type 6");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entities.addEntity(entity);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResposne.getErrors().size());
    }

    @Test
    void testPostEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId("test id 1");
        entity.setEntityType("test type 1");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entity.setDomainId("domain_id_1");
        entities.addEntity(entity);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)putResposne);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResposne.getErrors().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 1").path("test id 1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 1", (Object)entity.getEntityId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test type 1", (Object)entity.getEntityType());
    }

    @Test
    void testPostIncompleteEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity1 = new TimelineEntity();
        entity1.setEntityId("test id 1");
        entity1.setEntityType("test type 1");
        entity1.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entity1.setDomainId("domain_id_1");
        entities.addEntity(entity1);
        entities.addEntity(new TimelineEntity());
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.BAD_REQUEST, (Response.StatusType)response.getStatusInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPostEntitiesWithYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 2");
            entity.setEntityType("test type 2");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)putResponse);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_3").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)putResponse);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)putResponse.getErrors().size());
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)((TimelinePutResponse.TimelinePutError)putResponse.getErrors().get(0)).getErrorCode());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 3");
            entity.setEntityType("test type 2");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            entity.setRelatedEntities(Collections.singletonMap("test type 2", Collections.singleton("test id 2")));
            entities.addEntity(entity);
            r = this.resource();
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_3").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)putResponse);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)putResponse.getErrors().size());
            org.junit.jupiter.api.Assertions.assertEquals((int)6, (int)((TimelinePutResponse.TimelinePutError)putResponse.getErrors().get(0)).getErrorCode());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 2").path("test id 3").queryParam("user.name", "reader_user_3").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 3", (Object)entity.getEntityId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test type 2", (Object)entity.getEntityType());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPostEntitiesToDefaultDomain() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 7");
            entity.setEntityType("test type 7");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "anybody_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)putResposne);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResposne.getErrors().size());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 7").path("test id 7").queryParam("user.name", "any_body_2").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)entity);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 7", (Object)entity.getEntityId());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test type 7", (Object)entity.getEntityType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"DEFAULT", (Object)entity.getDomainId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntityWithYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 3");
            entity.setEntityType("test type 3");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("user.name", "reader_user_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("fields", "relatedentities").queryParam("user.name", "reader_user_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("fields", "primaryfilters").queryParam("user.name", "reader_user_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
            org.junit.jupiter.api.Assertions.assertNull(entity.getPrimaryFilters().get(TimelineStore.SystemFilter.ENTITY_OWNER.toString()));
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 3").path("test id 3").queryParam("user.name", "reader_user_2").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEntitiesWithYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 4");
            entity.setEntityType("test type 4");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 5");
            entity.setEntityType("test type 4");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            entities.addEntity(entity);
            r = this.resource();
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_3").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").queryParam("user.name", "reader_user_1").path("test type 4").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            entities = (TimelineEntities)response.getEntity(TimelineEntities.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)entities.getEntities().size());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test type 4", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityType());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 4", (Object)((TimelineEntity)entities.getEntities().get(0)).getEntityId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetEventsWithYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineEntities entities = new TimelineEntities();
            TimelineEntity entity = new TimelineEntity();
            entity.setEntityId("test id 5");
            entity.setEntityType("test type 5");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_1");
            TimelineEvent event = new TimelineEvent();
            event.setEventType("event type 1");
            event.setTimestamp(System.currentTimeMillis());
            entity.addEvent(event);
            entities.addEntity(entity);
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_1").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            TimelinePutResponse putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            entities = new TimelineEntities();
            entity = new TimelineEntity();
            entity.setEntityId("test id 6");
            entity.setEntityType("test type 5");
            entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
            entity.setDomainId("domain_id_2");
            event = new TimelineEvent();
            event.setEventType("event type 2");
            event.setTimestamp(System.currentTimeMillis());
            entity.addEvent(event);
            entities.addEntity(entity);
            r = this.resource();
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").queryParam("user.name", "writer_user_3").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            putResponse = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)putResponse.getErrors().size());
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type 5").path("events").queryParam("user.name", "reader_user_1").queryParam("entityId", "test id 5,test id 6").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            TimelineEvents events = (TimelineEvents)response.getEntity(TimelineEvents.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.getAllEvents().size());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"test id 5", (Object)((TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0)).getEntityId());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    void testGetDomain() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelineDomain domain = (TimelineDomain)response.getEntity(TimelineDomain.class);
        TestTimelineWebServices.verifyDomain(domain, "domain_id_1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetDomainYarnACLsEnabled() {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").queryParam("user.name", "owner_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            TimelineDomain domain = (TimelineDomain)response.getEntity(TimelineDomain.class);
            TestTimelineWebServices.verifyDomain(domain, "domain_id_1");
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("domain_id_1").queryParam("user.name", "tester").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    void testGetDomains() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").queryParam("owner", "owner_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        TimelineDomains domains = (TimelineDomains)response.getEntity(TimelineDomains.class);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)domains.getDomains().size());
        for (int i = 0; i < domains.getDomains().size(); ++i) {
            TestTimelineWebServices.verifyDomain((TimelineDomain)domains.getDomains().get(i), i == 0 ? "domain_id_4" : "domain_id_1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetDomainsYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "owner_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            TimelineDomains domains = (TimelineDomains)response.getEntity(TimelineDomains.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)domains.getDomains().size());
            for (int i = 0; i < domains.getDomains().size(); ++i) {
                TestTimelineWebServices.verifyDomain((TimelineDomain)domains.getDomains().get(i), i == 0 ? "domain_id_4" : "domain_id_1");
            }
            response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").queryParam("owner", "owner_1").queryParam("user.name", "tester").accept(new String[]{"application/json"}).get(ClientResponse.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
            domains = (TimelineDomains)response.getEntity(TimelineDomains.class);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)domains.getDomains().size());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    void testPutDomain() throws Exception {
        TimelineDomain domain = new TimelineDomain();
        domain.setId("test_domain_id");
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("test_domain_id").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        domain = (TimelineDomain)response.getEntity(TimelineDomain.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test_domain_id", (Object)domain.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"tester", (Object)domain.getOwner());
        org.junit.jupiter.api.Assertions.assertNull((Object)domain.getDescription());
        domain.setDescription("test_description");
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
        WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("domain").path("test_domain_id").accept(new String[]{"application/json"}).get(ClientResponse.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        domain = (TimelineDomain)response.getEntity(TimelineDomain.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test_domain_id", (Object)domain.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test_description", (Object)domain.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPutDomainYarnACLsEnabled() throws Exception {
        AdminACLsManager oldAdminACLsManager = timelineACLsManager.setAdminACLsManager(adminACLsManager);
        try {
            TimelineDomain domain = new TimelineDomain();
            domain.setId("test_domain_id_acl");
            WebResource r = this.resource();
            ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "tester").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.OK, (Response.StatusType)response.getStatusInfo());
            response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").path("domain").queryParam("user.name", "other").accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, (Object)domain);
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)Response.Status.FORBIDDEN, (Response.StatusType)response.getStatusInfo());
        }
        finally {
            timelineACLsManager.setAdminACLsManager(oldAdminACLsManager);
        }
    }

    @Test
    void testContextFactory() throws Exception {
        JAXBContext jaxbContext1 = ContextFactory.createContext((Class[])new Class[]{TimelineDomain.class}, (Map)Collections.EMPTY_MAP);
        JAXBContext jaxbContext2 = ContextFactory.createContext((Class[])new Class[]{TimelineDomain.class}, (Map)Collections.EMPTY_MAP);
        org.junit.jupiter.api.Assertions.assertEquals((Object)jaxbContext1, (Object)jaxbContext2);
        try {
            ContextFactory.createContext((Class[])new Class[]{TimelineEntity.class}, (Map)Collections.EMPTY_MAP);
            org.junit.jupiter.api.Assertions.fail((String)"Expected JAXBException");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isExactlyInstanceOf(JAXBException.class);
        }
    }

    private static void verifyDomain(TimelineDomain domain, String domainId) {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain);
        org.junit.jupiter.api.Assertions.assertEquals((Object)domainId, (Object)domain.getId());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getDescription());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getOwner());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getReaders());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getWriters());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getCreatedTime());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)domain.getModifiedTime());
    }

    static {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            this.bind(YarnJacksonJaxbJsonProvider.class);
            this.bind(TimelineWebServices.class);
            this.bind(GenericExceptionHandler.class);
            try {
                store = TestTimelineWebServices.mockTimelineStore();
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.fail();
            }
            YarnConfiguration conf = new YarnConfiguration();
            conf.setBoolean("yarn.acl.enable", false);
            timelineACLsManager = new TimelineACLsManager((Configuration)conf);
            timelineACLsManager.setTimelineStore(store);
            conf.setBoolean("yarn.acl.enable", true);
            conf.set("yarn.admin.acl", "admin");
            adminACLsManager = new AdminACLsManager((Configuration)conf);
            TimelineDataManager timelineDataManager = new TimelineDataManager(store, timelineACLsManager);
            timelineDataManager.init((Configuration)conf);
            timelineDataManager.start();
            this.bind(TimelineDataManager.class).toInstance((Object)timelineDataManager);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
            TimelineAuthenticationFilter taFilter = new TimelineAuthenticationFilter();
            FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)filterConfig.getInitParameter("config.prefix")).thenReturn(null);
            Mockito.when((Object)filterConfig.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)filterConfig.getInitParameter("simple.anonymous.allowed")).thenReturn((Object)"true");
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)filterConfig.getServletContext()).thenReturn((Object)context);
            Enumeration names = (Enumeration)Mockito.mock(Enumeration.class);
            Mockito.when((Object)names.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
            Mockito.when(names.nextElement()).thenReturn((Object)"type", (Object[])new String[]{"simple.anonymous.allowed", "delegation-token.token-kind"});
            Mockito.when((Object)filterConfig.getInitParameterNames()).thenReturn((Object)names);
            Mockito.when((Object)filterConfig.getInitParameter("delegation-token.token-kind")).thenReturn((Object)TimelineDelegationTokenIdentifier.KIND_NAME.toString());
            try {
                taFilter.init(filterConfig);
            }
            catch (ServletException e) {
                org.junit.jupiter.api.Assertions.fail((String)("Unable to initialize TimelineAuthenticationFilter: " + e.getMessage()));
            }
            taFilter = (TimelineAuthenticationFilter)Mockito.spy((Object)taFilter);
            try {
                ((TimelineAuthenticationFilter)Mockito.doNothing().when((Object)taFilter)).init((FilterConfig)ArgumentMatchers.any(FilterConfig.class));
            }
            catch (ServletException e) {
                org.junit.jupiter.api.Assertions.fail((String)("Unable to initialize TimelineAuthenticationFilter: " + e.getMessage()));
            }
            this.filter("/*", new String[0]).through((Filter)taFilter);
        }
    }
}

