/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.junit.jupiter.api.Assertions;

public class TimelineStoreTestUtils {
    protected static final List<TimelineEvent> EMPTY_EVENTS = Collections.emptyList();
    protected static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    protected static final Map<String, Set<Object>> EMPTY_PRIMARY_FILTERS = Collections.emptyMap();
    protected static final Map<String, Set<String>> EMPTY_REL_ENTITIES = Collections.emptyMap();
    protected TimelineStore store;
    protected String entityId1;
    protected String entityType1;
    protected String entityId1b;
    protected String entityId2;
    protected String entityType2;
    protected String entityId4;
    protected String entityType4;
    protected String entityId5;
    protected String entityType5;
    protected String entityId6;
    protected String entityId7;
    protected String entityType7;
    protected Map<String, Set<Object>> primaryFilters;
    protected Map<String, Object> secondaryFilters;
    protected Map<String, Object> allFilters;
    protected Map<String, Object> otherInfo;
    protected Map<String, Set<String>> relEntityMap;
    protected Map<String, Set<String>> relEntityMap2;
    protected NameValuePair userFilter;
    protected NameValuePair numericFilter1;
    protected NameValuePair numericFilter2;
    protected NameValuePair numericFilter3;
    protected Collection<NameValuePair> goodTestingFilters;
    protected Collection<NameValuePair> badTestingFilters;
    protected TimelineEvent ev1;
    protected TimelineEvent ev2;
    protected TimelineEvent ev3;
    protected TimelineEvent ev4;
    protected Map<String, Object> eventInfo;
    protected List<TimelineEvent> events1;
    protected List<TimelineEvent> events2;
    protected long beforeTs;
    protected String domainId1;
    protected String domainId2;
    private TimelineDomain domain1;
    private TimelineDomain domain2;
    private TimelineDomain domain3;
    private long elapsedTime;

    protected void loadTestEntityData() throws IOException {
        this.beforeTs = System.currentTimeMillis() - 1L;
        TimelineEntities entities = new TimelineEntities();
        HashMap<String, Set<Object>> primaryFilters = new HashMap<String, Set<Object>>();
        HashSet<String> l1 = new HashSet<String>();
        l1.add("username");
        HashSet<Integer> l2 = new HashSet<Integer>();
        l2.add(Integer.MAX_VALUE);
        HashSet<String> l3 = new HashSet<String>();
        l3.add("123abc");
        HashSet<Long> l4 = new HashSet<Long>();
        l4.add(0x80000000L);
        primaryFilters.put("user", l1);
        primaryFilters.put("appname", l2);
        primaryFilters.put("other", l3);
        primaryFilters.put("long", l4);
        HashMap<String, Object> secondaryFilters = new HashMap<String, Object>();
        secondaryFilters.put("startTime", 123456);
        secondaryFilters.put("status", "RUNNING");
        HashMap<String, Object> otherInfo1 = new HashMap<String, Object>();
        otherInfo1.put("info1", "val1");
        otherInfo1.putAll(secondaryFilters);
        String entityId1 = "id_1";
        String entityType1 = "type_1";
        String entityId1b = "id_2";
        String entityId2 = "id_2";
        String entityType2 = "type_2";
        String entityId4 = "id_4";
        String entityType4 = "type_4";
        String entityId5 = "id_5";
        String entityType5 = "type_5";
        String entityId6 = "id_6";
        String entityId7 = "id_7";
        String entityType7 = "type_7";
        HashMap<String, Set<String>> relatedEntities = new HashMap<String, Set<String>>();
        relatedEntities.put(entityType2, Collections.singleton(entityId2));
        TimelineEvent ev3 = TimelineStoreTestUtils.createEvent(789L, "launch_event", null);
        TimelineEvent ev4 = TimelineStoreTestUtils.createEvent(0L, "init_event", null);
        ArrayList<TimelineEvent> events = new ArrayList<TimelineEvent>();
        events.add(ev3);
        events.add(ev4);
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity(entityId2, entityType2, null, events, null, null, null, "domain_id_1")));
        TimelinePutResponse response = this.store.put(entities);
        Assertions.assertEquals((int)0, (int)response.getErrors().size());
        TimelineEvent ev1 = TimelineStoreTestUtils.createEvent(123L, "start_event", null);
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity(entityId1, entityType1, 123L, Collections.singletonList(ev1), relatedEntities, primaryFilters, otherInfo1, "domain_id_1")));
        response = this.store.put(entities);
        Assertions.assertEquals((int)0, (int)response.getErrors().size());
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity(entityId1b, entityType1, null, Collections.singletonList(ev1), relatedEntities, primaryFilters, otherInfo1, "domain_id_1")));
        response = this.store.put(entities);
        Assertions.assertEquals((int)0, (int)response.getErrors().size());
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("event info 1", "val1");
        TimelineEvent ev2 = TimelineStoreTestUtils.createEvent(456L, "end_event", eventInfo);
        HashMap<String, Object> otherInfo2 = new HashMap<String, Object>();
        otherInfo2.put("info2", "val2");
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity(entityId1, entityType1, null, Collections.singletonList(ev2), null, primaryFilters, otherInfo2, "domain_id_1")));
        response = this.store.put(entities);
        Assertions.assertEquals((int)0, (int)response.getErrors().size());
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity(entityId1b, entityType1, 789L, Collections.singletonList(ev2), null, primaryFilters, otherInfo2, "domain_id_1")));
        response = this.store.put(entities);
        Assertions.assertEquals((int)0, (int)response.getErrors().size());
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity("badentityid", "badentity", null, null, null, null, otherInfo1, "domain_id_1")));
        response = this.store.put(entities);
        Assertions.assertEquals((int)1, (int)response.getErrors().size());
        TimelinePutResponse.TimelinePutError error = (TimelinePutResponse.TimelinePutError)response.getErrors().get(0);
        Assertions.assertEquals((Object)"badentityid", (Object)error.getEntityId());
        Assertions.assertEquals((Object)"badentity", (Object)error.getEntityType());
        Assertions.assertEquals((int)1, (int)error.getErrorCode());
        relatedEntities.clear();
        relatedEntities.put(entityType5, Collections.singleton(entityId5));
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity(entityId4, entityType4, 42L, null, relatedEntities, null, null, "domain_id_1")));
        response = this.store.put(entities);
        relatedEntities.clear();
        otherInfo1.put("info2", "val2");
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity(entityId6, entityType1, 61L, null, relatedEntities, primaryFilters, otherInfo1, "domain_id_2")));
        response = this.store.put(entities);
        relatedEntities.clear();
        relatedEntities.put(entityType1, Collections.singleton(entityId1));
        entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity(entityId7, entityType7, 62L, null, relatedEntities, null, null, "domain_id_2")));
        response = this.store.put(entities);
        Assertions.assertEquals((int)1, (int)response.getErrors().size());
        Assertions.assertEquals((Object)entityType7, (Object)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getEntityType());
        Assertions.assertEquals((Object)entityId7, (Object)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getEntityId());
        Assertions.assertEquals((int)6, (int)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getErrorCode());
        if (this.store instanceof LeveldbTimelineStore) {
            LeveldbTimelineStore leveldb = (LeveldbTimelineStore)this.store;
            entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity("OLD_ENTITY_ID_1", "OLD_ENTITY_TYPE_1", 63L, null, null, null, null, null)));
            leveldb.putWithNoDomainId(entities);
            entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity("OLD_ENTITY_ID_2", "OLD_ENTITY_TYPE_1", 64L, null, null, null, null, null)));
            leveldb.putWithNoDomainId(entities);
        }
    }

    protected void loadVerificationEntityData() throws Exception {
        this.userFilter = new NameValuePair("user", (Object)"username");
        this.numericFilter1 = new NameValuePair("appname", (Object)Integer.MAX_VALUE);
        this.numericFilter2 = new NameValuePair("long", (Object)0x80000000L);
        this.numericFilter3 = new NameValuePair("other", (Object)"123abc");
        this.goodTestingFilters = new ArrayList<NameValuePair>();
        this.goodTestingFilters.add(new NameValuePair("appname", (Object)Integer.MAX_VALUE));
        this.goodTestingFilters.add(new NameValuePair("status", (Object)"RUNNING"));
        this.badTestingFilters = new ArrayList<NameValuePair>();
        this.badTestingFilters.add(new NameValuePair("appname", (Object)Integer.MAX_VALUE));
        this.badTestingFilters.add(new NameValuePair("status", (Object)"FINISHED"));
        this.primaryFilters = new HashMap<String, Set<Object>>();
        HashSet<String> l1 = new HashSet<String>();
        l1.add("username");
        HashSet<Integer> l2 = new HashSet<Integer>();
        l2.add(Integer.MAX_VALUE);
        HashSet<String> l3 = new HashSet<String>();
        l3.add("123abc");
        HashSet<Long> l4 = new HashSet<Long>();
        l4.add(0x80000000L);
        this.primaryFilters.put("user", l1);
        this.primaryFilters.put("appname", l2);
        this.primaryFilters.put("other", l3);
        this.primaryFilters.put("long", l4);
        this.secondaryFilters = new HashMap<String, Object>();
        this.secondaryFilters.put("startTime", 123456);
        this.secondaryFilters.put("status", "RUNNING");
        this.allFilters = new HashMap<String, Object>();
        this.allFilters.putAll(this.secondaryFilters);
        for (Map.Entry<String, Set<Object>> pf : this.primaryFilters.entrySet()) {
            for (Object o : pf.getValue()) {
                this.allFilters.put(pf.getKey(), o);
            }
        }
        this.otherInfo = new HashMap<String, Object>();
        this.otherInfo.put("info1", "val1");
        this.otherInfo.put("info2", "val2");
        this.otherInfo.putAll(this.secondaryFilters);
        this.entityId1 = "id_1";
        this.entityType1 = "type_1";
        this.entityId1b = "id_2";
        this.entityId2 = "id_2";
        this.entityType2 = "type_2";
        this.entityId4 = "id_4";
        this.entityType4 = "type_4";
        this.entityId5 = "id_5";
        this.entityType5 = "type_5";
        this.entityId6 = "id_6";
        this.entityId7 = "id_7";
        this.entityType7 = "type_7";
        this.ev1 = TimelineStoreTestUtils.createEvent(123L, "start_event", null);
        this.eventInfo = new HashMap<String, Object>();
        this.eventInfo.put("event info 1", "val1");
        this.ev2 = TimelineStoreTestUtils.createEvent(456L, "end_event", this.eventInfo);
        this.events1 = new ArrayList<TimelineEvent>();
        this.events1.add(this.ev2);
        this.events1.add(this.ev1);
        this.relEntityMap = new HashMap<String, Set<String>>();
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.entityId1);
        ids.add(this.entityId1b);
        this.relEntityMap.put(this.entityType1, ids);
        this.relEntityMap2 = new HashMap<String, Set<String>>();
        this.relEntityMap2.put(this.entityType4, Collections.singleton(this.entityId4));
        this.ev3 = TimelineStoreTestUtils.createEvent(789L, "launch_event", null);
        this.ev4 = TimelineStoreTestUtils.createEvent(0L, "init_event", null);
        this.events2 = new ArrayList<TimelineEvent>();
        this.events2.add(this.ev3);
        this.events2.add(this.ev4);
        this.domainId1 = "domain_id_1";
        this.domainId2 = "domain_id_2";
    }

    protected void loadTestDomainData() throws IOException {
        this.domain1 = new TimelineDomain();
        this.domain1.setId("domain_id_1");
        this.domain1.setDescription("description_1");
        this.domain1.setOwner("owner_1");
        this.domain1.setReaders("reader_user_1 reader_group_1");
        this.domain1.setWriters("writer_user_1 writer_group_1");
        this.store.put(this.domain1);
        this.domain2 = new TimelineDomain();
        this.domain2.setId("domain_id_2");
        this.domain2.setDescription("description_2");
        this.domain2.setOwner("owner_2");
        this.domain2.setReaders("reader_user_2 reader_group_2");
        this.domain2.setWriters("writer_user_2 writer_group_2");
        this.store.put(this.domain2);
        this.elapsedTime = 1000L;
        try {
            Thread.sleep(this.elapsedTime);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.domain2.setDescription("description_3");
        this.domain2.setOwner("owner_3");
        this.domain2.setReaders("reader_user_3 reader_group_3");
        this.domain2.setWriters("writer_user_3 writer_group_3");
        this.store.put(this.domain2);
        this.domain3 = new TimelineDomain();
        this.domain3.setId("domain_id_4");
        this.domain3.setDescription("description_4");
        this.domain3.setOwner("owner_1");
        this.domain3.setReaders("reader_user_4 reader_group_4");
        this.domain3.setWriters("writer_user_4 writer_group_4");
        this.store.put(this.domain3);
        TimelineEntities entities = new TimelineEntities();
        if (this.store instanceof LeveldbTimelineStore) {
            LeveldbTimelineStore leveldb = (LeveldbTimelineStore)this.store;
            entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity("ACL_ENTITY_ID_11", "ACL_ENTITY_TYPE_1", 63L, null, null, null, null, "domain_id_4")));
            leveldb.put(entities);
            entities.setEntities(Collections.singletonList(TimelineStoreTestUtils.createEntity("ACL_ENTITY_ID_22", "ACL_ENTITY_TYPE_1", 64L, null, null, null, null, "domain_id_2")));
            leveldb.put(entities);
        }
    }

    public void testGetSingleEntity() throws IOException {
        TimelineStoreTestUtils.verifyEntityInfo(null, null, null, null, null, null, this.store.getEntity("id_1", "type_2", EnumSet.allOf(TimelineReader.Field.class)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, 123L, this.store.getEntity(this.entityId1, this.entityType1, EnumSet.allOf(TimelineReader.Field.class)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, 123L, this.store.getEntity(this.entityId1b, this.entityType1, EnumSet.allOf(TimelineReader.Field.class)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId2, this.entityType2, this.events2, this.relEntityMap, EMPTY_PRIMARY_FILTERS, EMPTY_MAP, 0L, this.store.getEntity(this.entityId2, this.entityType2, EnumSet.allOf(TimelineReader.Field.class)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId4, this.entityType4, EMPTY_EVENTS, EMPTY_REL_ENTITIES, EMPTY_PRIMARY_FILTERS, EMPTY_MAP, 42L, this.store.getEntity(this.entityId4, this.entityType4, EnumSet.allOf(TimelineReader.Field.class)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId5, this.entityType5, EMPTY_EVENTS, this.relEntityMap2, EMPTY_PRIMARY_FILTERS, EMPTY_MAP, 42L, this.store.getEntity(this.entityId5, this.entityType5, EnumSet.allOf(TimelineReader.Field.class)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, null, null, null, this.store.getEntity(this.entityId1, this.entityType1, EnumSet.of(TimelineReader.Field.EVENTS)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, Collections.singletonList(this.ev2), null, null, null, this.store.getEntity(this.entityId1, this.entityType1, EnumSet.of(TimelineReader.Field.LAST_EVENT_ONLY)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, this.store.getEntity(this.entityId1b, this.entityType1, null), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, null, null, this.primaryFilters, null, this.store.getEntity(this.entityId1, this.entityType1, EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, null, null, null, this.otherInfo, this.store.getEntity(this.entityId1, this.entityType1, EnumSet.of(TimelineReader.Field.OTHER_INFO)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId2, this.entityType2, null, this.relEntityMap, null, null, this.store.getEntity(this.entityId2, this.entityType2, EnumSet.of(TimelineReader.Field.RELATED_ENTITIES)), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, this.store.getEntity(this.entityId6, this.entityType1, EnumSet.allOf(TimelineReader.Field.class)), this.domainId2);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId7, this.entityType7, EMPTY_EVENTS, EMPTY_REL_ENTITIES, EMPTY_PRIMARY_FILTERS, EMPTY_MAP, this.store.getEntity(this.entityId7, this.entityType7, EnumSet.allOf(TimelineReader.Field.class)), this.domainId2);
    }

    protected List<TimelineEntity> getEntities(String entityType) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, null, null, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesWithPrimaryFilter(String entityType, NameValuePair primaryFilter) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, null, primaryFilter, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromId(String entityType, String fromId) throws IOException {
        return this.store.getEntities(entityType, null, null, null, fromId, null, null, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromTs(String entityType, long fromTs) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, Long.valueOf(fromTs), null, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromIdWithPrimaryFilter(String entityType, NameValuePair primaryFilter, String fromId) throws IOException {
        return this.store.getEntities(entityType, null, null, null, fromId, null, primaryFilter, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromTsWithPrimaryFilter(String entityType, NameValuePair primaryFilter, long fromTs) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, Long.valueOf(fromTs), primaryFilter, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromIdWithWindow(String entityType, Long windowEnd, String fromId) throws IOException {
        return this.store.getEntities(entityType, null, null, windowEnd, fromId, null, null, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesFromIdWithPrimaryFilterAndWindow(String entityType, Long windowEnd, String fromId, NameValuePair primaryFilter) throws IOException {
        return this.store.getEntities(entityType, null, null, windowEnd, fromId, null, primaryFilter, null, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesWithFilters(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, null, primaryFilter, secondaryFilters, null, null).getEntities();
    }

    protected List<TimelineEntity> getEntitiesWithFilters(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters, EnumSet<TimelineReader.Field> fields) throws IOException {
        return this.store.getEntities(entityType, null, null, null, null, null, primaryFilter, secondaryFilters, fields, null).getEntities();
    }

    protected List<TimelineEntity> getEntities(String entityType, Long limit, Long windowStart, Long windowEnd, NameValuePair primaryFilter, EnumSet<TimelineReader.Field> fields) throws IOException {
        return this.store.getEntities(entityType, limit, windowStart, windowEnd, null, null, primaryFilter, null, fields, null).getEntities();
    }

    public void testGetEntities() throws IOException {
        Assertions.assertEquals((int)0, (int)this.getEntities("type_0").size(), (String)"nonzero entities size for nonexistent type");
        Assertions.assertEquals((int)0, (int)this.getEntities("type_3").size(), (String)"nonzero entities size for nonexistent type");
        Assertions.assertEquals((int)0, (int)this.getEntities("type_6").size(), (String)"nonzero entities size for nonexistent type");
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_0", this.userFilter).size(), (String)"nonzero entities size for nonexistent type");
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_3", this.userFilter).size(), (String)"nonzero entities size for nonexistent type");
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_6", this.userFilter).size(), (String)"nonzero entities size for nonexistent type");
        List<TimelineEntity> entities = this.getEntities("type_1");
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        entities = this.getEntities("type_2");
        Assertions.assertEquals((int)1, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId2, this.entityType2, this.events2, this.relEntityMap, EMPTY_PRIMARY_FILTERS, EMPTY_MAP, entities.get(0), this.domainId1);
        entities = this.getEntities("type_1", 1L, null, null, null, EnumSet.allOf(TimelineReader.Field.class));
        Assertions.assertEquals((int)1, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        entities = this.getEntities("type_1", 1L, 0L, null, null, EnumSet.allOf(TimelineReader.Field.class));
        Assertions.assertEquals((int)1, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        entities = this.getEntities("type_1", null, 234L, null, null, EnumSet.allOf(TimelineReader.Field.class));
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntities("type_1", null, 123L, null, null, EnumSet.allOf(TimelineReader.Field.class));
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntities("type_1", null, 234L, 345L, null, EnumSet.allOf(TimelineReader.Field.class));
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntities("type_1", null, null, 345L, null, EnumSet.allOf(TimelineReader.Field.class));
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        entities = this.getEntities("type_1", null, null, 123L, null, EnumSet.allOf(TimelineReader.Field.class));
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
    }

    public void testGetEntitiesWithFromId() throws IOException {
        List<TimelineEntity> entities = this.getEntitiesFromId("type_1", this.entityId1);
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        entities = this.getEntitiesFromId("type_1", this.entityId1b);
        Assertions.assertEquals((int)2, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId2);
        entities = this.getEntitiesFromId("type_1", this.entityId6);
        Assertions.assertEquals((int)1, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId2);
        entities = this.getEntitiesFromIdWithWindow("type_1", 0L, this.entityId6);
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntitiesFromId("type_2", "a");
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntitiesFromId("type_2", this.entityId2);
        Assertions.assertEquals((int)1, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId2, this.entityType2, this.events2, this.relEntityMap, EMPTY_PRIMARY_FILTERS, EMPTY_MAP, entities.get(0), this.domainId1);
        entities = this.getEntitiesFromIdWithWindow("type_2", -456L, null);
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntitiesFromIdWithWindow("type_2", -456L, "a");
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntitiesFromIdWithWindow("type_2", 0L, null);
        Assertions.assertEquals((int)1, (int)entities.size());
        entities = this.getEntitiesFromIdWithWindow("type_2", 0L, this.entityId2);
        Assertions.assertEquals((int)1, (int)entities.size());
        entities = this.getEntitiesFromIdWithPrimaryFilter("type_1", this.userFilter, this.entityId1);
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        entities = this.getEntitiesFromIdWithPrimaryFilter("type_1", this.userFilter, this.entityId1b);
        Assertions.assertEquals((int)2, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId2);
        entities = this.getEntitiesFromIdWithPrimaryFilter("type_1", this.userFilter, this.entityId6);
        Assertions.assertEquals((int)1, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId2);
        entities = this.getEntitiesFromIdWithPrimaryFilterAndWindow("type_1", 0L, this.entityId6, this.userFilter);
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntitiesFromIdWithPrimaryFilter("type_2", this.userFilter, "a");
        Assertions.assertEquals((int)0, (int)entities.size());
    }

    public void testGetEntitiesWithFromTs() throws IOException {
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTs("type_1", this.beforeTs).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTs("type_2", this.beforeTs).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, this.beforeTs).size());
        long afterTs = System.currentTimeMillis();
        Assertions.assertEquals((int)3, (int)this.getEntitiesFromTs("type_1", afterTs).size());
        Assertions.assertEquals((int)1, (int)this.getEntitiesFromTs("type_2", afterTs).size());
        Assertions.assertEquals((int)3, (int)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, afterTs).size());
        Assertions.assertEquals((int)3, (int)this.getEntities("type_1").size());
        Assertions.assertEquals((int)1, (int)this.getEntities("type_2").size());
        Assertions.assertEquals((int)3, (int)this.getEntitiesWithPrimaryFilter("type_1", this.userFilter).size());
        long beforeTs = this.beforeTs;
        this.loadTestEntityData();
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTs("type_1", beforeTs).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTs("type_2", beforeTs).size());
        Assertions.assertEquals((int)0, (int)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, beforeTs).size());
        Assertions.assertEquals((int)3, (int)this.getEntitiesFromTs("type_1", afterTs).size());
        Assertions.assertEquals((int)1, (int)this.getEntitiesFromTs("type_2", afterTs).size());
        Assertions.assertEquals((int)3, (int)this.getEntitiesFromTsWithPrimaryFilter("type_1", this.userFilter, afterTs).size());
    }

    public void testGetEntitiesWithPrimaryFilters() throws IOException {
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_1", new NameValuePair("none", (Object)"none")).size(), (String)"nonzero entities size for primary filter");
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_2", new NameValuePair("none", (Object)"none")).size(), (String)"nonzero entities size for primary filter");
        Assertions.assertEquals((int)0, (int)this.getEntitiesWithPrimaryFilter("type_3", new NameValuePair("none", (Object)"none")).size(), (String)"nonzero entities size for primary filter");
        List<TimelineEntity> entities = this.getEntitiesWithPrimaryFilter("type_1", this.userFilter);
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.numericFilter1);
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.numericFilter2);
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        entities = this.getEntitiesWithPrimaryFilter("type_1", this.numericFilter3);
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
        entities = this.getEntitiesWithPrimaryFilter("type_2", this.userFilter);
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntities("type_1", 1L, null, null, this.userFilter, null);
        Assertions.assertEquals((int)1, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        entities = this.getEntities("type_1", 1L, 0L, null, this.userFilter, null);
        Assertions.assertEquals((int)1, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        entities = this.getEntities("type_1", null, 234L, null, this.userFilter, null);
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntities("type_1", null, 234L, 345L, this.userFilter, null);
        Assertions.assertEquals((int)0, (int)entities.size());
        entities = this.getEntities("type_1", null, null, 345L, this.userFilter, null);
        Assertions.assertEquals((int)3, (int)entities.size());
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(0), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, this.events1, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(1), this.domainId1);
        TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, EMPTY_EVENTS, EMPTY_REL_ENTITIES, this.primaryFilters, this.otherInfo, entities.get(2), this.domainId2);
    }

    public void testGetEntitiesWithSecondaryFilters() throws IOException {
        for (int i = 0; i < 4; ++i) {
            EnumSet<TimelineReader.Field> fields = null;
            if (i == 1) {
                fields = EnumSet.noneOf(TimelineReader.Field.class);
            } else if (i == 2) {
                fields = EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS);
            } else if (i == 3) {
                fields = EnumSet.of(TimelineReader.Field.OTHER_INFO);
            }
            List<TimelineEntity> entities = this.getEntitiesWithFilters("type_1", null, this.goodTestingFilters, fields);
            Assertions.assertEquals((int)3, (int)entities.size());
            TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, i == 0 ? this.events1 : null, i == 0 ? EMPTY_REL_ENTITIES : null, i == 0 || i == 2 ? this.primaryFilters : null, i == 0 || i == 3 ? this.otherInfo : null, entities.get(0), this.domainId1);
            TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, i == 0 ? this.events1 : null, i == 0 ? EMPTY_REL_ENTITIES : null, i == 0 || i == 2 ? this.primaryFilters : null, i == 0 || i == 3 ? this.otherInfo : null, entities.get(1), this.domainId1);
            TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, i == 0 ? EMPTY_EVENTS : null, i == 0 ? EMPTY_REL_ENTITIES : null, i == 0 || i == 2 ? this.primaryFilters : null, i == 0 || i == 3 ? this.otherInfo : null, entities.get(2), this.domainId2);
            entities = this.getEntitiesWithFilters("type_1", this.userFilter, this.goodTestingFilters, fields);
            Assertions.assertEquals((int)3, (int)entities.size());
            if (i == 0) {
                TimelineStoreTestUtils.verifyEntityInfo(this.entityId1, this.entityType1, i == 0 ? this.events1 : null, i == 0 ? EMPTY_REL_ENTITIES : null, i == 0 || i == 2 ? this.primaryFilters : null, i == 0 || i == 3 ? this.otherInfo : null, entities.get(0), this.domainId1);
                TimelineStoreTestUtils.verifyEntityInfo(this.entityId1b, this.entityType1, i == 0 ? this.events1 : null, i == 0 ? EMPTY_REL_ENTITIES : null, i == 0 || i == 2 ? this.primaryFilters : null, i == 0 || i == 3 ? this.otherInfo : null, entities.get(1), this.domainId1);
                TimelineStoreTestUtils.verifyEntityInfo(this.entityId6, this.entityType1, i == 0 ? EMPTY_EVENTS : null, i == 0 ? EMPTY_REL_ENTITIES : null, i == 0 || i == 2 ? this.primaryFilters : null, i == 0 || i == 3 ? this.otherInfo : null, entities.get(2), this.domainId2);
            }
            entities = this.getEntitiesWithFilters("type_1", null, Collections.singleton(new NameValuePair("user", (Object)"none")), fields);
            Assertions.assertEquals((int)0, (int)entities.size());
            entities = this.getEntitiesWithFilters("type_1", null, this.badTestingFilters, fields);
            Assertions.assertEquals((int)0, (int)entities.size());
            entities = this.getEntitiesWithFilters("type_1", this.userFilter, this.badTestingFilters, fields);
            Assertions.assertEquals((int)0, (int)entities.size());
            entities = this.getEntitiesWithFilters("type_5", null, this.badTestingFilters, fields);
            Assertions.assertEquals((int)0, (int)entities.size());
        }
    }

    public void testGetEvents() throws IOException {
        TreeSet<String> sortedSet = new TreeSet<String>();
        sortedSet.add(this.entityId1);
        List timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, null, null).getAllEvents();
        Assertions.assertEquals((int)1, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId1, this.entityType1, this.ev2, this.ev1);
        sortedSet.add(this.entityId1b);
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, null, null).getAllEvents();
        Assertions.assertEquals((int)2, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId1, this.entityType1, this.ev2, this.ev1);
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(1), this.entityId1b, this.entityType1, this.ev2, this.ev1);
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, Long.valueOf(1L), null, null, null).getAllEvents();
        Assertions.assertEquals((int)2, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId1, this.entityType1, this.ev2);
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(1), this.entityId1b, this.entityType1, this.ev2);
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, Long.valueOf(345L), null, null).getAllEvents();
        Assertions.assertEquals((int)2, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId1, this.entityType1, this.ev2);
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(1), this.entityId1b, this.entityType1, this.ev2);
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, Long.valueOf(123L), null, null).getAllEvents();
        Assertions.assertEquals((int)2, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId1, this.entityType1, this.ev2);
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(1), this.entityId1b, this.entityType1, this.ev2);
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, Long.valueOf(345L), null).getAllEvents();
        Assertions.assertEquals((int)2, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId1, this.entityType1, this.ev1);
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(1), this.entityId1b, this.entityType1, this.ev1);
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, Long.valueOf(123L), null).getAllEvents();
        Assertions.assertEquals((int)2, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId1, this.entityType1, this.ev1);
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(1), this.entityId1b, this.entityType1, this.ev1);
        timelines = this.store.getEntityTimelines(this.entityType1, sortedSet, null, null, null, Collections.singleton("end_event")).getAllEvents();
        Assertions.assertEquals((int)2, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId1, this.entityType1, this.ev2);
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(1), this.entityId1b, this.entityType1, this.ev2);
        sortedSet.add(this.entityId2);
        timelines = this.store.getEntityTimelines(this.entityType2, sortedSet, null, null, null, null).getAllEvents();
        Assertions.assertEquals((int)1, (int)timelines.size());
        TimelineStoreTestUtils.verifyEntityTimeline((TimelineEvents.EventsOfOneEntity)timelines.get(0), this.entityId2, this.entityType2, this.ev3, this.ev4);
    }

    protected static void verifyEntityInfo(String entityId, String entityType, List<TimelineEvent> events, Map<String, Set<String>> relatedEntities, Map<String, Set<Object>> primaryFilters, Map<String, Object> otherInfo, Long startTime, TimelineEntity retrievedEntityInfo, String domainId) {
        TimelineStoreTestUtils.verifyEntityInfo(entityId, entityType, events, relatedEntities, primaryFilters, otherInfo, retrievedEntityInfo, domainId);
        Assertions.assertEquals((Long)startTime, (Long)retrievedEntityInfo.getStartTime());
    }

    protected static void verifyEntityInfo(String entityId, String entityType, List<TimelineEvent> events, Map<String, Set<String>> relatedEntities, Map<String, Set<Object>> primaryFilters, Map<String, Object> otherInfo, TimelineEntity retrievedEntityInfo, String domainId) {
        if (entityId == null) {
            Assertions.assertNull((Object)retrievedEntityInfo);
            return;
        }
        Assertions.assertEquals((Object)entityId, (Object)retrievedEntityInfo.getEntityId());
        Assertions.assertEquals((Object)entityType, (Object)retrievedEntityInfo.getEntityType());
        Assertions.assertEquals((Object)domainId, (Object)retrievedEntityInfo.getDomainId());
        if (events == null) {
            Assertions.assertNull((Object)retrievedEntityInfo.getEvents());
        } else {
            Assertions.assertEquals(events, (Object)retrievedEntityInfo.getEvents());
        }
        if (relatedEntities == null) {
            Assertions.assertNull((Object)retrievedEntityInfo.getRelatedEntities());
        } else {
            Assertions.assertEquals(relatedEntities, (Object)retrievedEntityInfo.getRelatedEntities());
        }
        if (primaryFilters == null) {
            Assertions.assertNull((Object)retrievedEntityInfo.getPrimaryFilters());
        } else {
            Assertions.assertEquals(primaryFilters, (Object)retrievedEntityInfo.getPrimaryFilters());
        }
        if (otherInfo == null) {
            Assertions.assertNull((Object)retrievedEntityInfo.getOtherInfo());
        } else {
            Assertions.assertEquals(otherInfo, (Object)retrievedEntityInfo.getOtherInfo());
        }
    }

    private static void verifyEntityTimeline(TimelineEvents.EventsOfOneEntity retrievedEvents, String entityId, String entityType, TimelineEvent ... actualEvents) {
        Assertions.assertEquals((Object)entityId, (Object)retrievedEvents.getEntityId());
        Assertions.assertEquals((Object)entityType, (Object)retrievedEvents.getEntityType());
        Assertions.assertEquals((int)actualEvents.length, (int)retrievedEvents.getEvents().size());
        for (int i = 0; i < actualEvents.length; ++i) {
            Assertions.assertEquals((Object)actualEvents[i], retrievedEvents.getEvents().get(i));
        }
    }

    protected static TimelineEntity createEntity(String entityId, String entityType, Long startTime, List<TimelineEvent> events, Map<String, Set<String>> relatedEntities, Map<String, Set<Object>> primaryFilters, Map<String, Object> otherInfo, String domainId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(entityId);
        entity.setEntityType(entityType);
        entity.setStartTime(startTime);
        entity.setEvents(events);
        if (relatedEntities != null) {
            for (Map.Entry<String, Set<String>> e : relatedEntities.entrySet()) {
                for (String v : e.getValue()) {
                    entity.addRelatedEntity(e.getKey(), v);
                }
            }
        } else {
            entity.setRelatedEntities(null);
        }
        entity.setPrimaryFilters(primaryFilters);
        entity.setOtherInfo(otherInfo);
        entity.setDomainId(domainId);
        return entity;
    }

    private static TimelineEvent createEvent(long timestamp, String type, Map<String, Object> info) {
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(timestamp);
        event.setEventType(type);
        event.setEventInfo(info);
        return event;
    }

    public void testGetDomain() throws IOException {
        TimelineDomain actualDomain1 = this.store.getDomain(this.domain1.getId());
        TimelineStoreTestUtils.verifyDomainInfo(this.domain1, actualDomain1);
        Assertions.assertTrue((actualDomain1.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((actualDomain1.getModifiedTime() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Long)actualDomain1.getCreatedTime(), (Long)actualDomain1.getModifiedTime());
        TimelineDomain actualDomain2 = this.store.getDomain(this.domain2.getId());
        TimelineStoreTestUtils.verifyDomainInfo(this.domain2, actualDomain2);
        Assertions.assertEquals((Object)"domain_id_2", (Object)actualDomain2.getId());
        Assertions.assertTrue((actualDomain2.getCreatedTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((actualDomain2.getModifiedTime() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((actualDomain2.getCreatedTime() < actualDomain2.getModifiedTime() ? 1 : 0) != 0);
    }

    public void testGetDomains() throws IOException {
        TimelineDomains actualDomains = this.store.getDomains("owner_1");
        Assertions.assertEquals((int)2, (int)actualDomains.getDomains().size());
        TimelineStoreTestUtils.verifyDomainInfo(this.domain3, (TimelineDomain)actualDomains.getDomains().get(0));
        TimelineStoreTestUtils.verifyDomainInfo(this.domain1, (TimelineDomain)actualDomains.getDomains().get(1));
        actualDomains = this.store.getDomains("owner_4");
        Assertions.assertEquals((int)0, (int)actualDomains.getDomains().size());
    }

    private static void verifyDomainInfo(TimelineDomain expected, TimelineDomain actual) {
        Assertions.assertEquals((Object)expected.getId(), (Object)actual.getId());
        Assertions.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription());
        Assertions.assertEquals((Object)expected.getOwner(), (Object)actual.getOwner());
        Assertions.assertEquals((Object)expected.getReaders(), (Object)actual.getReaders());
        Assertions.assertEquals((Object)expected.getWriters(), (Object)actual.getWriters());
    }
}

