/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.RollingLevelDB;
import org.iq80.leveldb.DB;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRollingLevelDB {
    private Configuration conf = new YarnConfiguration();
    private FileSystem lfs;
    private MyRollingLevelDB rollingLevelDB;

    @BeforeEach
    public void setup() throws Exception {
        this.lfs = FileSystem.getLocal((Configuration)this.conf);
        File fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.conf.set("yarn.timeline-service.leveldb-timeline-store.path", fsPath.getAbsolutePath());
        this.lfs.delete(new Path(fsPath.getAbsolutePath()), true);
        this.rollingLevelDB = new MyRollingLevelDB();
    }

    @Test
    void testInsertAfterRollPeriodRollsDB() throws Exception {
        this.rollingLevelDB.init(this.conf);
        long now = this.rollingLevelDB.currentTimeMillis();
        DB db = this.rollingLevelDB.getDBForStartTime(now);
        long startTime = this.rollingLevelDB.getStartTimeFor(db);
        Assertions.assertEquals((long)this.rollingLevelDB.computeCurrentCheckMillis(now), (long)startTime, (String)"Received level db for incorrect start time");
        now = this.rollingLevelDB.getNextRollingTimeMillis();
        this.rollingLevelDB.setCurrentTimeMillis(now);
        db = this.rollingLevelDB.getDBForStartTime(now);
        startTime = this.rollingLevelDB.getStartTimeFor(db);
        Assertions.assertEquals((long)this.rollingLevelDB.computeCurrentCheckMillis(now), (long)startTime, (String)"Received level db for incorrect start time");
    }

    @Test
    void testInsertForPreviousPeriodAfterRollPeriodRollsDB() throws Exception {
        this.rollingLevelDB.init(this.conf);
        long now = this.rollingLevelDB.currentTimeMillis();
        now = this.rollingLevelDB.computeCurrentCheckMillis(now);
        this.rollingLevelDB.setCurrentTimeMillis(now);
        DB db = this.rollingLevelDB.getDBForStartTime(now - 1L);
        long startTime = this.rollingLevelDB.getStartTimeFor(db);
        Assertions.assertEquals((long)this.rollingLevelDB.computeCurrentCheckMillis(now - 1L), (long)startTime, (String)"Received level db for incorrect start time");
    }

    public static class MyRollingLevelDB
    extends RollingLevelDB {
        private long currentTimeMillis = System.currentTimeMillis();

        MyRollingLevelDB() {
            super("Test");
        }

        protected long currentTimeMillis() {
            return this.currentTimeMillis;
        }

        public void setCurrentTimeMillis(long time) {
            this.currentTimeMillis = time;
        }
    }
}

