/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factories.impl.pb;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RpcClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RpcClientFactoryPBImpl
implements RpcClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RpcClientFactoryPBImpl.class);
    private static final String PB_IMPL_PACKAGE_SUFFIX = "impl.pb.client";
    private static final String PB_IMPL_CLASS_SUFFIX = "PBClientImpl";
    private static final RpcClientFactoryPBImpl self = new RpcClientFactoryPBImpl();
    private ConcurrentMap<Class<?>, Constructor<?>> cache = new ConcurrentHashMap();

    public static RpcClientFactoryPBImpl get() {
        return self;
    }

    private RpcClientFactoryPBImpl() {
    }

    @Override
    public Object getClient(Class<?> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) {
        Constructor constructor = (Constructor)this.cache.get(protocol);
        if (constructor == null) {
            Class pbClazz = null;
            try {
                pbClazz = conf.getClassByName(this.getPBImplClassName(protocol));
            }
            catch (ClassNotFoundException e) {
                throw new YarnRuntimeException("Failed to load class: [" + this.getPBImplClassName(protocol) + "]", (Throwable)e);
            }
            try {
                constructor = pbClazz.getConstructor(Long.TYPE, InetSocketAddress.class, Configuration.class);
                constructor.setAccessible(true);
                this.cache.putIfAbsent(protocol, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new YarnRuntimeException("Could not find constructor with params: " + Long.TYPE + ", " + InetSocketAddress.class + ", " + Configuration.class, (Throwable)e);
            }
        }
        try {
            Object retObject = constructor.newInstance(clientVersion, addr, conf);
            return retObject;
        }
        catch (InvocationTargetException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    @Override
    public void stopClient(Object proxy) {
        try {
            if (proxy instanceof Closeable) {
                ((Closeable)proxy).close();
                return;
            }
            InvocationHandler handler = Proxy.getInvocationHandler(proxy);
            if (handler instanceof Closeable) {
                ((Closeable)((Object)handler)).close();
                return;
            }
        }
        catch (Exception e) {
            LOG.error("Cannot call close method due to Exception. Ignoring.", (Throwable)e);
            throw new YarnRuntimeException((Throwable)e);
        }
        throw new HadoopIllegalArgumentException("Cannot close proxy - is not Closeable or does not provide closeable invocation handler " + proxy.getClass());
    }

    private String getPBImplClassName(Class<?> clazz) {
        String srcPackagePart = this.getPackageName(clazz);
        String srcClassName = this.getClassName(clazz);
        String destPackagePart = srcPackagePart + ".impl.pb.client";
        String destClassPart = srcClassName + PB_IMPL_CLASS_SUFFIX;
        return destPackagePart + "." + destClassPart;
    }

    private String getClassName(Class<?> clazz) {
        String fqName = clazz.getName();
        return fqName.substring(fqName.lastIndexOf(".") + 1, fqName.length());
    }

    private String getPackageName(Class<?> clazz) {
        return clazz.getPackage().getName();
    }
}

