/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.inject.Inject;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.MyTestJAXBContextResolver;
import org.apache.hadoop.yarn.webapp.MyTestWebService;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.apache.hadoop.yarn.webapp.view.TextPage;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWebApp {
    static final Logger LOG = LoggerFactory.getLogger(TestWebApp.class);

    String echo(String s) {
        return s;
    }

    @Test
    void testCreate() {
        WebApp app = WebApps.$for((Object)this).start();
        app.stop();
    }

    @Test
    void testCreateWithPort() {
        WebApp app = WebApps.$for((Object)this).at(0).start();
        int port = app.getListenerAddress().getPort();
        Assertions.assertTrue((port > 0 ? 1 : 0) != 0);
        app.stop();
        app = WebApps.$for((Object)this).at(port).start();
        Assertions.assertEquals((int)port, (int)app.getListenerAddress().getPort());
        app.stop();
    }

    @Test
    void testCreateWithBindAddressNonZeroPort() {
        Assertions.assertThrows(WebAppException.class, () -> {
            WebApp app = WebApps.$for((Object)this).at("0.0.0.0:50000").start();
            int port = app.getListenerAddress().getPort();
            Assertions.assertEquals((int)50000, (int)port);
            WebApp app2 = WebApps.$for((Object)this).at("0.0.0.0:50000").start();
            app.stop();
            app2.stop();
        });
    }

    @Test
    void testCreateWithNonZeroPort() {
        Assertions.assertThrows(WebAppException.class, () -> {
            WebApp app = WebApps.$for((Object)this).at(50000).start();
            int port = app.getListenerAddress().getPort();
            Assertions.assertEquals((int)50000, (int)port);
            WebApp app2 = WebApps.$for((Object)this).at(50000).start();
            app.stop();
            app2.stop();
        });
    }

    @Test
    void testServePaths() {
        WebApp app = WebApps.$for((String)"test", (Object)this).start();
        Assertions.assertEquals((Object)"/test", (Object)app.getRedirectPath());
        String[] expectedPaths = new String[]{"/test", "/test/*"};
        Object[] pathSpecs = app.getServePathSpecs();
        Assertions.assertEquals((int)2, (int)pathSpecs.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])pathSpecs, (Object)expectedPaths[i]));
        }
        app.stop();
    }

    @Test
    void testServePathsNoName() {
        WebApp app = WebApps.$for((String)"", (Object)this).start();
        Assertions.assertEquals((Object)"/", (Object)app.getRedirectPath());
        String[] expectedPaths = new String[]{"/*"};
        Object[] pathSpecs = app.getServePathSpecs();
        Assertions.assertEquals((int)1, (int)pathSpecs.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])pathSpecs, (Object)expectedPaths[i]));
        }
        app.stop();
    }

    @Test
    void testDefaultRoutes() throws Exception {
        WebApp app = WebApps.$for((String)"test", TestWebApp.class, (Object)this, (String)"ws").withResourceConfig(TestWebApp.configure()).start();
        String baseUrl = TestWebApp.baseUrl(app);
        try {
            Assertions.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl + "test/foo").trim());
            Assertions.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl + "test/foo/index").trim());
            Assertions.assertEquals((Object)"bar", (Object)TestWebApp.getContent(baseUrl + "test/foo/bar").trim());
            Assertions.assertEquals((Object)"default", (Object)TestWebApp.getContent(baseUrl + "test/").trim());
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCustomRoutes() throws Exception {
        WebApp newWebApp = new WebApp(){

            public void setup() {
                this.route("/:foo", FooController.class);
                this.route("/bar/foo", FooController.class, "bar");
                this.route("/foo/:foo", DefaultController.class);
                this.route("/foo/bar/:foo", DefaultController.class, "index");
            }
        };
        WebApp app = WebApps.$for((String)"test", (Object)this).withResourceConfig(TestWebApp.configure()).start(newWebApp);
        String baseUrl = TestWebApp.baseUrl(app);
        try {
            Assertions.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl + "test/").trim());
            Assertions.assertEquals((Object)"foo1", (Object)TestWebApp.getContent(baseUrl + "test/1").trim());
            Assertions.assertEquals((Object)"bar", (Object)TestWebApp.getContent(baseUrl + "test/bar/foo").trim());
            Assertions.assertEquals((Object)"default", (Object)TestWebApp.getContent(baseUrl + "test/foo/bar").trim());
            Assertions.assertEquals((Object)"default1", (Object)TestWebApp.getContent(baseUrl + "test/foo/1").trim());
            Assertions.assertEquals((Object)"default2", (Object)TestWebApp.getContent(baseUrl + "test/foo/bar/2").trim());
            Assertions.assertEquals((int)404, (int)TestWebApp.getResponseCode(baseUrl));
            Assertions.assertEquals((int)404, (int)TestWebApp.getResponseCode(baseUrl + "test/goo"));
            Assertions.assertEquals((int)200, (int)TestWebApp.getResponseCode(baseUrl + "ws/v1/test"));
            Assertions.assertTrue((boolean)TestWebApp.getContent(baseUrl + "ws/v1/test").contains("myInfo"));
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testEncodedUrl() throws Exception {
        WebApp webApp = new WebApp(){

            public void setup() {
                this.route("/:foo", FooController.class);
            }
        };
        WebApp app = WebApps.$for((String)"test", TestWebApp.class, (Object)this, (String)"ws").withResourceConfig(TestWebApp.configure()).start(webApp);
        String baseUrl = TestWebApp.baseUrl(app);
        try {
            String rawPath = "localhost:8080";
            String encodedUrl = baseUrl + "test/" + URLEncoder.encode(rawPath, "UTF-8");
            Assertions.assertEquals((Object)("foo" + rawPath), (Object)TestWebApp.getContent(encodedUrl).trim());
            rawPath = "@;%$";
            encodedUrl = baseUrl + "test/" + URLEncoder.encode(rawPath, "UTF-8");
            Assertions.assertEquals((Object)("foo" + rawPath), (Object)TestWebApp.getContent(encodedUrl).trim());
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testRobotsText() throws Exception {
        WebApp newWebApp = new WebApp(){

            public void setup() {
            }
        };
        WebApp app = WebApps.$for((String)"test", TestWebApp.class, (Object)this, (String)"ws").withResourceConfig(TestWebApp.configure()).start(newWebApp);
        String baseUrl = TestWebApp.baseUrl(app);
        try {
            String[] robotsTxtOutput = TestWebApp.getContent(baseUrl + "robots.txt").trim().split(System.getProperty("line.separator"));
            Assertions.assertEquals((int)2, (int)robotsTxtOutput.length);
            Assertions.assertEquals((Object)"User-agent: *", (Object)robotsTxtOutput[0]);
            Assertions.assertEquals((Object)"Disallow: /", (Object)robotsTxtOutput[1]);
        }
        finally {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testYARNWebAppContext() throws Exception {
        System.setProperty("hadoop.log.dir", "/Not/Existing/dir");
        WebApp webApp = new WebApp(){

            public void setup() {
                this.route("/", FooController.class);
            }
        };
        WebApp app = WebApps.$for((String)"test", (Object)this).withResourceConfig(TestWebApp.configure()).start(webApp);
        String baseUrl = TestWebApp.baseUrl(app);
        try {
            Assertions.assertEquals((int)404, (int)TestWebApp.getResponseCode(baseUrl + "logs"));
            Assertions.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl + "test/foo").trim());
        }
        finally {
            app.stop();
        }
    }

    private static void stopWebApp(WebApp app) {
        if (app != null) {
            app.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPortRanges() throws Exception {
        WebApp app = WebApps.$for((String)"test", (Object)this).start();
        String baseUrl = TestWebApp.baseUrl(app);
        WebApp app1 = null;
        WebApp app2 = null;
        WebApp app3 = null;
        WebApp app4 = null;
        WebApp app5 = null;
        try {
            int port = ServerSocketUtil.waitForPort((int)48000, (int)60);
            Assertions.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl + "test/foo").trim());
            app1 = WebApps.$for((String)"test", (Object)this).at(port).start();
            Assertions.assertEquals((int)port, (int)app1.getListenerAddress().getPort());
            app2 = WebApps.$for((String)"test", (Object)this).at("0.0.0.0", port, true).start();
            Assertions.assertTrue((app2.getListenerAddress().getPort() > port ? 1 : 0) != 0);
            Configuration conf = new Configuration();
            port = ServerSocketUtil.waitForPort((int)47000, (int)60);
            app3 = WebApps.$for((String)"test", (Object)this).at(port).withPortRange(conf, "abc").start();
            Assertions.assertEquals((int)port, (int)app3.getListenerAddress().getPort());
            ServerSocketUtil.waitForPort((int)46000, (int)60);
            conf.set("abc", "46000-46500");
            app4 = WebApps.$for((String)"test", (Object)this).at(port).withPortRange(conf, "abc").start();
            Assertions.assertEquals((int)46000, (int)app4.getListenerAddress().getPort());
            app5 = WebApps.$for((String)"test", (Object)this).withPortRange(conf, "abc").start();
            Assertions.assertTrue((app5.getListenerAddress().getPort() > 46000 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            TestWebApp.stopWebApp(app);
            TestWebApp.stopWebApp(app1);
            TestWebApp.stopWebApp(app2);
            TestWebApp.stopWebApp(app3);
            TestWebApp.stopWebApp(app4);
            TestWebApp.stopWebApp(app5);
            throw throwable;
        }
        TestWebApp.stopWebApp(app);
        TestWebApp.stopWebApp(app1);
        TestWebApp.stopWebApp(app2);
        TestWebApp.stopWebApp(app3);
        TestWebApp.stopWebApp(app4);
        TestWebApp.stopWebApp(app5);
    }

    static String baseUrl(WebApp app) {
        return "http://localhost:" + app.port() + "/";
    }

    static String getContent(String url) {
        try {
            StringBuilder out = new StringBuilder();
            InputStream in = new URL(url).openConnection().getInputStream();
            byte[] buffer = new byte[65536];
            int len = in.read(buffer);
            while (len > 0) {
                out.append(new String(buffer, 0, len));
                len = in.read(buffer);
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static int getResponseCode(String url) {
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
            return c.getResponseCode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static ResourceConfig configure() {
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"org.apache.hadoop.yarn.webapp"});
        config.register(MyTestWebService.class);
        config.register(GenericExceptionHandler.class);
        config.register((Object)new JettisonFeature()).register(MyTestJAXBContextResolver.class);
        return config;
    }

    static class TablesView
    extends HtmlPage {
        TablesView() {
        }

        public void render(Hamlet.HTML<HtmlPage.__> html) {
            this.set("ui.dataTables.id", "t1 t2 t3 t4");
            this.set(JQueryUI.initID((String)"ui.dataTables", (String)"t1"), JQueryUI.tableInit().append("}").toString());
            this.set(JQueryUI.initID((String)"ui.dataTables", (String)"t2"), StringHelper.join((Object[])new Object[]{"{bJQueryUI:true, sDom:'t',", "aoColumns:[null, {bSortable:false, bSearchable:false}]}"}));
            this.set(JQueryUI.initID((String)"ui.dataTables", (String)"t3"), "{bJQueryUI:true, sDom:'t'}");
            this.set(JQueryUI.initID((String)"ui.dataTables", (String)"t4"), "{bJQueryUI:true, sDom:'t'}");
            ((Hamlet.HTML)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TR)((Hamlet.TD)((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TBODY)((Hamlet.TR)((Hamlet.TD)((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)html.title("Test DataTables").link("/static/yarn.css").__(JQueryUI.class).style(new Object[]{".wrapper { padding: 1em }", ".wrapper h2 { margin: 0.5em 0 }", ".dataTables_wrapper { min-height: 1em }"}).div(".wrapper").h2("Default table init").table("#t1").thead().tr().th("Column1").th("Column2").__()).__()).tbody().tr().td("c1r1").td("c2r1").__()).tr().td("c1r2").td("c2r2").__()).__()).__()).h2("Nested tables").div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#t2").thead().tr().th(".ui-state-default", "Column1").th(".ui-state-default", "Column2").__()).__()).tbody().tr().td("r1").td().$class("table").table("#t3").thead().tr().th("SubColumn1").th("SubColumn2").__()).__()).tbody().tr().td("subc1r1").td("subc2r1").__()).tr().td("subc1r2").td("subc2r2").__()).__()).__()).__()).__()).tr().td("r2").td().$class("table").table("#t4").thead().tr().th("SubColumn1").th("SubColumn2").__()).__()).tbody().tr().td("subc1r1").td("subc2r1").__()).tr().td("subc1r2").td("subc2r2").__()).__()).__()).__()).__()).__()).__()).__()).__()).__();
        }
    }

    static class DefaultController
    extends Controller {
        DefaultController() {
        }

        public void index() {
            this.set("key", "default");
            this.render(FooView.class);
        }
    }

    static class FooView
    extends TextPage {
        FooView() {
        }

        public void render() {
            this.puts(new Object[]{this.$("key"), this.$("foo")});
        }
    }

    static class FooController
    extends Controller {
        final TestWebApp test;

        @Inject
        FooController(TestWebApp test) {
            this.test = test;
        }

        public void index() {
            this.set("key", this.test.echo("foo"));
        }

        public void bar() {
            this.set("key", "bar");
        }

        public void names() {
            for (int i = 0; i < 20; ++i) {
                this.renderText(MockApps.newAppName() + "\n");
            }
        }

        public void ex() {
            boolean err = this.$("clear").isEmpty();
            this.renderText(err ? "Should redirect to an error page." : "No error!");
            if (err) {
                throw new RuntimeException("exception test");
            }
        }

        public void tables() {
            this.render(TablesView.class);
        }
    }
}

