/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.util.Arrays;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParseRoute {
    @Test
    void testNormalAction() {
        Assertions.assertEquals(Arrays.asList("/foo/action", "foo", "action", ":a1", ":a2"), (Object)WebApp.parseRoute((String)"/foo/action/:a1/:a2"));
    }

    @Test
    void testDefaultController() {
        Assertions.assertEquals(Arrays.asList("/", "default", "index"), (Object)WebApp.parseRoute((String)"/"));
    }

    @Test
    void testDefaultAction() {
        Assertions.assertEquals(Arrays.asList("/foo", "foo", "index"), (Object)WebApp.parseRoute((String)"/foo"));
        Assertions.assertEquals(Arrays.asList("/foo", "foo", "index"), (Object)WebApp.parseRoute((String)"/foo/"));
    }

    @Test
    void testMissingAction() {
        Assertions.assertEquals(Arrays.asList("/foo", "foo", "index", ":a1"), (Object)WebApp.parseRoute((String)"/foo/:a1"));
    }

    @Test
    void testDefaultCapture() {
        Assertions.assertEquals(Arrays.asList("/", "default", "index", ":a"), (Object)WebApp.parseRoute((String)"/:a"));
    }

    @Test
    void testPartialCapture1() {
        Assertions.assertEquals(Arrays.asList("/foo/action/bar", "foo", "action", "bar", ":a"), (Object)WebApp.parseRoute((String)"/foo/action/bar/:a"));
    }

    @Test
    void testPartialCapture2() {
        Assertions.assertEquals(Arrays.asList("/foo/action", "foo", "action", ":a1", "bar", ":a2", ":a3"), (Object)WebApp.parseRoute((String)"/foo/action/:a1/bar/:a2/:a3"));
    }

    @Test
    void testLeadingPaddings() {
        Assertions.assertEquals(Arrays.asList("/foo/action", "foo", "action", ":a"), (Object)WebApp.parseRoute((String)" /foo/action/ :a"));
    }

    @Test
    void testTrailingPaddings() {
        Assertions.assertEquals(Arrays.asList("/foo/action", "foo", "action", ":a"), (Object)WebApp.parseRoute((String)"/foo/action//:a / "));
        Assertions.assertEquals(Arrays.asList("/foo/action", "foo", "action"), (Object)WebApp.parseRoute((String)"/foo/action / "));
    }

    @Test
    void testMissingLeadingSlash() {
        Assertions.assertThrows(WebAppException.class, () -> WebApp.parseRoute((String)"foo/bar"));
    }
}

