/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestResourceCalculatorProcessTree {
    @Test
    void testCreateInstance() {
        ResourceCalculatorProcessTree tree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)"1", EmptyProcessTree.class, (Configuration)new Configuration());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)tree);
        Assertions.assertThat((Object)tree).isInstanceOf(EmptyProcessTree.class);
    }

    @Test
    void testCreatedInstanceConfigured() {
        Configuration conf = new Configuration();
        ResourceCalculatorProcessTree tree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)"1", EmptyProcessTree.class, (Configuration)conf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)tree);
        Assertions.assertThat((Object)tree).isInstanceOf(EmptyProcessTree.class);
    }

    public static class EmptyProcessTree
    extends ResourceCalculatorProcessTree {
        public EmptyProcessTree(String pid) {
            super(pid);
        }

        public void updateProcessTree() {
        }

        public String getProcessTreeDump() {
            return "Empty tree for testing";
        }

        public long getRssMemorySize(int age) {
            return 0L;
        }

        public long getCumulativeRssmem(int age) {
            return 0L;
        }

        public long getVirtualMemorySize(int age) {
            return 0L;
        }

        public long getCumulativeVmem(int age) {
            return 0L;
        }

        public long getCumulativeCpuTime() {
            return 0L;
        }

        public float getCpuUsagePercent() {
            return -1.0f;
        }

        public boolean checkPidPgrpidForMatch() {
            return false;
        }
    }
}

