/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.testutils;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.testutils.PathWithFileStatus;

public class FileStatusUtils {
    public static PathWithFileStatus createPathWithFileStatusForAppId(Path remoteRootLogDir, ApplicationId appId, String user, String suffix, long modificationTime) {
        Path path = LogAggregationUtils.getRemoteAppLogDir((Path)remoteRootLogDir, (ApplicationId)appId, (String)user, (String)suffix);
        FileStatus fileStatus = FileStatusUtils.createEmptyFileStatus(modificationTime, path);
        return new PathWithFileStatus(path, fileStatus);
    }

    public static FileStatus createEmptyFileStatus(long modificationTime, Path path) {
        return new FileStatus(0L, true, 0, 0L, modificationTime, path);
    }

    public static PathWithFileStatus createFileLogPathWithFileStatus(Path baseDir, String childDir, long modificationTime) {
        Path logPath = new Path(baseDir, childDir);
        FileStatus fStatus = FileStatusUtils.createFileStatusWithLengthForFile(10L, modificationTime, logPath);
        return new PathWithFileStatus(logPath, fStatus);
    }

    public static PathWithFileStatus createDirLogPathWithFileStatus(Path baseDir, String childDir, long modificationTime) {
        Path logPath = new Path(baseDir, childDir);
        FileStatus fStatus = FileStatusUtils.createFileStatusWithLengthForDir(10L, modificationTime, logPath);
        return new PathWithFileStatus(logPath, fStatus);
    }

    public static PathWithFileStatus createDirBucketDirLogPathWithFileStatus(Path remoteRootLogPath, String user, String suffix, ApplicationId appId, long modificationTime) {
        Path bucketDir = LogAggregationUtils.getRemoteBucketDir((Path)remoteRootLogPath, (String)user, (String)suffix, (ApplicationId)appId);
        FileStatus fStatus = new FileStatus(0L, true, 0, 0L, modificationTime, bucketDir);
        return new PathWithFileStatus(bucketDir, fStatus);
    }

    public static FileStatus createFileStatusWithLengthForFile(long length, long modificationTime, Path logPath) {
        return new FileStatus(length, false, 1, 1L, modificationTime, logPath);
    }

    public static FileStatus createFileStatusWithLengthForDir(long length, long modificationTime, Path logPath) {
        return new FileStatus(length, true, 1, 1L, modificationTime, logPath);
    }
}

