/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.client.api.TimelineReaderClient;
import org.apache.hadoop.yarn.client.api.impl.TimelineReaderClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestTimelineReaderClientImpl {
    private final String appAttemptInfoFilter = "{\"type\":\"YARN_APPLICATION_ATTEMPT\",\"id\":\"appattempt_1234_0001_000001\"}";
    private TimelineReaderClient client;

    @BeforeEach
    public void setup() {
        this.client = new MockTimelineReaderClient();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 2.0f);
        this.client.init((Configuration)conf);
        this.client.start();
    }

    @Test
    void testGetApplication() throws Exception {
        ApplicationId applicationId = ApplicationId.fromString((String)"application_1234_0001");
        TimelineEntity entity = this.client.getApplicationEntity(applicationId, null, null);
        Assertions.assertEquals((Object)"mockApp1", (Object)entity.getId());
    }

    @Test
    void getApplicationAttemptEntity() throws Exception {
        ApplicationAttemptId attemptId = ApplicationAttemptId.fromString((String)"appattempt_1234_0001_000001");
        TimelineEntity entity = this.client.getApplicationAttemptEntity(attemptId, null, null);
        Assertions.assertEquals((Object)"mockAppAttempt1", (Object)entity.getId());
    }

    @Test
    void getApplicationAttemptEntities() throws Exception {
        ApplicationId applicationId = ApplicationId.fromString((String)"application_1234_0001");
        List entities = this.client.getApplicationAttemptEntities(applicationId, null, null, 0L, null);
        Assertions.assertEquals((int)2, (int)entities.size());
        Assertions.assertEquals((Object)"mockAppAttempt2", (Object)((TimelineEntity)entities.get(1)).getId());
    }

    @Test
    void testGetContainer() throws Exception {
        ContainerId containerId = ContainerId.fromString((String)"container_1234_0001_01_000001");
        TimelineEntity entity = this.client.getContainerEntity(containerId, null, null);
        Assertions.assertEquals((Object)"mockContainer1", (Object)entity.getId());
    }

    @Test
    void testGetContainers() throws Exception {
        ApplicationId appId = ApplicationId.fromString((String)"application_1234_0001");
        List entities = this.client.getContainerEntities(appId, null, null, 0L, null);
        Assertions.assertEquals((int)2, (int)entities.size());
        Assertions.assertEquals((Object)"mockContainer2", (Object)((TimelineEntity)entities.get(1)).getId());
    }

    @Test
    void testGetContainersForAppAttempt() throws Exception {
        ApplicationId appId = ApplicationId.fromString((String)"application_1234_0001");
        List entities = this.client.getContainerEntities(appId, null, (Map)ImmutableMap.of((Object)"infofilters", (Object)"{\"type\":\"YARN_APPLICATION_ATTEMPT\",\"id\":\"appattempt_1234_0001_000001\"}"), 0L, null);
        Assertions.assertEquals((int)2, (int)entities.size());
        Assertions.assertEquals((Object)"mockContainer4", (Object)((TimelineEntity)entities.get(1)).getId());
    }

    @AfterEach
    public void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    private static TimelineEntity createTimelineEntity(String id) {
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        return entity;
    }

    private static Set<TimelineEntity> createTimelineEntities(String ... ids) {
        LinkedHashSet<TimelineEntity> entities = new LinkedHashSet<TimelineEntity>();
        for (String id : ids) {
            TimelineEntity entity = new TimelineEntity();
            entity.setId(id);
            entities.add(entity);
        }
        return entities;
    }

    private class MockTimelineReaderClient
    extends TimelineReaderClientImpl {
        private MockTimelineReaderClient() {
        }

        protected Response doGetUri(URI base, String path, MultivaluedMap<String, String> params) throws IOException {
            Response mockClientResponse = (Response)Mockito.mock(Response.class);
            if (path.contains(TimelineEntityType.YARN_CONTAINER.toString()) && !params.containsKey((Object)"infofilters")) {
                Mockito.when((Object)((TimelineEntity)mockClientResponse.readEntity(TimelineEntity.class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntity("mockContainer1"));
                Mockito.when((Object)((Set)mockClientResponse.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){}))).thenReturn(TestTimelineReaderClientImpl.createTimelineEntities("mockContainer1", "mockContainer2"));
            } else if (path.contains(TimelineEntityType.YARN_CONTAINER.toString()) && params.containsKey((Object)"infofilters")) {
                Assertions.assertEquals((Object)this.encodeValue("{\"type\":\"YARN_APPLICATION_ATTEMPT\",\"id\":\"appattempt_1234_0001_000001\"}"), ((List)params.get((Object)"infofilters")).get(0));
                Mockito.when((Object)((Set)mockClientResponse.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){}))).thenReturn(TestTimelineReaderClientImpl.createTimelineEntities("mockContainer3", "mockContainer4"));
            } else if (path.contains(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString())) {
                Mockito.when((Object)((TimelineEntity)mockClientResponse.readEntity(TimelineEntity.class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntity("mockAppAttempt1"));
                Mockito.when((Object)((Set)mockClientResponse.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){}))).thenReturn(TestTimelineReaderClientImpl.createTimelineEntities("mockAppAttempt1", "mockAppAttempt2"));
            } else {
                Mockito.when((Object)((TimelineEntity)mockClientResponse.readEntity(TimelineEntity.class))).thenReturn((Object)TestTimelineReaderClientImpl.createTimelineEntity("mockApp1"));
                Mockito.when((Object)((Set)mockClientResponse.readEntity((GenericType)new GenericType<Set<TimelineEntity>>(){}))).thenReturn(TestTimelineReaderClientImpl.createTimelineEntities("mockApp1", "mockApp2"));
            }
            return mockClientResponse;
        }
    }
}

