/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.HashMap;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestResourceUtilization {
    @Test
    void testResourceUtilization() {
        ResourceUtilization u1 = ResourceUtilization.newInstance((int)10, (int)20, (float)0.5f);
        ResourceUtilization u2 = ResourceUtilization.newInstance((ResourceUtilization)u1);
        ResourceUtilization u3 = ResourceUtilization.newInstance((int)10, (int)20, (float)0.5f);
        ResourceUtilization u4 = ResourceUtilization.newInstance((int)20, (int)20, (float)0.5f);
        ResourceUtilization u5 = ResourceUtilization.newInstance((int)30, (int)40, (float)0.8f);
        Assertions.assertEquals((Object)u1, (Object)u2);
        Assertions.assertEquals((Object)u1, (Object)u3);
        Assertions.assertNotEquals((Object)u1, (Object)u4);
        Assertions.assertNotEquals((Object)u2, (Object)u5);
        Assertions.assertNotEquals((Object)u4, (Object)u5);
        Assertions.assertTrue((u1.hashCode() == u2.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((u1.hashCode() == u3.hashCode() ? 1 : 0) != 0);
        Assertions.assertFalse((u1.hashCode() == u4.hashCode() ? 1 : 0) != 0);
        Assertions.assertFalse((u2.hashCode() == u5.hashCode() ? 1 : 0) != 0);
        Assertions.assertFalse((u4.hashCode() == u5.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((u1.getPhysicalMemory() == 10 ? 1 : 0) != 0);
        Assertions.assertFalse((u1.getVirtualMemory() == 10 ? 1 : 0) != 0);
        Assertions.assertTrue((u1.getCPU() == 0.5f ? 1 : 0) != 0);
        Assertions.assertEquals((Object)("<pmem:10, vmem:" + u1.getVirtualMemory() + ", vCores:0.5>"), (Object)u1.toString());
        u1.addTo(10, 0, 0.0f);
        Assertions.assertNotEquals((Object)u1, (Object)u2);
        Assertions.assertEquals((Object)u1, (Object)u4);
        u1.addTo(10, 20, 0.3f);
        Assertions.assertEquals((Object)u1, (Object)u5);
        u1.subtractFrom(10, 20, 0.3f);
        Assertions.assertEquals((Object)u1, (Object)u4);
        u1.subtractFrom(10, 0, 0.0f);
        Assertions.assertEquals((Object)u1, (Object)u3);
    }

    @Test
    void testResourceUtilizationWithCustomResource() {
        HashMap<String, Float> customResources = new HashMap<String, Float>();
        customResources.put("yarn.io/gpu", Float.valueOf(5.0f));
        ResourceUtilization u1 = ResourceUtilization.newInstance((int)10, (int)20, (float)0.5f, customResources);
        ResourceUtilization u2 = ResourceUtilization.newInstance((ResourceUtilization)u1);
        ResourceUtilization u3 = ResourceUtilization.newInstance((int)10, (int)20, (float)0.5f, customResources);
        ResourceUtilization u4 = ResourceUtilization.newInstance((int)20, (int)20, (float)0.5f, customResources);
        ResourceUtilization u5 = ResourceUtilization.newInstance((int)30, (int)40, (float)0.8f, customResources);
        Assertions.assertEquals((Object)u1, (Object)u2);
        Assertions.assertEquals((Object)u1, (Object)u3);
        Assertions.assertNotEquals((Object)u1, (Object)u4);
        Assertions.assertNotEquals((Object)u2, (Object)u5);
        Assertions.assertNotEquals((Object)u4, (Object)u5);
        Assertions.assertTrue((u1.hashCode() == u2.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((u1.hashCode() == u3.hashCode() ? 1 : 0) != 0);
        Assertions.assertFalse((u1.hashCode() == u4.hashCode() ? 1 : 0) != 0);
        Assertions.assertFalse((u2.hashCode() == u5.hashCode() ? 1 : 0) != 0);
        Assertions.assertFalse((u4.hashCode() == u5.hashCode() ? 1 : 0) != 0);
        Assertions.assertTrue((u1.getPhysicalMemory() == 10 ? 1 : 0) != 0);
        Assertions.assertFalse((u1.getVirtualMemory() == 10 ? 1 : 0) != 0);
        Assertions.assertTrue((u1.getCPU() == 0.5f ? 1 : 0) != 0);
        Assertions.assertTrue((u1.getCustomResource("yarn.io/gpu") == 5.0f ? 1 : 0) != 0);
        Assertions.assertEquals((Object)("<pmem:10, vmem:" + u1.getVirtualMemory() + ", vCores:0.5, yarn.io/gpu:5.0>"), (Object)u1.toString());
        u1.addTo(10, 0, 0.0f);
        Assertions.assertNotEquals((Object)u1, (Object)u2);
        Assertions.assertEquals((Object)u1, (Object)u4);
        u1.addTo(10, 20, 0.3f);
        Assertions.assertEquals((Object)u1, (Object)u5);
        u1.subtractFrom(10, 20, 0.3f);
        Assertions.assertEquals((Object)u1, (Object)u4);
        u1.subtractFrom(10, 0, 0.0f);
        Assertions.assertEquals((Object)u1, (Object)u3);
    }
}

