/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationTimeout;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationTimeoutPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationReportPBImpl
extends ApplicationReport {
    YarnProtos.ApplicationReportProto proto = YarnProtos.ApplicationReportProto.getDefaultInstance();
    YarnProtos.ApplicationReportProto.Builder builder = null;
    boolean viaProto = false;
    private ApplicationId applicationId;
    private ApplicationAttemptId currentApplicationAttemptId;
    private Token clientToAMToken = null;
    private Token amRmToken = null;
    private Set<String> applicationTags = null;
    private Priority priority = null;
    private Map<ApplicationTimeoutType, ApplicationTimeout> applicationTimeouts = null;

    public ApplicationReportPBImpl() {
        this.builder = YarnProtos.ApplicationReportProto.newBuilder();
    }

    public ApplicationReportPBImpl(YarnProtos.ApplicationReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public ApplicationId getApplicationId() {
        YarnProtos.ApplicationReportProto p;
        if (this.applicationId != null) {
            return this.applicationId;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationId()) {
            return null;
        }
        this.applicationId = this.convertFromProtoFormat(p.getApplicationId());
        return this.applicationId;
    }

    public void setApplicationResourceUsageReport(ApplicationResourceUsageReport appInfo) {
        this.maybeInitBuilder();
        if (appInfo == null) {
            this.builder.clearAppResourceUsage();
            return;
        }
        this.builder.setAppResourceUsage(this.convertToProtoFormat(appInfo));
    }

    public ApplicationAttemptId getCurrentApplicationAttemptId() {
        YarnProtos.ApplicationReportProto p;
        if (this.currentApplicationAttemptId != null) {
            return this.currentApplicationAttemptId;
        }
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasCurrentApplicationAttemptId()) {
            return null;
        }
        this.currentApplicationAttemptId = this.convertFromProtoFormat(p.getCurrentApplicationAttemptId());
        return this.currentApplicationAttemptId;
    }

    public ApplicationResourceUsageReport getApplicationResourceUsageReport() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAppResourceUsage()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getAppResourceUsage());
    }

    public String getTrackingUrl() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasTrackingUrl()) {
            return null;
        }
        return p.getTrackingUrl();
    }

    public String getOriginalTrackingUrl() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasOriginalTrackingUrl()) {
            return null;
        }
        return p.getOriginalTrackingUrl();
    }

    public String getName() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasName()) {
            return null;
        }
        return p.getName();
    }

    public String getQueue() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasQueue()) {
            return null;
        }
        return p.getQueue();
    }

    public YarnApplicationState getYarnApplicationState() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasYarnApplicationState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getYarnApplicationState());
    }

    public String getHost() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasHost()) {
            return null;
        }
        return p.getHost();
    }

    public int getRpcPort() {
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getRpcPort();
    }

    public Token getClientToAMToken() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.clientToAMToken != null) {
            return this.clientToAMToken;
        }
        if (!p.hasClientToAmToken()) {
            return null;
        }
        this.clientToAMToken = this.convertFromProtoFormat(p.getClientToAmToken());
        return this.clientToAMToken;
    }

    public String getUser() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasUser()) {
            return null;
        }
        return p.getUser();
    }

    public String getDiagnostics() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDiagnostics()) {
            return null;
        }
        return p.getDiagnostics();
    }

    public long getStartTime() {
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getStartTime();
    }

    public long getSubmitTime() {
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getSubmitTime();
    }

    public long getLaunchTime() {
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getLaunchTime();
    }

    public void setLaunchTime(long launchTime) {
        this.maybeInitBuilder();
        this.builder.setLaunchTime(launchTime);
    }

    public long getFinishTime() {
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getFinishTime();
    }

    public FinalApplicationStatus getFinalApplicationStatus() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasFinalApplicationStatus()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getFinalApplicationStatus());
    }

    public float getProgress() {
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getProgress();
    }

    public String getApplicationType() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationType()) {
            return null;
        }
        return p.getApplicationType();
    }

    public Token getAMRMToken() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.amRmToken != null) {
            return this.amRmToken;
        }
        if (!p.hasAmRmToken()) {
            return null;
        }
        this.amRmToken = this.convertFromProtoFormat(p.getAmRmToken());
        return this.amRmToken;
    }

    private void initApplicationTags() {
        if (this.applicationTags != null) {
            return;
        }
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        this.applicationTags = new HashSet<String>();
        this.applicationTags.addAll(p.getApplicationTagsList());
    }

    public Set<String> getApplicationTags() {
        this.initApplicationTags();
        return this.applicationTags;
    }

    public void setApplicationId(ApplicationId applicationId) {
        this.maybeInitBuilder();
        if (applicationId == null) {
            this.builder.clearApplicationId();
        }
        this.applicationId = applicationId;
    }

    public void setCurrentApplicationAttemptId(ApplicationAttemptId applicationAttemptId) {
        this.maybeInitBuilder();
        if (applicationAttemptId == null) {
            this.builder.clearCurrentApplicationAttemptId();
        }
        this.currentApplicationAttemptId = applicationAttemptId;
    }

    public void setTrackingUrl(String url) {
        this.maybeInitBuilder();
        if (url == null) {
            this.builder.clearTrackingUrl();
            return;
        }
        this.builder.setTrackingUrl(url);
    }

    public void setOriginalTrackingUrl(String url) {
        this.maybeInitBuilder();
        if (url == null) {
            this.builder.clearOriginalTrackingUrl();
            return;
        }
        this.builder.setOriginalTrackingUrl(url);
    }

    public void setName(String name) {
        this.maybeInitBuilder();
        if (name == null) {
            this.builder.clearName();
            return;
        }
        this.builder.setName(name);
    }

    public void setQueue(String queue) {
        this.maybeInitBuilder();
        if (queue == null) {
            this.builder.clearQueue();
            return;
        }
        this.builder.setQueue(queue);
    }

    public void setYarnApplicationState(YarnApplicationState state) {
        this.maybeInitBuilder();
        if (state == null) {
            this.builder.clearYarnApplicationState();
            return;
        }
        this.builder.setYarnApplicationState(this.convertToProtoFormat(state));
    }

    public void setHost(String host) {
        this.maybeInitBuilder();
        if (host == null) {
            this.builder.clearHost();
            return;
        }
        this.builder.setHost(host);
    }

    public void setRpcPort(int rpcPort) {
        this.maybeInitBuilder();
        this.builder.setRpcPort(rpcPort);
    }

    public void setClientToAMToken(Token clientToAMToken) {
        this.maybeInitBuilder();
        if (clientToAMToken == null) {
            this.builder.clearClientToAmToken();
        }
        this.clientToAMToken = clientToAMToken;
    }

    public void setUser(String user) {
        this.maybeInitBuilder();
        if (user == null) {
            this.builder.clearUser();
            return;
        }
        this.builder.setUser(user);
    }

    public void setApplicationType(String applicationType) {
        this.maybeInitBuilder();
        if (applicationType == null) {
            this.builder.clearApplicationType();
            return;
        }
        this.builder.setApplicationType(applicationType);
    }

    public void setApplicationTags(Set<String> tags) {
        this.maybeInitBuilder();
        if (tags == null || tags.isEmpty()) {
            this.builder.clearApplicationTags();
        }
        this.applicationTags = tags;
    }

    public void setDiagnostics(String diagnostics) {
        this.maybeInitBuilder();
        if (diagnostics == null) {
            this.builder.clearDiagnostics();
            return;
        }
        this.builder.setDiagnostics(diagnostics);
    }

    public void setStartTime(long startTime) {
        this.maybeInitBuilder();
        this.builder.setStartTime(startTime);
    }

    public void setFinishTime(long finishTime) {
        this.maybeInitBuilder();
        this.builder.setFinishTime(finishTime);
    }

    public void setSubmitTime(long submitTime) {
        this.maybeInitBuilder();
        this.builder.setSubmitTime(submitTime);
    }

    public void setFinalApplicationStatus(FinalApplicationStatus finishState) {
        this.maybeInitBuilder();
        if (finishState == null) {
            this.builder.clearFinalApplicationStatus();
            return;
        }
        this.builder.setFinalApplicationStatus(this.convertToProtoFormat(finishState));
    }

    public void setProgress(float progress) {
        this.maybeInitBuilder();
        this.builder.setProgress(progress);
    }

    public void setAMRMToken(Token amRmToken) {
        this.maybeInitBuilder();
        if (amRmToken == null) {
            this.builder.clearAmRmToken();
        }
        this.amRmToken = amRmToken;
    }

    public YarnProtos.ApplicationReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ApplicationReportPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.applicationId != null && !((ApplicationIdPBImpl)this.applicationId).getProto().equals((Object)this.builder.getApplicationId())) {
            this.builder.setApplicationId(this.convertToProtoFormat(this.applicationId));
        }
        if (this.currentApplicationAttemptId != null && !((ApplicationAttemptIdPBImpl)this.currentApplicationAttemptId).getProto().equals((Object)this.builder.getCurrentApplicationAttemptId())) {
            this.builder.setCurrentApplicationAttemptId(this.convertToProtoFormat(this.currentApplicationAttemptId));
        }
        if (this.clientToAMToken != null && !((TokenPBImpl)this.clientToAMToken).getProto().equals((Object)this.builder.getClientToAmToken())) {
            this.builder.setClientToAmToken(this.convertToProtoFormat(this.clientToAMToken));
        }
        if (this.amRmToken != null && !((TokenPBImpl)this.amRmToken).getProto().equals((Object)this.builder.getAmRmToken())) {
            this.builder.setAmRmToken(this.convertToProtoFormat(this.amRmToken));
        }
        if (this.applicationTags != null && !this.applicationTags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.builder.addAllApplicationTags(this.applicationTags);
        }
        if (this.priority != null && !((PriorityPBImpl)this.priority).getProto().equals((Object)this.builder.getPriority())) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.applicationTimeouts != null) {
            this.addApplicationTimeouts();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ApplicationReportProto.newBuilder((YarnProtos.ApplicationReportProto)this.proto);
        }
        this.viaProto = false;
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private YarnProtos.ApplicationAttemptIdProto convertToProtoFormat(ApplicationAttemptId t) {
        return ((ApplicationAttemptIdPBImpl)t).getProto();
    }

    private ApplicationResourceUsageReport convertFromProtoFormat(YarnProtos.ApplicationResourceUsageReportProto s) {
        return ProtoUtils.convertFromProtoFormat(s);
    }

    private YarnProtos.ApplicationResourceUsageReportProto convertToProtoFormat(ApplicationResourceUsageReport s) {
        return ProtoUtils.convertToProtoFormat(s);
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto applicationId) {
        return new ApplicationIdPBImpl(applicationId);
    }

    private ApplicationAttemptIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationAttemptIdProto applicationAttemptId) {
        return new ApplicationAttemptIdPBImpl(applicationAttemptId);
    }

    private YarnApplicationState convertFromProtoFormat(YarnProtos.YarnApplicationStateProto s) {
        return ProtoUtils.convertFromProtoFormat(s);
    }

    private YarnProtos.YarnApplicationStateProto convertToProtoFormat(YarnApplicationState s) {
        return ProtoUtils.convertToProtoFormat(s);
    }

    private FinalApplicationStatus convertFromProtoFormat(YarnProtos.FinalApplicationStatusProto s) {
        return ProtoUtils.convertFromProtoFormat(s);
    }

    private YarnProtos.FinalApplicationStatusProto convertToProtoFormat(FinalApplicationStatus s) {
        return ProtoUtils.convertToProtoFormat(s);
    }

    private TokenPBImpl convertFromProtoFormat(SecurityProtos.TokenProto p) {
        return new TokenPBImpl(p);
    }

    private SecurityProtos.TokenProto convertToProtoFormat(Token t) {
        return ((TokenPBImpl)t).getProto();
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority t) {
        return ((PriorityPBImpl)t).getProto();
    }

    public LogAggregationStatus getLogAggregationStatus() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasLogAggregationStatus()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getLogAggregationStatus());
    }

    public void setLogAggregationStatus(LogAggregationStatus logAggregationStatus) {
        this.maybeInitBuilder();
        if (logAggregationStatus == null) {
            this.builder.clearLogAggregationStatus();
            return;
        }
        this.builder.setLogAggregationStatus(this.convertToProtoFormat(logAggregationStatus));
    }

    private LogAggregationStatus convertFromProtoFormat(YarnProtos.LogAggregationStatusProto s) {
        return ProtoUtils.convertFromProtoFormat(s);
    }

    private YarnProtos.LogAggregationStatusProto convertToProtoFormat(LogAggregationStatus s) {
        return ProtoUtils.convertToProtoFormat(s);
    }

    public boolean isUnmanagedApp() {
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        return p.getUnmanagedApplication();
    }

    public void setUnmanagedApp(boolean unmanagedApplication) {
        this.maybeInitBuilder();
        this.builder.setUnmanagedApplication(unmanagedApplication);
    }

    public Priority getPriority() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    public String getAppNodeLabelExpression() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAppNodeLabelExpression()) {
            return null;
        }
        return p.getAppNodeLabelExpression();
    }

    public void setAppNodeLabelExpression(String appNodeLabelExpression) {
        this.maybeInitBuilder();
        if (appNodeLabelExpression == null) {
            this.builder.clearAppNodeLabelExpression();
            return;
        }
        this.builder.setAppNodeLabelExpression(appNodeLabelExpression);
    }

    public String getAmNodeLabelExpression() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasAmNodeLabelExpression()) {
            return null;
        }
        return p.getAmNodeLabelExpression();
    }

    public void setAmNodeLabelExpression(String amNodeLabelExpression) {
        this.maybeInitBuilder();
        if (amNodeLabelExpression == null) {
            this.builder.clearAmNodeLabelExpression();
            return;
        }
        this.builder.setAmNodeLabelExpression(amNodeLabelExpression);
    }

    public Map<ApplicationTimeoutType, ApplicationTimeout> getApplicationTimeouts() {
        this.initApplicationTimeout();
        return this.applicationTimeouts;
    }

    public void setApplicationTimeouts(Map<ApplicationTimeoutType, ApplicationTimeout> timeouts) {
        if (timeouts == null) {
            return;
        }
        this.initApplicationTimeout();
        this.applicationTimeouts.clear();
        this.applicationTimeouts.putAll(timeouts);
    }

    private void initApplicationTimeout() {
        if (this.applicationTimeouts != null) {
            return;
        }
        YarnProtos.ApplicationReportProto p = this.viaProto ? this.proto : this.builder;
        List lists = p.getAppTimeoutsList();
        this.applicationTimeouts = new HashMap<ApplicationTimeoutType, ApplicationTimeout>(lists.size());
        for (YarnProtos.AppTimeoutsMapProto timeoutProto : lists) {
            this.applicationTimeouts.put(ProtoUtils.convertFromProtoFormat(timeoutProto.getApplicationTimeoutType()), this.convertFromProtoFormat(timeoutProto.getApplicationTimeout()));
        }
    }

    private ApplicationTimeoutPBImpl convertFromProtoFormat(YarnProtos.ApplicationTimeoutProto p) {
        return new ApplicationTimeoutPBImpl(p);
    }

    private YarnProtos.ApplicationTimeoutProto convertToProtoFormat(ApplicationTimeout t) {
        return ((ApplicationTimeoutPBImpl)t).getProto();
    }

    private void addApplicationTimeouts() {
        this.maybeInitBuilder();
        this.builder.clearAppTimeouts();
        if (this.applicationTimeouts == null) {
            return;
        }
        Iterable<YarnProtos.AppTimeoutsMapProto> values = new Iterable<YarnProtos.AppTimeoutsMapProto>(){

            @Override
            public Iterator<YarnProtos.AppTimeoutsMapProto> iterator() {
                return new Iterator<YarnProtos.AppTimeoutsMapProto>(){
                    private Iterator<ApplicationTimeoutType> iterator;
                    {
                        this.iterator = ApplicationReportPBImpl.this.applicationTimeouts.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public YarnProtos.AppTimeoutsMapProto next() {
                        ApplicationTimeoutType key = this.iterator.next();
                        return YarnProtos.AppTimeoutsMapProto.newBuilder().setApplicationTimeout(ApplicationReportPBImpl.this.convertToProtoFormat(ApplicationReportPBImpl.this.applicationTimeouts.get(key))).setApplicationTimeoutType(ProtoUtils.convertToProtoFormat(key)).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllAppTimeouts((Iterable)values);
    }

    public String getRMClusterId() {
        YarnProtos.ApplicationReportProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasRmClusterId()) {
            return null;
        }
        return p.getRmClusterId();
    }

    public void setRMClusterId(String rmClusterId) {
        this.maybeInitBuilder();
        if (rmClusterId == null) {
            this.builder.clearRmClusterId();
            return;
        }
        this.builder.setRmClusterId(rmClusterId);
    }
}

