/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.test;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.RequestScoped;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWebAppTests {
    static final Logger LOG = LoggerFactory.getLogger(TestWebAppTests.class);

    @Test
    void testInstances() throws Exception {
        Injector injector = WebAppTests.createMockInjector(this);
        HttpServletRequest req = (HttpServletRequest)injector.getInstance(HttpServletRequest.class);
        HttpServletResponse res = (HttpServletResponse)injector.getInstance(HttpServletResponse.class);
        String val = req.getParameter("foo");
        PrintWriter out = res.getWriter();
        out.println("Hello world!");
        this.logInstances(req, res, out);
        Assertions.assertSame((Object)req, (Object)injector.getInstance(HttpServletRequest.class));
        Assertions.assertSame((Object)res, (Object)injector.getInstance(HttpServletResponse.class));
        Assertions.assertSame((Object)this, (Object)injector.getInstance(TestWebAppTests.class));
        ((HttpServletRequest)Mockito.verify((Object)req)).getParameter("foo");
        ((HttpServletResponse)Mockito.verify((Object)res)).getWriter();
        ((PrintWriter)Mockito.verify((Object)out)).println("Hello world!");
    }

    @Test
    void testCreateInjector() throws Exception {
        Bar bar = new Bar();
        Injector injector = WebAppTests.createMockInjector(Foo.class, bar, new Module[0]);
        this.logInstances((HttpServletRequest)injector.getInstance(HttpServletRequest.class), (HttpServletResponse)injector.getInstance(HttpServletResponse.class), ((HttpServletResponse)injector.getInstance(HttpServletResponse.class)).getWriter());
        Assertions.assertSame((Object)bar, (Object)injector.getInstance(Foo.class));
    }

    @Test
    void testCreateInjector2() {
        final FooBar foobar = new FooBar();
        Bar bar = new Bar();
        Injector injector = WebAppTests.createMockInjector(Foo.class, bar, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(Bar.class).toInstance((Object)foobar);
            }
        }});
        Assertions.assertNotSame((Object)bar, (Object)injector.getInstance(Bar.class));
        Assertions.assertSame((Object)foobar, (Object)injector.getInstance(Bar.class));
    }

    @Test
    void testRequestScope() {
        Injector injector = WebAppTests.createMockInjector(this);
        Assertions.assertSame((Object)injector.getInstance(ScopeTest.class), (Object)injector.getInstance(ScopeTest.class));
    }

    private void logInstances(HttpServletRequest req, HttpServletResponse res, PrintWriter out) {
        LOG.info("request: {}", (Object)req);
        LOG.info("response: {}", (Object)res);
        LOG.info("writer: {}", (Object)out);
    }

    static class Bar
    implements Foo {
        Bar() {
        }
    }

    static interface Foo {
    }

    static class FooBar
    extends Bar {
        FooBar() {
        }
    }

    @RequestScoped
    static class ScopeTest {
        ScopeTest() {
        }
    }
}

