/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.hamlet2;

import java.io.PrintWriter;
import java.util.EnumSet;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHamlet {
    @Test
    void testHamlet() {
        Hamlet h = (Hamlet)((Hamlet)TestHamlet.newHamlet().title("test").h1("heading 1").p("#id.class").b("hello").em("world!").__()).div("#footer").__(new Object[]{"Brought to you by"}).a("https://hostname/", "Somebody").__();
        PrintWriter out = h.getWriter();
        out.flush();
        Assertions.assertEquals((int)0, (int)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out)).print("<title");
        ((PrintWriter)Mockito.verify((Object)out)).print("test");
        ((PrintWriter)Mockito.verify((Object)out)).print("</title>");
        ((PrintWriter)Mockito.verify((Object)out)).print("<h1");
        ((PrintWriter)Mockito.verify((Object)out)).print("heading 1");
        ((PrintWriter)Mockito.verify((Object)out)).print("</h1>");
        ((PrintWriter)Mockito.verify((Object)out)).print("<p");
        ((PrintWriter)Mockito.verify((Object)out)).print(" id=\"id\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(" class=\"class\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("<b");
        ((PrintWriter)Mockito.verify((Object)out)).print("hello");
        ((PrintWriter)Mockito.verify((Object)out)).print("</b>");
        ((PrintWriter)Mockito.verify((Object)out)).print("<em");
        ((PrintWriter)Mockito.verify((Object)out)).print("world!");
        ((PrintWriter)Mockito.verify((Object)out)).print("</em>");
        ((PrintWriter)Mockito.verify((Object)out)).print("<div");
        ((PrintWriter)Mockito.verify((Object)out)).print(" id=\"footer\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("Brought to you by");
        ((PrintWriter)Mockito.verify((Object)out)).print("<a");
        ((PrintWriter)Mockito.verify((Object)out)).print(" href=\"https://hostname/\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("Somebody");
        ((PrintWriter)Mockito.verify((Object)out)).print("</a>");
        ((PrintWriter)Mockito.verify((Object)out)).print("</div>");
        ((PrintWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.never())).print("</p>");
    }

    @Test
    void testTable() {
        Hamlet h = TestHamlet.newHamlet().title("test table").link("style.css");
        Hamlet.TABLE t = h.table("#id");
        for (int i = 0; i < 3; ++i) {
            t.tr().td("1").td("2").__();
        }
        t.__();
        PrintWriter out = h.getWriter();
        out.flush();
        Assertions.assertEquals((int)0, (int)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out)).print("<table");
        ((PrintWriter)Mockito.verify((Object)out)).print("</table>");
        ((PrintWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.atLeast((int)1))).print("</td>");
        ((PrintWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.atLeast((int)1))).print("</tr>");
    }

    @Test
    void testEnumAttrs() {
        Hamlet h = (Hamlet)((Hamlet)TestHamlet.newHamlet().meta_http("Content-type", "text/html; charset=utf-8").title("test enum attrs").link().$rel("stylesheet").$media(EnumSet.of(HamletSpec.Media.screen, HamletSpec.Media.print)).$type("text/css").$href("style.css").__()).link().$rel(EnumSet.of(HamletSpec.LinkType.index, HamletSpec.LinkType.start)).$href("index.html").__();
        h.div("#content").__(new Object[]{"content"}).__();
        PrintWriter out = h.getWriter();
        out.flush();
        Assertions.assertEquals((int)0, (int)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out)).print(" media=\"screen, print\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(" rel=\"start index\"");
    }

    @Test
    void testScriptStyle() {
        Hamlet h = TestHamlet.newHamlet().script("a.js").script("b.js").style(new Object[]{"h1 { font-size: 1.2em }"});
        PrintWriter out = h.getWriter();
        out.flush();
        Assertions.assertEquals((int)0, (int)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out, (VerificationMode)Mockito.times((int)2))).print(" type=\"text/javascript\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(" type=\"text/css\"");
    }

    @Test
    void testPreformatted() {
        Hamlet h = (Hamlet)((Hamlet.DIV)TestHamlet.newHamlet().div().i("inline before pre").pre().__(new Object[]{"pre text1\npre text2"}).i("inline in pre").__(new Object[]{"pre text after inline"}).__()).i("inline after pre").__();
        PrintWriter out = h.getWriter();
        out.flush();
        Assertions.assertEquals((int)5, (int)h.indents);
    }

    @Test
    void testSubViews() {
        Hamlet h = (Hamlet)((Hamlet)TestHamlet.newHamlet().title("test sub-views").div("#view1").__(TestView1.class).__()).div("#view2").__(TestView2.class).__();
        PrintWriter out = h.getWriter();
        out.flush();
        Assertions.assertEquals((int)0, (int)h.nestLevel);
        ((PrintWriter)Mockito.verify((Object)out)).print("[" + TestView1.class.getName() + "]");
        ((PrintWriter)Mockito.verify((Object)out)).print("[" + TestView2.class.getName() + "]");
    }

    static Hamlet newHamlet() {
        PrintWriter out = (PrintWriter)Mockito.spy((Object)new PrintWriter(System.out));
        return new Hamlet(out, 0, false);
    }

    static class TestView1
    implements SubView {
        TestView1() {
        }

        public void renderPartial() {
        }
    }

    static class TestView2
    implements SubView {
        TestView2() {
        }

        public void renderPartial() {
        }
    }
}

