/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestLogAggregationFileController {
    @Test
    void testRemoteDirCreationDefault() throws Exception {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doThrow(FileNotFoundException.class).when((Object)fs)).getFileStatus((Path)ArgumentMatchers.any(Path.class));
        Configuration conf = new Configuration();
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)ArgumentMatchers.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        ((FileSystem)Mockito.verify((Object)fs)).setOwner((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"yarn_user"), (String)ArgumentMatchers.eq((Object)"yarn_group"));
    }

    @Test
    void testRemoteDirCreationWithCustomGroup() throws Exception {
        String testGroupName = "testGroup";
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doThrow(FileNotFoundException.class).when((Object)fs)).getFileStatus((Path)ArgumentMatchers.any(Path.class));
        Configuration conf = new Configuration();
        conf.set("yarn.nodemanager.remote-app-log-dir.groupname", testGroupName);
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)ArgumentMatchers.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        ((FileSystem)Mockito.verify((Object)fs)).setOwner((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"yarn_user"), (String)ArgumentMatchers.eq((Object)testGroupName));
    }

    @Test
    void testRemoteDirCreationWithCustomUser() throws Exception {
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        TestLogAggregationFileController.setupCustomUserMocks(controller, fs, "/tmp/logs");
        controller.initialize(new Configuration(), "TFile");
        controller.fsSupportsChmod = false;
        controller.verifyAndCreateRemoteLogDir();
        TestLogAggregationFileController.assertPermissionFileWasUsedOneTime(fs);
        Assertions.assertTrue((boolean)controller.fsSupportsChmod);
        ((FileSystem)Mockito.doThrow(UnsupportedOperationException.class).when((Object)fs)).setPermission((Path)ArgumentMatchers.any(), (FsPermission)ArgumentMatchers.any());
        controller.verifyAndCreateRemoteLogDir();
        TestLogAggregationFileController.assertPermissionFileWasUsedOneTime(fs);
        Assertions.assertTrue((boolean)controller.fsSupportsChmod);
        controller.fsSupportsChmod = false;
        controller.verifyAndCreateRemoteLogDir();
        TestLogAggregationFileController.assertPermissionFileWasUsedOneTime(fs);
        Assertions.assertTrue((boolean)controller.fsSupportsChmod);
    }

    @Test
    void testRemoteDirCreationWithCustomUserFsChmodNotSupported() throws Exception {
        LogAggregationFileController controller = (LogAggregationFileController)Mockito.mock(LogAggregationFileController.class, (Answer)Mockito.CALLS_REAL_METHODS);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        TestLogAggregationFileController.setupCustomUserMocks(controller, fs, "/tmp/logs2");
        ((FileSystem)Mockito.doThrow(UnsupportedOperationException.class).when((Object)fs)).setPermission((Path)ArgumentMatchers.any(), (FsPermission)ArgumentMatchers.any());
        Configuration conf = new Configuration();
        conf.set("yarn.nodemanager.remote-app-log-dir", "/tmp/logs2");
        controller.initialize(conf, "TFile");
        controller.verifyAndCreateRemoteLogDir();
        TestLogAggregationFileController.assertPermissionFileWasUsedOneTime(fs);
        Assertions.assertFalse((boolean)controller.fsSupportsChmod);
        controller.verifyAndCreateRemoteLogDir();
        TestLogAggregationFileController.assertPermissionFileWasUsedOneTime(fs);
        Assertions.assertFalse((boolean)controller.fsSupportsChmod);
        controller.fsSupportsChmod = true;
        controller.verifyAndCreateRemoteLogDir();
        TestLogAggregationFileController.assertPermissionFileWasUsedOneTime(fs);
        Assertions.assertFalse((boolean)controller.fsSupportsChmod);
    }

    private static void setupCustomUserMocks(LogAggregationFileController controller, FileSystem fs, String path) throws URISyntaxException, IOException {
        ((FileSystem)Mockito.doReturn((Object)new URI("")).when((Object)fs)).getUri();
        ((FileSystem)Mockito.doReturn((Object)new FileStatus(128L, false, 0, 64L, System.currentTimeMillis(), System.currentTimeMillis(), new FsPermission(LogAggregationFileController.TLDIR_PERMISSIONS), "not_yarn_user", "yarn_group", new Path(path))).when((Object)fs)).getFileStatus((Path)ArgumentMatchers.any(Path.class));
        ((LogAggregationFileController)Mockito.doReturn((Object)fs).when((Object)controller)).getFileSystem((Configuration)ArgumentMatchers.any(Configuration.class));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"yarn_user", (String[])new String[]{"yarn_group", "other_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
    }

    private static void assertPermissionFileWasUsedOneTime(FileSystem fs) throws IOException {
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).createNewFile((Path)ArgumentMatchers.argThat((ArgumentMatcher)new PathContainsString(".permission_check")));
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).setPermission((Path)ArgumentMatchers.argThat((ArgumentMatcher)new PathContainsString(".permission_check")), (FsPermission)ArgumentMatchers.eq((Object)new FsPermission(LogAggregationFileController.TLDIR_PERMISSIONS)));
        ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).delete((Path)ArgumentMatchers.argThat((ArgumentMatcher)new PathContainsString(".permission_check")), ArgumentMatchers.eq((boolean)false));
    }

    private static class PathContainsString
    implements ArgumentMatcher<Path> {
        private final String expected;

        PathContainsString(String expected) {
            this.expected = expected;
        }

        public boolean matches(Path path) {
            return path.getName().contains(this.expected);
        }

        public String toString() {
            return "Path with name=" + this.expected;
        }
    }
}

