/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.test.TestGenericTestUtils;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.impl.DirectTimelineWriter;
import org.apache.hadoop.yarn.client.api.impl.TimelineClientImpl;
import org.apache.hadoop.yarn.client.api.impl.TimelineConnector;
import org.apache.hadoop.yarn.client.api.impl.TimelineWriter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTimelineClient {
    private TimelineClientImpl client;
    private TimelineWriter spyTimelineWriter;
    private String keystoresDir;
    private String sslConfDir;

    @BeforeEach
    public void setup() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setFloat("yarn.timeline-service.version", 1.0f);
        this.client = this.createTimelineClient(conf);
        this.client.getConnector().setSocketTimeOut(10);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.stop();
        }
        if (this.isSSLConfigured()) {
            KeyStoreTestUtil.cleanupSSLConfig((String)this.keystoresDir, (String)this.sslConfDir);
        }
        this.client.getConnector().setSocketTimeOut(60000);
    }

    @Test
    void testPostEntities() throws Exception {
        TestTimelineClient.mockEntityClientResponse(this.spyTimelineWriter, ClientResponse.Status.OK, false, false);
        try {
            TimelinePutResponse response = this.client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assertions.assertEquals((int)0, (int)response.getErrors().size());
        }
        catch (YarnException e) {
            Assertions.fail((String)"Exception is not expected");
        }
    }

    @Test
    void testPostEntitiesWithError() throws Exception {
        TestTimelineClient.mockEntityClientResponse(this.spyTimelineWriter, ClientResponse.Status.OK, true, false);
        try {
            TimelinePutResponse response = this.client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assertions.assertEquals((int)1, (int)response.getErrors().size());
            Assertions.assertEquals((Object)"test entity id", (Object)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getEntityId());
            Assertions.assertEquals((Object)"test entity type", (Object)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getEntityType());
            Assertions.assertEquals((int)2, (int)((TimelinePutResponse.TimelinePutError)response.getErrors().get(0)).getErrorCode());
        }
        catch (YarnException e) {
            Assertions.fail((String)"Exception is not expected");
        }
    }

    @Test
    void testPostIncompleteEntities() throws Exception {
        try {
            this.client.putEntities(new TimelineEntity[]{new TimelineEntity()});
            Assertions.fail((String)"Exception should have been thrown");
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
    }

    @Test
    void testPostEntitiesNoResponse() throws Exception {
        TestTimelineClient.mockEntityClientResponse(this.spyTimelineWriter, ClientResponse.Status.INTERNAL_SERVER_ERROR, false, false);
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assertions.fail((String)"Exception is expected");
        }
        catch (YarnException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Failed to get the response from the timeline server."));
        }
    }

    @Test
    void testPostEntitiesConnectionRefused() throws Exception {
        TestTimelineClient.mockEntityClientResponse(this.spyTimelineWriter, null, false, true);
        try {
            this.client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assertions.fail((String)"RuntimeException is expected");
        }
        catch (RuntimeException re) {
            Assertions.assertTrue((boolean)(re instanceof ClientHandlerException));
        }
    }

    @Test
    void testPutDomain() throws Exception {
        TestTimelineClient.mockDomainClientResponse(this.spyTimelineWriter, ClientResponse.Status.OK, false);
        try {
            this.client.putDomain(TestTimelineClient.generateDomain());
        }
        catch (YarnException e) {
            Assertions.fail((String)"Exception is not expected");
        }
    }

    @Test
    void testPutDomainNoResponse() throws Exception {
        TestTimelineClient.mockDomainClientResponse(this.spyTimelineWriter, ClientResponse.Status.FORBIDDEN, false);
        try {
            this.client.putDomain(TestTimelineClient.generateDomain());
            Assertions.fail((String)"Exception is expected");
        }
        catch (YarnException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Failed to get the response from the timeline server."));
        }
    }

    @Test
    void testPutDomainConnectionRefused() throws Exception {
        TestTimelineClient.mockDomainClientResponse(this.spyTimelineWriter, null, true);
        try {
            this.client.putDomain(TestTimelineClient.generateDomain());
            Assertions.fail((String)"RuntimeException is expected");
        }
        catch (RuntimeException re) {
            Assertions.assertTrue((boolean)(re instanceof ClientHandlerException));
        }
    }

    @Test
    void testCheckRetryCount() throws Exception {
        YarnConfiguration conf;
        try {
            conf = new YarnConfiguration();
            conf.setBoolean("yarn.timeline-service.enabled", true);
            conf.setInt("yarn.timeline-service.client.max-retries", -2);
            this.createTimelineClient(conf);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.client.max-retries"));
        }
        try {
            conf = new YarnConfiguration();
            conf.setBoolean("yarn.timeline-service.enabled", true);
            conf.setLong("yarn.timeline-service.client.retry-interval-ms", 0L);
            this.createTimelineClient(conf);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.client.retry-interval-ms"));
        }
        int newMaxRetries = 5;
        long newIntervalMs = 500L;
        YarnConfiguration conf2 = new YarnConfiguration();
        conf2.setInt("yarn.timeline-service.client.max-retries", newMaxRetries);
        conf2.setLong("yarn.timeline-service.client.retry-interval-ms", newIntervalMs);
        conf2.setBoolean("yarn.timeline-service.enabled", true);
        TimelineClientImpl client = this.createTimelineClient(conf2);
        try {
            client.putEntities(new TimelineEntity[]{TestTimelineClient.generateEntity()});
            Assertions.fail((String)"Exception expected! Timeline server should be off to run this test. ");
        }
        catch (RuntimeException ce) {
            Assertions.assertTrue((boolean)ce.getMessage().contains("Connection retries limit exceeded"), (String)("Handler exception for reason other than retry: " + ce.getMessage()));
            Assertions.assertTrue((boolean)client.connector.connectionRetry.getRetired(), (String)"Retry filter didn't perform any retries! ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testDelegationTokenOperationsRetry() throws Exception {
        int newMaxRetries = 5;
        long newIntervalMs = 500L;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.timeline-service.client.max-retries", newMaxRetries);
        conf.setLong("yarn.timeline-service.client.retry-interval-ms", newIntervalMs);
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("yarn.timeline-service.http-authentication.type", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        TimelineClientImpl client = this.createTimelineClient(conf);
        TimelineClientImpl clientFake = this.createTimelineClientFakeTimelineClientRetryOp(conf);
        TestTimelineDelegationTokenSecretManager dtManager = new TestTimelineDelegationTokenSecretManager();
        try {
            TimelineDelegationTokenIdentifier timelineDT;
            dtManager.startThreads();
            Thread.sleep(3000L);
            try {
                client.getDelegationToken(UserGroupInformation.getCurrentUser().getShortUserName());
                TestTimelineClient.assertFail();
            }
            catch (RuntimeException ce) {
                this.assertException(client, ce);
            }
            try {
                timelineDT = new TimelineDelegationTokenIdentifier(new Text("tester"), new Text("tester"), new Text("tester"));
                client.renewDelegationToken(new Token(timelineDT.getBytes(), dtManager.createPassword(timelineDT), timelineDT.getKind(), new Text("0.0.0.0:8188")));
                TestTimelineClient.assertFail();
            }
            catch (RuntimeException ce) {
                this.assertException(client, ce);
            }
            try {
                timelineDT = new TimelineDelegationTokenIdentifier(new Text("tester"), new Text("tester"), new Text("tester"));
                client.cancelDelegationToken(new Token(timelineDT.getBytes(), dtManager.createPassword(timelineDT), timelineDT.getKind(), new Text("0.0.0.0:8188")));
                TestTimelineClient.assertFail();
            }
            catch (RuntimeException ce) {
                this.assertException(client, ce);
            }
            try {
                timelineDT = new TimelineDelegationTokenIdentifier(new Text("tester"), new Text("tester"), new Text("tester"));
                clientFake.cancelDelegationToken(new Token(timelineDT.getBytes(), dtManager.createPassword(timelineDT), timelineDT.getKind(), new Text("0.0.0.0:8188")));
                TestTimelineClient.assertFail();
            }
            catch (RuntimeException ce) {
                this.assertException(clientFake, ce);
            }
        }
        finally {
            client.stop();
            clientFake.stop();
            dtManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testDelegationTokenDisabledOnSimpleAuth() throws Exception {
        TimelineConnector spyConnector;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.set("yarn.timeline-service.http-authentication.type", "simple");
        UserGroupInformation.setConfiguration((Configuration)conf);
        TimelineClientImpl tClient = this.createTimelineClient(conf);
        tClient.connector = spyConnector = (TimelineConnector)Mockito.spy((Object)tClient.connector);
        try {
            Token identifierToken = tClient.getDelegationToken(UserGroupInformation.getCurrentUser().getShortUserName());
            Assertions.assertNull((Object)identifierToken);
            Token dummyToken = new Token();
            long renewTime = tClient.renewDelegationToken(dummyToken);
            Assertions.assertEquals((long)renewTime, (long)-1L);
            tClient.cancelDelegationToken(dummyToken);
            ((TimelineConnector)Mockito.verify((Object)spyConnector, (VerificationMode)Mockito.never())).getDelegationTokenAuthenticatedURL();
        }
        finally {
            tClient.stop();
        }
    }

    private static void assertFail() {
        Assertions.fail((String)"Exception expected! Timeline server should be off to run this test.");
    }

    private void assertException(TimelineClientImpl client, RuntimeException ce) {
        Assertions.assertTrue((boolean)ce.getMessage().contains("Connection retries limit exceeded"), (String)("Handler exception for reason other than retry: " + ce.toString()));
        Assertions.assertTrue((boolean)client.connector.connectionRetry.getRetired(), (String)"Retry filter didn't perform any retries! ");
    }

    public static ClientResponse mockEntityClientResponse(TimelineWriter spyTimelineWriter, ClientResponse.Status status, boolean hasError, boolean hasRuntimeError) {
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        if (hasRuntimeError) {
            ((TimelineWriter)Mockito.doThrow((Throwable[])new Throwable[]{new ClientHandlerException((Throwable)new ConnectException())}).when((Object)spyTimelineWriter)).doPostingObject(ArgumentMatchers.any(TimelineEntities.class), (String)ArgumentMatchers.any());
            return response;
        }
        ((TimelineWriter)Mockito.doReturn((Object)response).when((Object)spyTimelineWriter)).doPostingObject(ArgumentMatchers.any(TimelineEntities.class), (String)ArgumentMatchers.any());
        Mockito.when((Object)response.getStatusInfo()).thenReturn((Object)status);
        TimelinePutResponse.TimelinePutError error = new TimelinePutResponse.TimelinePutError();
        error.setEntityId("test entity id");
        error.setEntityType("test entity type");
        error.setErrorCode(2);
        TimelinePutResponse putResponse = new TimelinePutResponse();
        if (hasError) {
            putResponse.addError(error);
        }
        Mockito.when((Object)((TimelinePutResponse)response.getEntity(TimelinePutResponse.class))).thenReturn((Object)putResponse);
        return response;
    }

    private static ClientResponse mockDomainClientResponse(TimelineWriter spyTimelineWriter, ClientResponse.Status status, boolean hasRuntimeError) {
        ClientResponse response = (ClientResponse)Mockito.mock(ClientResponse.class);
        if (hasRuntimeError) {
            ((TimelineWriter)Mockito.doThrow((Throwable[])new Throwable[]{new ClientHandlerException((Throwable)new ConnectException())}).when((Object)spyTimelineWriter)).doPostingObject(ArgumentMatchers.any(TimelineDomain.class), (String)ArgumentMatchers.any(String.class));
            return response;
        }
        ((TimelineWriter)Mockito.doReturn((Object)response).when((Object)spyTimelineWriter)).doPostingObject(ArgumentMatchers.any(TimelineDomain.class), (String)ArgumentMatchers.any(String.class));
        Mockito.when((Object)response.getStatusInfo()).thenReturn((Object)status);
        return response;
    }

    private static TimelineEntity generateEntity() {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId("entity id");
        entity.setEntityType("entity type");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        for (int i = 0; i < 2; ++i) {
            TimelineEvent event = new TimelineEvent();
            event.setTimestamp(System.currentTimeMillis());
            event.setEventType("test event type " + i);
            event.addEventInfo("key1", (Object)"val1");
            event.addEventInfo("key2", (Object)"val2");
            entity.addEvent(event);
        }
        entity.addRelatedEntity("test ref type 1", "test ref id 1");
        entity.addRelatedEntity("test ref type 2", "test ref id 2");
        entity.addPrimaryFilter("pkey1", (Object)"pval1");
        entity.addPrimaryFilter("pkey2", (Object)"pval2");
        entity.addOtherInfo("okey1", (Object)"oval1");
        entity.addOtherInfo("okey2", (Object)"oval2");
        entity.setDomainId("domain id 1");
        return entity;
    }

    public static TimelineDomain generateDomain() {
        TimelineDomain domain = new TimelineDomain();
        domain.setId("namespace id");
        domain.setDescription("domain description");
        domain.setOwner("domain owner");
        domain.setReaders("domain_reader");
        domain.setWriters("domain_writer");
        domain.setCreatedTime(Long.valueOf(0L));
        domain.setModifiedTime(Long.valueOf(1L));
        return domain;
    }

    private TimelineClientImpl createTimelineClient(YarnConfiguration conf) {
        TimelineClientImpl client = new TimelineClientImpl(){

            protected TimelineWriter createTimelineWriter(Configuration conf, UserGroupInformation authUgi, Client client, URI resURI) throws IOException {
                DirectTimelineWriter timelineWriter = new DirectTimelineWriter(authUgi, client, resURI);
                TestTimelineClient.this.spyTimelineWriter = (TimelineWriter)Mockito.spy((Object)timelineWriter);
                return TestTimelineClient.this.spyTimelineWriter;
            }
        };
        client.init((Configuration)conf);
        client.start();
        return client;
    }

    private TimelineClientImpl createTimelineClientFakeTimelineClientRetryOp(YarnConfiguration conf) {
        TimelineClientImpl client = new TimelineClientImpl(){

            protected TimelineConnector createTimelineConnector() {
                TimelineConnector connector = new TimelineConnector(true, this.authUgi, this.doAsUser, this.token){

                    public TimelineConnector.TimelineClientRetryOp createRetryOpForOperateDelegationToken(PrivilegedExceptionAction<?> action) throws IOException {
                        TimelineConnector.TimelineClientRetryOpForOperateDelegationToken op = (TimelineConnector.TimelineClientRetryOpForOperateDelegationToken)Mockito.spy((Object)new TimelineConnector.TimelineClientRetryOpForOperateDelegationToken(UserGroupInformation.getCurrentUser(), action));
                        ((TimelineConnector.TimelineClientRetryOpForOperateDelegationToken)Mockito.doThrow((Throwable[])new Throwable[]{new SocketTimeoutException("Test socketTimeoutException")}).when((Object)op)).run();
                        return op;
                    }
                };
                this.addIfService(connector);
                return connector;
            }
        };
        client.init((Configuration)conf);
        client.start();
        return client;
    }

    @Test
    void testTimelineClientCleanup() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        conf.setInt("yarn.timeline-service.client.max-retries", 0);
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        this.setupSSLConfig(conf);
        this.client = this.createTimelineClient(conf);
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        Thread reloaderThread = null;
        for (Thread thread : threads) {
            if (thread.getName() == null || !thread.getName().contains("SSL Certificates Store Monitor")) continue;
            reloaderThread = thread;
        }
        Assertions.assertTrue((boolean)reloaderThread.isAlive(), (String)"Reloader is not alive");
        this.client.close();
        boolean reloaderStillAlive = true;
        for (int i = 0; i < 10 && (reloaderStillAlive = reloaderThread.isAlive()); ++i) {
            Thread.sleep(1000L);
        }
        Assertions.assertFalse((boolean)reloaderStillAlive, (String)"Reloader is still alive");
    }

    @Test
    void testTimelineConnectorDestroy() {
        Client mockJerseyClient;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        TimelineClientImpl client = this.createTimelineClient(conf);
        client.connector.client = mockJerseyClient = (Client)Mockito.mock(Client.class);
        client.stop();
        ((Client)Mockito.verify((Object)mockJerseyClient, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    private void setupSSLConfig(YarnConfiguration conf) throws Exception {
        this.keystoresDir = TestGenericTestUtils.getTestDir().getAbsolutePath();
        this.sslConfDir = KeyStoreTestUtil.getClasspathDir(TestTimelineClient.class);
        KeyStoreTestUtil.setupSSLConfig((String)this.keystoresDir, (String)this.sslConfDir, (Configuration)conf, (boolean)false);
    }

    private boolean isSSLConfigured() {
        return this.keystoresDir != null && this.sslConfDir != null;
    }

    private static class TestTimelineDelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> {
        public TestTimelineDelegationTokenSecretManager() {
            super(100000L, 100000L, 100000L, 100000L);
        }

        public TimelineDelegationTokenIdentifier createIdentifier() {
            return new TimelineDelegationTokenIdentifier();
        }

        public synchronized byte[] createPassword(TimelineDelegationTokenIdentifier identifier) {
            return super.createPassword((AbstractDelegationTokenIdentifier)identifier);
        }
    }
}

