/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetApplicationsRequestPBImpl;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestGetApplicationsRequestPBImpl {
    public GetApplicationsRequestPBImpl impl;

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testAppTagsLowerCaseConversionDefault(GetApplicationsRequestPBImpl applicationsRequestPBImpl) {
        this.initTestGetApplicationsRequestPBImpl(applicationsRequestPBImpl);
        applicationsRequestPBImpl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        applicationsRequestPBImpl.getApplicationTags().forEach(s -> Assertions.assertEquals((Object)s, (Object)s.toLowerCase()));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testAppTagsLowerCaseConversionDisabled(GetApplicationsRequestPBImpl applicationsRequestPBImpl) {
        this.initTestGetApplicationsRequestPBImpl(applicationsRequestPBImpl);
        GetApplicationsRequestPBImpl.setForceLowerCaseTags((boolean)false);
        applicationsRequestPBImpl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        applicationsRequestPBImpl.getApplicationTags().forEach(s -> Assertions.assertNotEquals((Object)s, (Object)s.toLowerCase()));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testAppTagsLowerCaseConversionEnabled(GetApplicationsRequestPBImpl applicationsRequestPBImpl) {
        this.initTestGetApplicationsRequestPBImpl(applicationsRequestPBImpl);
        GetApplicationsRequestPBImpl.setForceLowerCaseTags((boolean)true);
        applicationsRequestPBImpl.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        applicationsRequestPBImpl.getApplicationTags().forEach(s -> Assertions.assertEquals((Object)s, (Object)s.toLowerCase()));
    }

    public static Collection<Object[]> data() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{new GetApplicationsRequestPBImpl()});
        list.add(new Object[]{new GetApplicationsRequestPBImpl(YarnServiceProtos.GetApplicationsRequestProto.newBuilder().build())});
        return list;
    }

    public void initTestGetApplicationsRequestPBImpl(GetApplicationsRequestPBImpl applicationsRequestPBImpl) {
        this.impl = this.impl;
    }
}

