/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestApplicatonReport {
    @Test
    void testApplicationReport() {
        long timestamp = System.currentTimeMillis();
        ApplicationReport appReport1 = TestApplicatonReport.createApplicationReport(1, 1, timestamp);
        ApplicationReport appReport2 = TestApplicatonReport.createApplicationReport(1, 1, timestamp);
        ApplicationReport appReport3 = TestApplicatonReport.createApplicationReport(1, 1, timestamp);
        Assertions.assertEquals((Object)appReport1, (Object)appReport2);
        Assertions.assertEquals((Object)appReport2, (Object)appReport3);
        appReport1.setApplicationId(null);
        Assertions.assertNull((Object)appReport1.getApplicationId());
        Assertions.assertNotSame((Object)appReport1, (Object)appReport2);
        appReport2.setCurrentApplicationAttemptId(null);
        Assertions.assertNull((Object)appReport2.getCurrentApplicationAttemptId());
        Assertions.assertNotSame((Object)appReport2, (Object)appReport3);
        Assertions.assertNull((Object)appReport1.getAMRMToken());
    }

    protected static ApplicationReport createApplicationReport(int appIdInt, int appAttemptIdInt, long timestamp) {
        ApplicationId appId = ApplicationId.newInstance((long)timestamp, (int)appIdInt);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)appAttemptIdInt);
        ApplicationReport appReport = ApplicationReport.newInstance((ApplicationId)appId, (ApplicationAttemptId)appAttemptId, (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.53789f, (String)"YARN", null, null, (boolean)false, (Priority)Priority.newInstance((int)0), (String)"", (String)"");
        return appReport;
    }
}

