/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.WindowsBasedProcessTree;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWindowsBasedProcessTree {
    private static final Logger LOG = LoggerFactory.getLogger(TestWindowsBasedProcessTree.class);

    @Test
    @Timeout(value=30000L)
    void tree() {
        PlatformAssumptions.assumeWindows();
        Assertions.assertTrue((boolean)WindowsBasedProcessTree.isAvailable(), (String)"WindowsBasedProcessTree should be available on Windows");
        ControlledClock testClock = new ControlledClock();
        long elapsedTimeBetweenUpdatesMsec = 0L;
        testClock.setTime(elapsedTimeBetweenUpdatesMsec);
        WindowsBasedProcessTreeTester pTree = new WindowsBasedProcessTreeTester("-1", testClock);
        pTree.infoStr = "3524,1024,1024,500\r\n2844,1024,1024,500\r\n";
        pTree.updateProcessTree();
        Assertions.assertTrue((pTree.getVirtualMemorySize() == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getVirtualMemorySize(0) == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getRssMemorySize() == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getRssMemorySize(0) == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getCumulativeCpuTime() == 1000L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getCpuUsagePercent() == -1.0f ? 1 : 0) != 0);
        pTree.infoStr = "3524,1024,1024,1000\r\n2844,1024,1024,1000\r\n1234,1024,1024,1000\r\n";
        elapsedTimeBetweenUpdatesMsec = 1000L;
        testClock.setTime(elapsedTimeBetweenUpdatesMsec);
        pTree.updateProcessTree();
        Assertions.assertTrue((pTree.getVirtualMemorySize() == 3072L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getVirtualMemorySize(1) == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getRssMemorySize() == 3072L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getRssMemorySize(1) == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getCumulativeCpuTime() == 3000L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getCpuUsagePercent() == 200.0f ? 1 : 0) != 0);
        Assertions.assertEquals((double)pTree.getCpuUsagePercent(), (double)200.0, (double)0.01, (String)"Percent CPU time is not correct");
        pTree.infoStr = "3524,1024,1024,1500\r\n2844,1024,1024,1500\r\n";
        elapsedTimeBetweenUpdatesMsec = 2000L;
        testClock.setTime(elapsedTimeBetweenUpdatesMsec);
        pTree.updateProcessTree();
        Assertions.assertTrue((pTree.getVirtualMemorySize() == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getVirtualMemorySize(2) == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getRssMemorySize() == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getRssMemorySize(2) == 2048L ? 1 : 0) != 0);
        Assertions.assertTrue((pTree.getCumulativeCpuTime() == 4000L ? 1 : 0) != 0);
        Assertions.assertEquals((double)pTree.getCpuUsagePercent(), (double)0.0, (double)0.01, (String)"Percent CPU time is not correct");
    }

    class WindowsBasedProcessTreeTester
    extends WindowsBasedProcessTree {
        String infoStr;

        public WindowsBasedProcessTreeTester(String pid, Clock clock) {
            super(pid, clock);
            this.infoStr = null;
        }

        String getAllProcessInfoFromShell() {
            return this.infoStr;
        }
    }
}

